/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlgui.player.amp.equalizer.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import javax.swing.JPanel;
import javazoom.jlgui.player.amp.equalizer.ui.NaturalSpline;
import javazoom.jlgui.player.amp.skin.AbsoluteConstraints;

public class SplinePanel
extends JPanel {
    private AbsoluteConstraints constraints = null;
    private Image backgroundImage = null;
    private Image barImage = null;
    private int[] values = null;
    private Color[] gradient = null;

    public SplinePanel() {
        this.setDoubleBuffered(true);
        this.setLayout(null);
    }

    public Color[] getGradient() {
        return this.gradient;
    }

    public void setGradient(Color[] colorArray) {
        this.gradient = colorArray;
    }

    public void setConstraints(AbsoluteConstraints absoluteConstraints) {
        this.constraints = absoluteConstraints;
    }

    public AbsoluteConstraints getConstraints() {
        return this.constraints;
    }

    public Image getBarImage() {
        return this.barImage;
    }

    public void setBarImage(Image image) {
        this.barImage = image;
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImage = image;
    }

    public int[] getValues() {
        return this.values;
    }

    public void setValues(int[] nArray) {
        this.values = nArray;
    }

    public void paintComponent(Graphics graphics) {
        if (this.backgroundImage != null) {
            graphics.drawImage(this.backgroundImage, 0, 0, null);
        }
        if (this.barImage != null) {
            graphics.drawImage(this.barImage, 0, this.getHeight() / 2, null);
        }
        if (this.values != null && this.values.length > 0) {
            int n;
            NaturalSpline naturalSpline = new NaturalSpline();
            float f = 1.0f * (float)this.getWidth() / (float)(this.values.length - 2);
            int n2 = this.getHeight();
            naturalSpline.setMaxHeight(n2);
            naturalSpline.setMinHeight(0);
            for (int i = 1; i < this.values.length; ++i) {
                n = Math.round(f * (float)(i - 1));
                int n3 = Math.round(n2 * this.values[i] / 100);
                n3 = naturalSpline.boundY(n3);
                naturalSpline.addPoint(n, n3);
            }
            Polygon polygon = naturalSpline.getPolyline();
            if (this.gradient != null) {
                for (n = 0; n < polygon.npoints - 1; ++n) {
                    graphics.setColor(this.gradient[polygon.ypoints[n]]);
                    graphics.drawLine(polygon.xpoints[n], polygon.ypoints[n], polygon.xpoints[n + 1], polygon.ypoints[n + 1]);
                }
            } else {
                graphics.drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints);
            }
        }
    }
}

