/*
 * Decompiled with CFR 0.152.
 */
package davaguine.jmac.decoder;

import davaguine.jmac.decoder.APEDecompress;
import davaguine.jmac.info.APEInfo;
import davaguine.jmac.tools.File;
import davaguine.jmac.tools.JMACException;
import java.io.IOException;

public class APEDecompressNative
extends APEDecompress {
    private final int ID;
    private int m_nRealFrame;

    public APEDecompressNative(APEInfo pAPEInfo) {
        this(pAPEInfo, -1, -1);
    }

    public APEDecompressNative(APEInfo pAPEInfo, int nStartBlock) {
        this(pAPEInfo, nStartBlock, -1);
    }

    public APEDecompressNative(APEInfo pAPEInfo, int nStartBlock, int nFinishBlock) {
        super(pAPEInfo, nStartBlock, nFinishBlock);
        this.ID = this.registerDecoder(this.getApeInfoIoSource(), this.getApeInfoFileVersion(), this.getApeInfoCompressionLevel(), nStartBlock, nFinishBlock, this.getApeInfoTotalBlocks(), this.getApeInfoBlockAlign(), this.getApeInfoBlocksPerFrame(), this.getApeInfoSampleRate(), this.getApeInfoBitsPerSample(), this.getApeInfoChannels());
        if (this.ID < 0) {
            throw new JMACException("The Native APE Decoder Can't Be Instantiated");
        }
        this.m_nRealFrame = 0;
    }

    public void finalize() {
        this.finalize(this.ID, this.getApeInfoIoSource());
    }

    public int GetData(byte[] pBuffer, int nBlocks) throws IOException {
        int nBlocksRetrieved = this.GetData(this.ID, this.getApeInfoIoSource(), pBuffer, nBlocks);
        this.m_nCurrentBlock += nBlocksRetrieved;
        return nBlocksRetrieved;
    }

    public void Seek(int nBlockOffset) throws IOException {
        this.Seek(this.ID, this.getApeInfoIoSource(), nBlockOffset);
    }

    private native int registerDecoder(File var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11);

    private native void finalize(int var1, File var2);

    private native int GetData(int var1, File var2, byte[] var3, int var4);

    private native void Seek(int var1, File var2, int var3) throws IOException;

    static {
        System.loadLibrary("jmac");
    }
}

