/*
 * Decompiled with CFR 0.152.
 */
package org.kc7bfi.jflac.sound.spi;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.spi.FormatConversionProvider;
import org.kc7bfi.jflac.sound.spi.Flac2PcmAudioInputStream;
import org.kc7bfi.jflac.sound.spi.FlacEncoding;

public class FlacFormatConvertionProvider
extends FormatConversionProvider {
    public AudioFormat.Encoding[] getSourceEncodings() {
        AudioFormat.Encoding[] encodings = new AudioFormat.Encoding[]{FlacEncoding.FLAC, AudioFormat.Encoding.PCM_SIGNED};
        return encodings;
    }

    public AudioFormat.Encoding[] getTargetEncodings() {
        AudioFormat.Encoding[] encodings = new AudioFormat.Encoding[]{FlacEncoding.FLAC, AudioFormat.Encoding.PCM_SIGNED};
        return encodings;
    }

    public AudioFormat.Encoding[] getTargetEncodings(AudioFormat sourceFormat) {
        if (sourceFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            AudioFormat.Encoding[] encodings = new AudioFormat.Encoding[]{FlacEncoding.FLAC};
            return encodings;
        }
        if (sourceFormat.getEncoding() instanceof FlacEncoding) {
            AudioFormat.Encoding[] encodings = new AudioFormat.Encoding[]{AudioFormat.Encoding.PCM_SIGNED};
            return encodings;
        }
        AudioFormat.Encoding[] encodings = new AudioFormat.Encoding[]{};
        return encodings;
    }

    public AudioFormat[] getTargetFormats(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        if (sourceFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) && targetEncoding instanceof FlacEncoding) {
            if (sourceFormat.getChannels() > 2 || sourceFormat.getChannels() <= 0 || sourceFormat.isBigEndian()) {
                AudioFormat[] formats = new AudioFormat[]{};
                return formats;
            }
            AudioFormat[] formats = new AudioFormat[]{new AudioFormat(targetEncoding, sourceFormat.getSampleRate(), -1, sourceFormat.getChannels(), -1, -1.0f, false)};
            return formats;
        }
        if (sourceFormat.getEncoding() instanceof FlacEncoding && targetEncoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
            AudioFormat[] formats = new AudioFormat[]{new AudioFormat(sourceFormat.getSampleRate(), 16, sourceFormat.getChannels(), true, false)};
            return formats;
        }
        AudioFormat[] formats = new AudioFormat[]{};
        return formats;
    }

    public AudioInputStream getAudioInputStream(AudioFormat.Encoding targetEncoding, AudioInputStream sourceStream) {
        if (this.isConversionSupported(targetEncoding, sourceStream.getFormat())) {
            AudioFormat[] formats = this.getTargetFormats(targetEncoding, sourceStream.getFormat());
            if (formats != null && formats.length > 0) {
                AudioFormat targetFormat;
                AudioFormat sourceFormat = sourceStream.getFormat();
                if (sourceFormat.equals(targetFormat = formats[0])) {
                    return sourceStream;
                }
                if (sourceFormat.getEncoding() instanceof FlacEncoding && targetFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
                    return new Flac2PcmAudioInputStream(sourceStream, targetFormat, -1L);
                }
                if (sourceFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) && targetFormat.getEncoding() instanceof FlacEncoding) {
                    throw new IllegalArgumentException("unable to convert " + sourceFormat.toString() + " to " + targetFormat.toString());
                }
                throw new IllegalArgumentException("unable to convert " + sourceFormat.toString() + " to " + targetFormat.toString());
            }
            throw new IllegalArgumentException("target format not found");
        }
        throw new IllegalArgumentException("conversion not supported");
    }

    public AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream sourceStream) {
        if (this.isConversionSupported(targetFormat, sourceStream.getFormat())) {
            AudioFormat[] formats = this.getTargetFormats(targetFormat.getEncoding(), sourceStream.getFormat());
            if (formats != null && formats.length > 0) {
                AudioFormat sourceFormat = sourceStream.getFormat();
                if (sourceFormat.equals(targetFormat)) {
                    return sourceStream;
                }
                if (sourceFormat.getEncoding() instanceof FlacEncoding && targetFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
                    return new Flac2PcmAudioInputStream(sourceStream, targetFormat, -1L);
                }
                if (sourceFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) && targetFormat.getEncoding() instanceof FlacEncoding) {
                    throw new IllegalArgumentException("unable to convert " + sourceFormat.toString() + " to " + targetFormat.toString());
                }
                throw new IllegalArgumentException("unable to convert " + sourceFormat.toString() + " to " + targetFormat.toString());
            }
            throw new IllegalArgumentException("target format not found");
        }
        throw new IllegalArgumentException("conversion not supported");
    }
}

