/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.visualization;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.image.BufferedImage;
import java.nio.FloatBuffer;
import javax.sound.sampled.SourceDataLine;
import xtrememp.player.dsp.DssContext;

public abstract class Visualization
implements Comparable<Visualization> {
    protected Color backgroundColor = Color.black;
    protected Color foregroundColor = Color.white;
    protected BufferedImage buffImage;
    protected Graphics2D buffGraphics;

    public abstract String getDisplayName();

    public void init(int sampleSize, SourceDataLine sourceDataLine) {
    }

    public abstract void render(DssContext var1, Graphics2D var2, int var3, int var4);

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public FloatBuffer channelsMerge(FloatBuffer[] channelsBuffer) {
        int ch = channelsBuffer.length;
        int cap = channelsBuffer[0].capacity();
        for (int a = 0; a < cap; ++a) {
            float mcd = 0.0f;
            for (int b = 0; b < ch; ++b) {
                mcd += channelsBuffer[b].get(a);
            }
            channelsBuffer[0].put(a, mcd / (float)ch);
        }
        return channelsBuffer[0].asReadOnlyBuffer();
    }

    public BufferedImage getBuffImage() {
        return this.buffImage;
    }

    public Graphics2D getBuffGraphics() {
        return this.buffGraphics;
    }

    public void checkBuffImage(GraphicsConfiguration gc, int width, int height) {
        if (this.buffImage == null || this.buffImage.getWidth() != width || this.buffImage.getHeight() != height) {
            this.freeImage();
            this.buffImage = gc.createCompatibleImage(width, height);
            this.buffGraphics = this.buffImage.createGraphics();
            this.buffGraphics.setColor(this.backgroundColor);
            this.buffGraphics.fillRect(0, 0, this.buffImage.getWidth(), this.buffImage.getHeight());
        }
    }

    public void freeImage() {
        if (this.buffGraphics != null) {
            this.buffGraphics.dispose();
            this.buffGraphics = null;
        }
        if (this.buffImage != null) {
            this.buffImage.flush();
            this.buffImage = null;
        }
    }

    @Override
    public int compareTo(Visualization vis) {
        return this.getDisplayName().compareTo(vis.getDisplayName());
    }
}

