/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.util.file;

import java.io.File;
import java.io.FilenameFilter;
import javax.swing.filechooser.FileFilter;

public class AudioFileFilter
extends FileFilter
implements FilenameFilter {
    public static final AudioFileFilter INSTANCE = new AudioFileFilter();
    public static final String[] AudioFileExt = new String[]{".spx", ".snd", ".aifc", ".aif", ".wav", ".au", ".flac", ".mp1", ".mp2", ".mp3", ".ogg"};

    private AudioFileFilter() {
    }

    @Override
    public boolean accept(File dir, String name) {
        File file = new File(dir, name);
        if (file.exists() && file.isDirectory()) {
            return true;
        }
        String s = name.toLowerCase();
        for (String ext : AudioFileExt) {
            if (!s.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String s = file.getName().toLowerCase();
        for (String ext : AudioFileExt) {
            if (!s.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        StringBuilder description = new StringBuilder("Supported Audio Files");
        if (AudioFileExt.length > 0) {
            description.append(" (");
            for (String ext : AudioFileExt) {
                description.append(" *").append(ext);
            }
            description.append(" )");
        }
        return description.toString();
    }
}

