/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.util;

public class OSUtils {
    private static final String OS_NAME_WINDOWS_PREFIX = "Windows";
    public static final String OS_ARCH = OSUtils.getSystemProperty("os.arch");
    public static final String OS_NAME = OSUtils.getSystemProperty("os.name");
    public static final String OS_VERSION = OSUtils.getSystemProperty("os.version");
    public static final String USER_DIR = OSUtils.getSystemProperty("user.dir");
    public static final boolean IS_ARCH_X86 = OSUtils.getOSMatchesArch("86");
    public static final boolean IS_ARCH_X64 = OSUtils.getOSMatchesArch("64");
    public static final boolean IS_OS_LINUX = OSUtils.getOSMatchesName("Linux") || OSUtils.getOSMatchesName("LINUX");
    public static final boolean IS_OS_WINDOWS = OSUtils.getOSMatchesName("Windows");
    public static final boolean IS_OS_WINDOWS_XP = OSUtils.getOSMatches("Windows", "5.1");
    public static final boolean IS_OS_WINDOWS_VISTA = OSUtils.getOSMatches("Windows", "6.0");
    public static final boolean IS_OS_WINDOWS_7 = OSUtils.getOSMatches("Windows", "6.1");

    private static boolean getOSMatches(String osNamePrefix, String osVersionPrefix) {
        if (OS_NAME == null || OS_VERSION == null) {
            return false;
        }
        return OS_NAME.startsWith(osNamePrefix) && OS_VERSION.startsWith(osVersionPrefix);
    }

    private static boolean getOSMatchesName(String osNamePrefix) {
        if (OS_NAME == null) {
            return false;
        }
        return OS_NAME.startsWith(osNamePrefix);
    }

    private static boolean getOSMatchesArch(String osArchPrefix) {
        if (OS_ARCH == null) {
            return false;
        }
        return OS_ARCH.contains(osArchPrefix);
    }

    private static String getSystemProperty(String property) {
        try {
            return System.getProperty(property);
        }
        catch (SecurityException ex) {
            System.err.println("Caught a SecurityException reading the system property '" + property + "'; the SystemUtils property value will default to null.");
            return null;
        }
    }
}

