/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.ui.skin;

import java.awt.Color;
import java.net.URL;
import org.pushingpixels.substance.api.ColorSchemeSingleColorQuery;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceColorSchemeBundle;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.painter.border.StandardBorderPainter;
import org.pushingpixels.substance.api.painter.decoration.MatteDecorationPainter;
import org.pushingpixels.substance.api.painter.fill.GlassFillPainter;
import org.pushingpixels.substance.api.painter.highlight.ClassicHighlightPainter;
import org.pushingpixels.substance.api.painter.overlay.BottomLineOverlayPainter;
import org.pushingpixels.substance.api.painter.overlay.SubstanceOverlayPainter;
import org.pushingpixels.substance.api.painter.overlay.TopBezelOverlayPainter;
import org.pushingpixels.substance.api.painter.overlay.TopLineOverlayPainter;
import org.pushingpixels.substance.api.shaper.ClassicButtonShaper;

public class DarkSapphireSkin
extends SubstanceSkin {
    public static final String NAME = "Dark Sapphire";
    private BottomLineOverlayPainter toolbarBottomLineOverlayPainter;
    private TopLineOverlayPainter toolbarTopLineOverlayPainter;
    private TopBezelOverlayPainter footerTopBezelOverlayPainter;

    public DarkSapphireSkin() {
        SubstanceSkin.ColorSchemes schemes = SubstanceSkin.getColorSchemes((URL)DarkSapphireSkin.class.getClassLoader().getResource("xtrememp/ui/skin/dark-sapphire.colorschemes"));
        SubstanceColorScheme activeScheme = schemes.get("Dark Sapphire Active");
        SubstanceColorScheme defaultScheme = schemes.get("Dark Sapphire Default");
        SubstanceColorSchemeBundle defaultSchemeBundle = new SubstanceColorSchemeBundle(activeScheme, defaultScheme, defaultScheme);
        defaultSchemeBundle.registerColorScheme(defaultScheme, 0.5f, new ComponentState[]{ComponentState.DISABLED_UNSELECTED});
        this.registerDecorationAreaSchemeBundle(defaultSchemeBundle, new DecorationAreaType[]{DecorationAreaType.NONE});
        this.registerDecorationAreaSchemeBundle(defaultSchemeBundle, new DecorationAreaType[]{DecorationAreaType.PRIMARY_TITLE_PANE, DecorationAreaType.SECONDARY_TITLE_PANE, DecorationAreaType.HEADER, DecorationAreaType.FOOTER, DecorationAreaType.GENERAL, DecorationAreaType.TOOLBAR});
        this.toolbarBottomLineOverlayPainter = new BottomLineOverlayPainter(new ColorSchemeSingleColorQuery(){

            public Color query(SubstanceColorScheme scheme) {
                return scheme.getUltraDarkColor().darker();
            }
        });
        this.addOverlayPainter((SubstanceOverlayPainter)this.toolbarBottomLineOverlayPainter, new DecorationAreaType[]{DecorationAreaType.TOOLBAR});
        this.toolbarTopLineOverlayPainter = new TopLineOverlayPainter(new ColorSchemeSingleColorQuery(){

            public Color query(SubstanceColorScheme scheme) {
                Color fg = scheme.getForegroundColor();
                return new Color(fg.getRed(), fg.getGreen(), fg.getBlue(), 32);
            }
        });
        this.addOverlayPainter((SubstanceOverlayPainter)this.toolbarTopLineOverlayPainter, new DecorationAreaType[]{DecorationAreaType.TOOLBAR});
        this.footerTopBezelOverlayPainter = new TopBezelOverlayPainter(new ColorSchemeSingleColorQuery(){

            public Color query(SubstanceColorScheme scheme) {
                return scheme.getUltraDarkColor().darker();
            }
        }, new ColorSchemeSingleColorQuery(){

            public Color query(SubstanceColorScheme scheme) {
                Color fg = scheme.getForegroundColor();
                return new Color(fg.getRed(), fg.getGreen(), fg.getBlue(), 32);
            }
        });
        this.addOverlayPainter((SubstanceOverlayPainter)this.footerTopBezelOverlayPainter, new DecorationAreaType[]{DecorationAreaType.FOOTER});
        this.buttonShaper = new ClassicButtonShaper();
        this.fillPainter = new GlassFillPainter();
        this.decorationPainter = new MatteDecorationPainter();
        this.highlightPainter = new ClassicHighlightPainter();
        this.borderPainter = new StandardBorderPainter();
    }

    public String getDisplayName() {
        return NAME;
    }
}

