/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.tag;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.audio.mp3.MP3AudioHeader;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagException;
import org.tritonus.share.sampled.file.TAudioFileFormat;
import xtrememp.tag.TagInfo;
import xtrememp.util.Utilities;

public class MpegInfo
extends TagInfo {
    protected String encoder = null;
    protected String version = null;
    protected String layer = null;
    protected String emphasis = null;
    protected String vendor = null;
    protected boolean copyright = false;
    protected boolean crc = false;
    protected boolean original = false;
    protected boolean privat = false;
    protected boolean vbr = false;

    @Override
    public void load(File file) throws IOException, UnsupportedAudioFileException {
        this.size = file.length();
        this.location = file.getPath();
        try {
            MP3File mp3File = (MP3File)AudioFileIO.read((File)file);
            MP3AudioHeader audioHeader = mp3File.getMP3AudioHeader();
            Tag mpegTag = mp3File.getTag();
            if (audioHeader != null) {
                this.encodingType = audioHeader.getEncodingType();
                this.encoder = audioHeader.getEncoder();
                this.channels = audioHeader.getChannels();
                this.channelsAsNumber = this.channels.equals("Stereo") ? 2 : (this.channels.equals("Joint Stereo") ? 2 : (this.channels.equals("Dual") ? 2 : (this.channels.equals("Mono") ? 1 : 0)));
                this.sampleRateAsNumber = audioHeader.getSampleRateAsNumber();
                this.bitRateAsNumber = (int)audioHeader.getBitRateAsNumber();
                this.layer = audioHeader.getMpegLayer();
                this.version = audioHeader.getMpegVersion();
                this.crc = audioHeader.isProtected();
                this.vbr = audioHeader.isVariableBitRate();
                this.copyright = audioHeader.isCopyrighted();
                this.original = audioHeader.isOriginal();
                this.privat = audioHeader.isPrivate();
                this.emphasis = audioHeader.getEmphasis();
                this.duration = audioHeader.getTrackLength();
            }
            if (mpegTag != null) {
                this.title = mpegTag.getFirst(FieldKey.TITLE);
                this.artist = mpegTag.getFirst(FieldKey.ARTIST);
                this.album = mpegTag.getFirst(FieldKey.ALBUM);
                this.year = mpegTag.getFirst(FieldKey.YEAR);
                this.genre = mpegTag.getFirst(FieldKey.GENRE);
                this.track = mpegTag.getFirst(FieldKey.TRACK);
                this.comment = mpegTag.getFirst(FieldKey.COMMENT);
            }
        }
        catch (CannotReadException ex) {
            throw new IOException(ex);
        }
        catch (TagException ex) {
            throw new UnsupportedAudioFileException("Not MP3 audio format");
        }
        catch (ReadOnlyFileException ex) {
            throw new IOException(ex);
        }
        catch (InvalidAudioFrameException ex) {
            throw new UnsupportedAudioFileException("Not MP3 audio format");
        }
    }

    @Override
    public void load(URL input) throws IOException, UnsupportedAudioFileException {
        this.location = input.toString();
        AudioFileFormat aff = AudioSystem.getAudioFileFormat(input);
        this.loadInfo(aff);
        this.loadShoutastInfo(aff);
    }

    @Override
    public void load(InputStream input) throws IOException, UnsupportedAudioFileException {
        AudioFileFormat aff = AudioSystem.getAudioFileFormat(input);
        this.loadInfo(aff);
    }

    protected void loadInfo(AudioFileFormat aff) throws UnsupportedAudioFileException {
        this.encodingType = aff.getType().toString();
        if (!this.encodingType.equalsIgnoreCase("mp3")) {
            throw new UnsupportedAudioFileException("Not MP3 audio format");
        }
        if (aff instanceof TAudioFileFormat) {
            Map props = ((TAudioFileFormat)aff).properties();
            if (props.containsKey("mp3.channels")) {
                this.channelsAsNumber = (Integer)props.get("mp3.channels");
            }
            if (props.containsKey("mp3.frequency.hz")) {
                this.sampleRateAsNumber = (Integer)props.get("mp3.frequency.hz");
            }
            if (props.containsKey("mp3.bitrate.nominal.bps")) {
                this.bitRateAsNumber = (Integer)props.get("mp3.bitrate.nominal.bps") / 1000;
            }
            if (props.containsKey("mp3.version.layer")) {
                this.layer = "Layer " + props.get("mp3.version.layer");
            }
            if (props.containsKey("mp3.version.mpeg")) {
                this.version = (String)props.get("mp3.version.mpeg");
                if (this.version.equals("1")) {
                    this.version = "MPEG1";
                } else if (this.version.equals("2")) {
                    this.version = "MPEG2-LSF";
                } else if (this.version.equals("2.5")) {
                    this.version = "MPEG2.5-LSF";
                }
            }
            if (props.containsKey("mp3.mode")) {
                int mode = (Integer)props.get("mp3.mode");
                if (mode == 0) {
                    this.channels = "Stereo";
                } else if (mode == 1) {
                    this.channels = "Joint Stereo";
                } else if (mode == 2) {
                    this.channels = "Dual Channel";
                } else if (mode == 3) {
                    this.channels = "Single Channel";
                }
            }
            if (props.containsKey("mp3.crc")) {
                this.crc = (Boolean)props.get("mp3.crc");
            }
            if (props.containsKey("mp3.vbr")) {
                this.vbr = (Boolean)props.get("mp3.vbr");
            }
            if (props.containsKey("mp3.copyright")) {
                this.copyright = (Boolean)props.get("mp3.copyright");
            }
            if (props.containsKey("mp3.original")) {
                this.original = (Boolean)props.get("mp3.original");
            }
            if (props.containsKey("duration")) {
                this.duration = Math.round((Long)props.get("duration") / 1000000L);
            }
            this.emphasis = "none";
            if (props.containsKey("title")) {
                this.title = (String)props.get("title");
            }
            if (props.containsKey("author")) {
                this.artist = (String)props.get("author");
            }
            if (props.containsKey("album")) {
                this.album = (String)props.get("album");
            }
            if (props.containsKey("date")) {
                this.year = (String)props.get("date");
            }
            if (props.containsKey("mp3.id3tag.genre")) {
                this.genre = (String)props.get("mp3.id3tag.genre");
            }
            if (props.containsKey("mp3.id3tag.track")) {
                this.track = (String)props.get("mp3.id3tag.track");
            }
        }
    }

    protected void loadShoutastInfo(AudioFileFormat aff) throws IOException, UnsupportedAudioFileException {
        this.encodingType = aff.getType().toString();
        if (!this.encodingType.equalsIgnoreCase("mp3")) {
            throw new UnsupportedAudioFileException("Not MP3 audio format");
        }
        if (aff instanceof TAudioFileFormat) {
            Map props = ((TAudioFileFormat)aff).properties();
            Iterator it = props.keySet().iterator();
            this.comment = "";
            while (it.hasNext()) {
                String key = (String)it.next();
                if (!key.startsWith("mp3.shoutcast.metadata.")) continue;
                String value = (String)props.get(key);
                if ((key = key.substring(23, key.length())).equalsIgnoreCase("icy-name")) {
                    this.title = value;
                    continue;
                }
                if (key.equalsIgnoreCase("icy-genre")) {
                    this.genre = value;
                    continue;
                }
                this.comment.concat(key + "=" + value);
            }
        }
    }

    public String getEncoder() {
        return this.encoder;
    }

    public String getMpegLayer() {
        return this.layer;
    }

    public String getMpegVersion() {
        return this.version;
    }

    public boolean isVariableBitRate() {
        return this.vbr;
    }

    public boolean isProtected() {
        return this.crc;
    }

    public boolean isOriginal() {
        return this.original;
    }

    public boolean isCopyrighted() {
        return this.copyright;
    }

    public boolean isPrivate() {
        return this.privat;
    }

    public String getEmphasis() {
        return this.emphasis;
    }

    public long getSize() {
        return this.size;
    }

    public String getLocation() {
        return this.location;
    }

    @Override
    public String getCodecDetails() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><b>Encoding type: </b>");
        sb.append(this.getEncodingType().toUpperCase());
        if (!Utilities.isNullOrEmpty(this.getEncoder())) {
            sb.append("<br><b>Encoder: </b>");
            sb.append(this.getEncoder());
        }
        sb.append("<br><b>Version: </b>");
        sb.append(this.getMpegVersion());
        sb.append("<br><b>Layer: </b>");
        sb.append(this.getMpegLayer());
        sb.append("<br><b>Sampling rate: </b>");
        sb.append(this.getSampleRateAsNumber()).append(" Hz");
        sb.append("<br><b>Bitrate: </b>");
        sb.append(this.getBitRateAsNumber()).append(" Kbps");
        sb.append("<br><b>Channels: </b>");
        sb.append(this.getChannelsAsNumber());
        sb.append("<br><b>Channels mode: </b>");
        sb.append(this.getChannels());
        sb.append("<br><b>CRC: </b>");
        sb.append(this.isProtected());
        sb.append("<br><b>Variable Bitrate: </b>");
        sb.append(this.isVariableBitRate());
        sb.append("<br><b>Copyrighted: </b>");
        sb.append(this.isCopyrighted());
        sb.append("<br><b>Private: </b>");
        sb.append(this.isPrivate());
        sb.append("<br><b>Emphasis: </b>");
        sb.append(this.getEmphasis());
        if (this.size > 0L) {
            sb.append("<br><b>Size: </b>");
            sb.append(Utilities.byteCountToDisplaySize(this.size));
        }
        sb.append("</html>");
        return sb.toString();
    }
}

