/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.player.audio;

import java.util.Map;
import xtrememp.player.audio.AudioPlayer;
import xtrememp.player.audio.Playback;
import xtrememp.player.audio.PlaybackEvent;
import xtrememp.player.audio.PlaybackListener;

public class PlaybackEventLauncher
extends Thread {
    private AudioPlayer source;
    private Playback state;
    private long position;
    private Map properties;
    private PlaybackListener listener;

    public PlaybackEventLauncher(AudioPlayer source, Playback state, long position, Map properties, PlaybackListener listener) {
        this.source = source;
        this.state = state;
        this.position = position;
        this.properties = properties;
        this.listener = listener;
    }

    @Override
    public void run() {
        if (this.listener != null) {
            switch (this.state) {
                case BUFFERING: {
                    this.listener.playbackBuffering(new PlaybackEvent(this.source, this.state, this.position, this.properties));
                    break;
                }
                case OPENED: {
                    this.listener.playbackOpened(new PlaybackEvent(this.source, this.state, this.position, this.properties));
                    break;
                }
                case EOM: {
                    this.listener.playbackEndOfMedia(new PlaybackEvent(this.source, this.state, this.position, this.properties));
                    break;
                }
                case PLAYING: {
                    this.listener.playbackPlaying(new PlaybackEvent(this.source, this.state, this.position, this.properties));
                    break;
                }
                case PAUSED: {
                    this.listener.playbackPaused(new PlaybackEvent(this.source, this.state, this.position, this.properties));
                    break;
                }
                case STOPPED: {
                    this.listener.playbackStopped(new PlaybackEvent(this.source, this.state, this.position, this.properties));
                }
            }
        }
    }
}

