/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.sidplay.libsidplay.components.xsid;

import de.quippy.sidplay.libsidplay.common.Event;
import de.quippy.sidplay.libsidplay.common.IEventContext;
import de.quippy.sidplay.libsidplay.common.SIDEmu;
import de.quippy.sidplay.libsidplay.common.SIDEndian;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class XSID
extends SIDEmu {
    private static final Logger XSID = Logger.getLogger(XSID.class.getName());
    private Channel ch4;
    private Channel ch5;
    private boolean muted;
    private boolean suppressed;
    private static final String credit = "xSID (Extended SID) Engine:\tCopyright (C) 2000 Simon White <sidplay2@yahoo.com>";
    private short sidData0x18;
    private boolean _sidSamples;
    private short sampleOffset;
    private static final short[] sampleConvertTable = new short[]{128, 148, 169, 188, 206, 225, 242, 3, 27, 42, 59, 73, 88, 102, 115, 127};
    private boolean wasRunning;
    private Event event = new Event("xSID"){

        @Override
        public void event() {
            if (XSID.this.ch4.bool() || XSID.this.ch5.bool()) {
                XSID.this.setSidData0x18();
                XSID.this.wasRunning = true;
            } else if (XSID.this.wasRunning) {
                XSID.this.recallSidData0x18();
                XSID.this.wasRunning = false;
            }
        }
    };

    private void setSidData0x18() {
        if (!this._sidSamples || this.muted) {
            return;
        }
        short s = (short)(this.sidData0x18 & 0xF0);
        s = (short)(s | this.sampleOffset + this.sampleOutput() & 0xF);
        if (XSID.isLoggable(Level.INFO)) {
            if (this.sampleOffset + this.sampleOutput() > 15) {
                XSID.log(Level.FINE, String.format("XSID: Sample Wrapped [offset %d, sample %d]", this.sampleOffset, this.sampleOutput()));
            }
            if (XSID.isLoggable(Level.FINE)) {
                XSID.fine(String.format("XSID: Writing Sample to SID Volume [0x %02x]", s));
            }
        }
        this.writeMemByte(s);
    }

    private void recallSidData0x18() {
        if (this.ch4.isGalway()) {
            if (this._sidSamples && !this.muted) {
                this.writeMemByte(this.sidData0x18);
            }
        } else {
            this.setSidData0x18();
        }
    }

    private byte sampleOutput() {
        byte by = this.ch4.output();
        by = (byte)(by + this.ch5.output());
        return by;
    }

    private void sampleOffsetCalc() {
        short s = (short)(this.ch4.limit() + this.ch5.limit());
        if (s == 0) {
            return;
        }
        this.sampleOffset = (short)(this.sidData0x18 & 0xF);
        if (s > 8) {
            s = (short)(s >> 1);
        }
        short s2 = (short)(15 - s + 1);
        if (this.sampleOffset < s) {
            this.sampleOffset = s;
        } else if (this.sampleOffset > s2) {
            this.sampleOffset = s2;
        }
        if (XSID.isLoggable(Level.INFO)) {
            XSID.log(Level.FINE, String.format("XSID: Sample Offset %d based on channel(s) ", this.sampleOffset));
            if (this.ch4.bool()) {
                XSID.log(Level.FINE, "4 ");
            }
            if (this.ch5.bool()) {
                XSID.log(Level.FINE, "5 ");
            }
        }
    }

    protected abstract short readMemByte(int var1);

    protected abstract void writeMemByte(short var1);

    public XSID(IEventContext iEventContext) {
        super(null);
        this.ch4 = new Channel("CH4", iEventContext, this);
        this.ch5 = new Channel("CH5", iEventContext, this);
        this.muted = false;
        this.suppressed = false;
        this.wasRunning = false;
        this.sidSamples(true);
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void reset(short s) {
        this.ch4.reset();
        this.ch5.reset();
        this.suppressed = false;
        this.wasRunning = false;
    }

    @Override
    public short read(short s) {
        return 0;
    }

    @Override
    public void write(short s, short s2) {
    }

    @Override
    public final String credits() {
        return credit;
    }

    public short read(int n) {
        return 0;
    }

    public void write(int n, short s) {
        if ((n & 0xFE8C ^ 0xC) != 0) {
            return;
        }
        Channel channel = this.ch4;
        if ((n & 0x100) != 0) {
            channel = this.ch5;
        }
        short s2 = (short)n;
        channel.write(s2, s);
        if (XSID.isLoggable(Level.FINE)) {
            XSID.fine(String.format("XSID: Addr 0x%02x, Data 0x%02x", s2, s));
        }
        if (s2 == 29) {
            if (this.suppressed) {
                if (XSID.isLoggable(Level.INFO)) {
                    XSID.log(Level.FINE, String.format("XSID: Initialise Suppressed", new Object[0]));
                }
                return;
            }
            channel.checkForInit();
        }
    }

    @Override
    public long output(short s) {
        if (this._sidSamples || this.muted) {
            return 0L;
        }
        long l = sampleConvertTable[this.sampleOutput() + 8];
        return l << s - 8;
    }

    public void mute(boolean bl) {
        if (!this.muted && bl && this.wasRunning) {
            this.recallSidData0x18();
        }
        this.muted = bl;
    }

    public boolean isMuted() {
        return this.muted;
    }

    public void suppress(boolean bl) {
        this.suppressed = bl;
        if (!this.suppressed) {
            if (XSID.isLoggable(Level.INFO)) {
                XSID.log(Level.FINE, "XSID: Un-suppressing");
            }
            this.ch4.checkForInit();
            this.ch5.checkForInit();
        } else if (XSID.isLoggable(Level.INFO)) {
            XSID.log(Level.FINE, "XSID: Suppressing");
        }
    }

    public void sidSamples(boolean bl) {
        this._sidSamples = bl;
    }

    public boolean storeSidData0x18(short s) {
        this.sidData0x18 = s;
        if (this.ch4.bool() || this.ch5.bool()) {
            this.sampleOffsetCalc();
            if (this._sidSamples) {
                if (XSID.isLoggable(Level.INFO)) {
                    XSID.log(Level.FINE, "XSID: SID Volume changed externally (Corrected).");
                }
                return true;
            }
        }
        this.writeMemByte(this.sidData0x18);
        return false;
    }

    public static class Channel {
        private final String m_name;
        private IEventContext m_context;
        private Event.event_phase_t m_phase;
        private XSID m_xsid;
        private SampleEvent sampleEvent;
        private GalwayEvent galwayEvent;
        private short[] reg = new short[16];
        private static final int FM_NONE = 0;
        private static final int FM_HUELS = 1;
        private static final int FM_GALWAY = 2;
        private int mode;
        private boolean active;
        private int address;
        private int cycleCount;
        private short volShift;
        private short sampleLimit;
        private byte sample;
        private short samRepeat;
        private short samScale;
        public static final int SO_LOWHIGH = 0;
        public static final int SO_HIGHLOW = 1;
        private short samOrder;
        private short samNibble;
        private int samEndAddr;
        private int samRepeatAddr;
        private int samPeriod;
        private short galTones;
        private short galInitLength;
        private short galLength;
        private short galVolume;
        private short galLoopWait;
        private short galNullWait;
        private long cycles;
        private long outputs;

        private Channel(String string, IEventContext iEventContext, XSID xSID) {
            this.m_name = string;
            this.m_context = iEventContext;
            this.m_phase = Event.event_phase_t.EVENT_CLOCK_PHI1;
            this.m_xsid = xSID;
            this.sampleEvent = new SampleEvent(this);
            this.galwayEvent = new GalwayEvent(this);
            int n = 0;
            while (n < this.reg.length) {
                this.reg[n] = 0;
                ++n;
            }
            this.active = true;
            this.reset();
        }

        private void free() {
            this.active = false;
            this.cycleCount = 0;
            this.sampleLimit = 0;
            this.reg[this.convertAddr((int)29)] = 0;
            this.silence();
        }

        private void silence() {
            this.sample = 0;
            this.m_context.cancel(this.sampleEvent);
            this.m_context.cancel(this.galwayEvent);
            this.m_context.schedule(this.m_xsid.event, 0L, this.m_phase);
        }

        private void sampleInit() {
            if (this.active && this.mode == 2) {
                return;
            }
            if (XSID.isLoggable(Level.INFO)) {
                XSID.log(Level.FINE, String.format("XSID [%s]: Sample Init", this.m_name));
                if (this.active && this.mode == 1) {
                    XSID.log(Level.FINE, String.format("XSID [%s]: Stopping Playing Sample", this.m_name));
                }
            }
            short s = this.convertAddr(29);
            this.volShift = (short)(0 - this.reg[s] >> 1);
            this.reg[s] = 0;
            s = this.convertAddr(30);
            this.address = SIDEndian.endian_16(this.reg[s + 1], this.reg[s]);
            s = this.convertAddr(61);
            this.samEndAddr = SIDEndian.endian_16(this.reg[s + 1], this.reg[s]);
            if (this.samEndAddr <= this.address) {
                return;
            }
            this.samScale = this.reg[this.convertAddr(95)];
            s = this.convertAddr(93);
            this.samPeriod = SIDEndian.endian_16(this.reg[s + 1], this.reg[s]) >> this.samScale;
            if (this.samPeriod == 0) {
                this.reg[this.convertAddr((int)29)] = 253;
                this.checkForInit();
                return;
            }
            this.samNibble = 0;
            this.samRepeat = this.reg[this.convertAddr(63)];
            this.samOrder = this.reg[this.convertAddr(125)];
            s = this.convertAddr(126);
            this.samRepeatAddr = SIDEndian.endian_16(this.reg[s + 1], this.reg[s]);
            this.cycleCount = this.samPeriod;
            if (this.mode == 0) {
                this.mode = 1;
            }
            this.active = true;
            this.cycles = 0L;
            this.outputs = 0L;
            this.sampleLimit = (short)(8 >> this.volShift);
            this.sample = this.sampleCalculate();
            this.m_xsid.sampleOffsetCalc();
            if (XSID.isLoggable(Level.INFO)) {
                if (XSID.isLoggable(Level.FINE)) {
                    XSID.fine(String.format("XSID [%s]: Sample Start Address:  0x%04x", this.m_name, this.address));
                    XSID.fine(String.format("XSID [%s]: Sample End Address:    0x%04x", this.m_name, this.samEndAddr));
                    XSID.fine(String.format("XSID [%s]: Sample Repeat Address: 0x%04x", this.m_name, this.samRepeatAddr));
                    XSID.fine(String.format("XSID [%s]: Sample Period: %d", this.m_name, this.samPeriod));
                    XSID.fine(String.format("XSID [%s]: Sample Repeat: %d", this.m_name, (int)this.samRepeat));
                    XSID.fine(String.format("XSID [%s]: Sample Order : %d", this.m_name, (int)this.samOrder));
                }
                XSID.log(Level.FINE, String.format("XSID [%s]: Sample Start", this.m_name));
            }
            this.m_context.schedule(this.m_xsid.event, 0L, this.m_phase);
            this.m_context.schedule(this.sampleEvent, this.cycleCount, this.m_phase);
        }

        private void sampleClock() {
            this.cycleCount = this.samPeriod;
            if (this.address >= this.samEndAddr) {
                if (this.samRepeat != 255) {
                    if (this.samRepeat != 0) {
                        this.samRepeat = (short)(this.samRepeat - 1);
                    } else {
                        this.samRepeatAddr = this.address;
                    }
                }
                this.address = this.samRepeatAddr;
                if (this.address >= this.samEndAddr) {
                    short s = this.convertAddr(29);
                    short s2 = this.reg[s];
                    if (s2 == 0) {
                        this.reg[s] = 253;
                    }
                    if (s2 != 253) {
                        this.active = false;
                    }
                    if (XSID.isLoggable(Level.INFO)) {
                        XSID.log(Level.FINE, String.format("XSID [%s]: Sample Stop (%d Cycles, %d Outputs)", this.m_name, this.cycles, this.outputs));
                    }
                    this.checkForInit();
                    return;
                }
            }
            this.sample = this.sampleCalculate();
            this.cycles += (long)this.cycleCount;
            this.m_context.schedule(this.sampleEvent, this.cycleCount, this.m_phase);
            this.m_context.schedule(this.m_xsid.event, 0L, this.m_phase);
        }

        private void galwayInit() {
            if (this.active) {
                return;
            }
            if (XSID.isLoggable(Level.INFO)) {
                XSID.log(Level.FINE, String.format("XSID [%s]: Galway Init", this.m_name));
            }
            short s = this.convertAddr(29);
            this.galTones = this.reg[s];
            this.reg[s] = 0;
            this.galInitLength = this.reg[this.convertAddr(61)];
            if (this.galInitLength == 0) {
                return;
            }
            this.galLoopWait = this.reg[this.convertAddr(63)];
            if (this.galLoopWait == 0) {
                return;
            }
            this.galNullWait = this.reg[this.convertAddr(93)];
            if (this.galNullWait == 0) {
                return;
            }
            s = this.convertAddr(30);
            this.address = SIDEndian.endian_16(this.reg[s + 1], this.reg[s]);
            this.volShift = (short)(this.reg[this.convertAddr(62)] & 0xF);
            this.mode = 2;
            this.active = true;
            this.cycles = 0L;
            this.outputs = 0L;
            this.sampleLimit = (short)8;
            this.sample = (byte)(this.galVolume - 8);
            this.galwayTonePeriod();
            this.m_xsid.sampleOffsetCalc();
            if (XSID.isLoggable(Level.INFO)) {
                XSID.log(Level.FINE, String.format("XSID [%s]: Galway Start", this.m_name));
            }
            this.m_context.schedule(this.m_xsid.event, 0L, this.m_phase);
            this.m_context.schedule(this.galwayEvent, this.cycleCount, this.m_phase);
        }

        private void galwayClock() {
            this.galLength = (short)(this.galLength - 1);
            if (this.galLength != 0) {
                this.cycleCount = this.samPeriod;
            } else {
                if (this.galTones == 255) {
                    short s = this.convertAddr(29);
                    short s2 = this.reg[s];
                    if (s2 == 0) {
                        this.reg[s] = 253;
                    }
                    if (s2 != 253) {
                        this.active = false;
                    }
                    if (XSID.isLoggable(Level.INFO)) {
                        XSID.log(Level.FINE, String.format("XSID [%s]: Galway Stop (%d Cycles, %d Outputs)", this.m_name, this.cycles, this.outputs));
                        if (s2 != 253) {
                            XSID.log(Level.FINE, String.format("XSID [%s]: Starting Delayed Sequence", this.m_name));
                        }
                    }
                    this.checkForInit();
                    return;
                }
                this.galwayTonePeriod();
            }
            this.galVolume = (short)(this.galVolume + this.volShift);
            this.galVolume = (short)(this.galVolume & 0xF);
            this.sample = (byte)(this.galVolume - 8);
            this.cycles += (long)this.cycleCount;
            this.m_context.schedule(this.galwayEvent, this.cycleCount, this.m_phase);
            this.m_context.schedule(this.m_xsid.event, 0L, this.m_phase);
        }

        private short convertAddr(int n) {
            return (short)(n & 3 | n >> 3 & 0xC);
        }

        private void reset() {
            this.galVolume = 0;
            this.mode = 0;
            this.free();
            this.m_context.cancel(this.m_xsid.event);
            this.m_context.cancel(this.sampleEvent);
            this.m_context.cancel(this.galwayEvent);
        }

        public short read(short s) {
            return this.reg[this.convertAddr(s)];
        }

        private void write(short s, short s2) {
            this.reg[this.convertAddr((int)s)] = s2;
        }

        private byte output() {
            ++this.outputs;
            return this.sample;
        }

        private boolean isGalway() {
            return this.mode == 2;
        }

        private short limit() {
            return this.sampleLimit;
        }

        private void checkForInit() {
            switch (this.reg[this.convertAddr(29)]) {
                case 252: 
                case 254: 
                case 255: {
                    this.sampleInit();
                    break;
                }
                case 253: {
                    if (!this.active) {
                        return;
                    }
                    this.free();
                    this.m_xsid.sampleOffsetCalc();
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    this.galwayInit();
                }
            }
        }

        private byte sampleCalculate() {
            short s = this.m_xsid.readMemByte(this.address);
            if (this.samOrder == 0) {
                if (this.samScale == 0 && this.samNibble != 0) {
                    s = (short)(s >> 4);
                }
            } else if (this.samScale == 0) {
                if (this.samNibble == 0) {
                    s = (short)(s >> 4);
                }
            } else {
                s = (short)(s >> 4);
            }
            this.address += this.samNibble;
            this.samNibble = (short)(this.samNibble ^ 1);
            return (byte)((s & 0xF) - 8 >> this.volShift);
        }

        private void galwayTonePeriod() {
            this.galLength = this.galInitLength;
            this.samPeriod = this.m_xsid.readMemByte(this.address + this.galTones);
            this.samPeriod *= this.galLoopWait;
            this.samPeriod += this.galNullWait;
            this.cycleCount = this.samPeriod;
            if (XSID.isLoggable(Level.INFO)) {
                XSID.log(Level.FINE, String.format("XSID [%s]: Galway Settings", this.m_name));
                XSID.log(Level.FINE, String.format("XSID [%s]: Length %d, LoopWait %d, NullWait %d", this.m_name, this.galLength, this.galLoopWait, this.galNullWait));
                XSID.log(Level.FINE, String.format("XSID [%s]: Tones %d, Data %d", this.m_name, this.galTones, this.m_xsid.readMemByte(this.address + this.galTones)));
            }
            this.galTones = (short)(this.galTones - 1);
        }

        private final boolean bool() {
            return this.active;
        }

        private static class GalwayEvent
        extends Event {
            private Channel m_ch;

            @Override
            public void event() {
                this.m_ch.galwayClock();
            }

            public GalwayEvent(Channel channel) {
                super("xSID Galway");
                this.m_ch = channel;
            }
        }

        private static class SampleEvent
        extends Event {
            private Channel m_ch;

            @Override
            public void event() {
                this.m_ch.sampleClock();
            }

            public SampleEvent(Channel channel) {
                super("xSID Sample");
                this.m_ch = channel;
            }
        }
    }
}

