/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.sidplay.libsidplay.components.sidtune;

import de.quippy.sidplay.libsidplay.components.sidtune.Buffer_sidtt;
import de.quippy.sidplay.libsidplay.components.sidtune.SidTune;
import de.quippy.sidplay.libsidplay.components.sidtune.SidTuneInfo;
import de.quippy.sidplay.libsidplay.components.sidtune.SmartPtr_sidtt;

public class P00 {
    private static final int X00_ID_LEN = 8;
    private static final int X00_NAME_LEN = 17;
    private static final String _sidtune_id = "C64File";
    private static final String _sidtune_format_del = "Unsupported tape image file (DEL)";
    private static final String _sidtune_format_seq = "Unsupported tape image file (SEQ)";
    private static final String _sidtune_format_prg = "Tape image file (PRG)";
    private static final String _sidtune_format_usr = "Unsupported USR file (USR)";
    private static final String _sidtune_format_rel = "Unsupported tape image file (REL)";
    private static final String _sidtune_truncated = "ERROR: File is most likely truncated";
    private SidTune sidtune;
    private SidTuneInfo info;

    public P00(SidTune sidTune) {
        this.sidtune = sidTune;
        this.info = sidTune.info;
    }

    protected SidTune.LoadStatus X00_fileSupport(String string, Buffer_sidtt buffer_sidtt) {
        int n = string.lastIndexOf(".");
        String string2 = n != -1 ? string.substring(n) : "";
        String string3 = null;
        X00Header x00Header = new X00Header(buffer_sidtt.get());
        int n2 = buffer_sidtt.len();
        if (string2.length() != 4) {
            return SidTune.LoadStatus.LOAD_NOT_MINE;
        }
        if (!Character.isDigit(string2.charAt(2)) || !Character.isDigit(string2.charAt(3))) {
            return SidTune.LoadStatus.LOAD_NOT_MINE;
        }
        X00Format x00Format = X00Format.X00_UNKNOWN;
        switch (Character.toUpperCase(string2.charAt(1))) {
            case 'D': {
                x00Format = X00Format.X00_DEL;
                string3 = _sidtune_format_del;
                break;
            }
            case 'S': {
                x00Format = X00Format.X00_SEQ;
                string3 = _sidtune_format_seq;
                break;
            }
            case 'P': {
                x00Format = X00Format.X00_PRG;
                string3 = _sidtune_format_prg;
                break;
            }
            case 'U': {
                x00Format = X00Format.X00_USR;
                string3 = _sidtune_format_usr;
                break;
            }
            case 'R': {
                x00Format = X00Format.X00_REL;
                string3 = _sidtune_format_rel;
            }
        }
        if (x00Format == X00Format.X00_UNKNOWN) {
            return SidTune.LoadStatus.LOAD_NOT_MINE;
        }
        int n3 = new String(x00Header.id).indexOf(0);
        if (n3 == -1) {
            n3 = x00Header.id.length;
        }
        if (n2 < 8) {
            return SidTune.LoadStatus.LOAD_NOT_MINE;
        }
        if (!new String(x00Header.id, 0, n3).equals(_sidtune_id)) {
            return SidTune.LoadStatus.LOAD_NOT_MINE;
        }
        this.info.formatString = string3;
        if (x00Format != X00Format.X00_PRG) {
            return SidTune.LoadStatus.LOAD_ERROR;
        }
        if (n2 < 28) {
            this.info.formatString = _sidtune_truncated;
            return SidTune.LoadStatus.LOAD_ERROR;
        }
        int n4 = new String(x00Header.name).indexOf(0);
        if (n4 == -1) {
            n4 = x00Header.name.length;
        }
        short[] sArray = new short[n4];
        int n5 = 0;
        while (n5 < n4) {
            sArray[n5] = (short)x00Header.name[n5];
            ++n5;
        }
        SmartPtr_sidtt smartPtr_sidtt = new SmartPtr_sidtt(sArray, n4, false);
        StringBuffer stringBuffer = new StringBuffer();
        this.sidtune.convertPetsciiToAscii(smartPtr_sidtt, stringBuffer);
        this.sidtune.infoString[0] = stringBuffer.toString();
        this.sidtune.fileOffset = 26;
        this.info.songs = 1;
        this.info.startSong = 1;
        this.info.compatibility = 3;
        this.info.numberOfInfoStrings = 1;
        this.info.infoString[0] = this.sidtune.infoString[0];
        this.sidtune.convertOldStyleSpeedToTables(-1L, this.info.clockSpeed);
        return SidTune.LoadStatus.LOAD_OK;
    }

    static enum X00Format {
        X00_UNKNOWN,
        X00_DEL,
        X00_SEQ,
        X00_PRG,
        X00_USR,
        X00_REL;

    }

    private static class X00Header {
        public static final int SIZE = 26;
        char[] id = new char[8];
        char[] name = new char[17];

        public X00Header(short[] sArray) {
            int n = 0;
            int n2 = 0;
            while (n2 < 8) {
                this.id[n2] = (char)sArray[n++];
                ++n2;
            }
            n2 = 0;
            while (n2 < 17) {
                this.name[n2] = (char)sArray[n++];
                ++n2;
            }
        }
    }
}

