/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.sidplay.libsidplay.components.mos6526;

import de.quippy.sidplay.libsidplay.common.Event;
import de.quippy.sidplay.libsidplay.common.IComponent;
import de.quippy.sidplay.libsidplay.common.IEventContext;
import de.quippy.sidplay.libsidplay.common.SIDEndian;

public abstract class MOS6526
implements IComponent {
    public static final int INTERRUPT_TA = 1;
    public static final int INTERRUPT_TB = 2;
    public static final int INTERRUPT_ALARM = 4;
    public static final int INTERRUPT_SP = 8;
    public static final int INTERRUPT_FLAG = 16;
    public static final int INTERRUPT_REQUEST = 128;
    public static final int PRA = 0;
    public static final int PRB = 1;
    public static final int DDRA = 2;
    public static final int DDRB = 3;
    public static final int TAL = 4;
    public static final int TAH = 5;
    public static final int TBL = 6;
    public static final int TBH = 7;
    public static final int TOD_TEN = 8;
    public static final int TOD_SEC = 9;
    public static final int TOD_MIN = 10;
    public static final int TOD_HR = 11;
    public static final int SDR = 12;
    public static final int ICR = 13;
    public static final int IDR = 13;
    public static final int CRA = 14;
    public static final int CRB = 15;
    private static final String credit = "*MOS6526 (CIA) Emulation:\tCopyright (C) 2001-2004 Simon White <sidplay2@yahoo.com>";
    protected short[] regs = new short[16];
    protected boolean cnt_high;
    protected short cra;
    protected short cra_latch;
    protected short dpa;
    protected int ta;
    protected int ta_latch;
    protected boolean ta_underflow;
    protected short crb;
    protected int tb;
    protected int tb_latch;
    protected boolean tb_underflow;
    protected short sdr_out;
    protected boolean sdr_buffered;
    protected int sdr_count;
    protected short icr;
    protected short idr = 0;
    protected long m_accessClk;
    protected IEventContext event_context;
    protected Event.event_phase_t m_phase;
    protected boolean m_todlatched;
    protected boolean m_todstopped;
    protected short[] m_todclock = new short[4];
    protected short[] m_todalarm = new short[4];
    protected short[] m_todlatch = new short[4];
    long m_todCycles;
    long m_todPeriod;
    protected EventTa event_ta;
    protected EventTb event_tb;
    protected EventTod event_tod;

    protected MOS6526(IEventContext iEventContext) {
        this.event_context = iEventContext;
        this.m_phase = Event.event_phase_t.EVENT_CLOCK_PHI1;
        this.m_todPeriod = 0xFFFFFFFFL;
        this.event_ta = new EventTa(this);
        this.event_tb = new EventTb(this);
        this.event_tod = new EventTod(this);
        this.reset();
    }

    protected void ta_event() {
        short s = (short)(this.cra & 0x21);
        if (s == 33 && this.ta-- != 0) {
            return;
        }
        long l = this.event_context.getTime(this.m_accessClk, this.m_phase);
        this.m_accessClk += l;
        this.ta = this.ta_latch;
        this.ta_underflow ^= true;
        if ((this.cra & 8) != 0) {
            this.cra = (short)(this.cra & 0xFE);
        } else if (s == 1) {
            this.event_context.schedule(this.event_ta, (long)this.ta + 1L, this.m_phase);
        }
        this.trigger(1);
        if ((this.cra & 0x40) != 0) {
            if (this.sdr_count != 0 && --this.sdr_count == 0) {
                this.trigger(8);
            }
            if (this.sdr_count == 0 && this.sdr_buffered) {
                this.sdr_out = this.regs[12];
                this.sdr_buffered = false;
                this.sdr_count = 16;
            }
        }
        switch (this.crb & 0x61) {
            case 1: {
                this.tb = (int)((long)this.tb - l);
                break;
            }
            case 65: 
            case 97: {
                this.tb_event();
            }
        }
    }

    protected void tb_event() {
        short s = (short)(this.crb & 0x61);
        switch (s) {
            case 1: {
                break;
            }
            case 33: 
            case 65: {
                if (this.tb-- == 0) break;
                return;
            }
            case 97: {
                if (!this.cnt_high || this.tb-- == 0) break;
                return;
            }
            default: {
                return;
            }
        }
        this.m_accessClk = this.event_context.getTime(this.m_phase);
        this.tb = this.tb_latch;
        this.tb_underflow ^= true;
        if ((this.crb & 8) != 0) {
            this.crb = (short)(this.crb & 0xFE);
        } else if (s == 1) {
            this.event_context.schedule(this.event_tb, (long)this.tb + 1L, this.m_phase);
        }
        this.trigger(2);
    }

    private static final short byte2bcd(short s) {
        return (short)((s / 10 << 4) + s % 10 & 0xFF);
    }

    private static final short bcd2byte(short s) {
        return (short)(10 * ((s & 0xF0) >> 4) + (s & 0xF) & 0xFF);
    }

    protected void tod_event() {
        this.m_todCycles = (this.cra & 0x80) != 0 ? (this.m_todCycles += this.m_todPeriod * 5L) : (this.m_todCycles += this.m_todPeriod * 6L);
        this.event_context.schedule(this.event_tod, this.m_todCycles >> 7, this.m_phase);
        this.m_todCycles &= 0x7FL;
        if (!this.m_todstopped) {
            short[] sArray = this.m_todclock;
            int n = 0;
            int n2 = MOS6526.bcd2byte(sArray[n]) + 1;
            sArray[n++] = MOS6526.byte2bcd((short)(n2 % 10));
            if (n2 >= 10) {
                n2 = (short)(MOS6526.bcd2byte(sArray[n]) + 1);
                sArray[n++] = MOS6526.byte2bcd((short)(n2 % 60));
                if (n2 >= 60) {
                    n2 = (short)(MOS6526.bcd2byte(sArray[n]) + 1);
                    sArray[n++] = MOS6526.byte2bcd((short)(n2 % 60));
                    if (n2 >= 60) {
                        short s = (short)(sArray[n] & 0x80);
                        n2 = (short)(sArray[n] & 0x1F);
                        if (n2 == 17) {
                            s = (short)(s ^ 0x80);
                        }
                        if (n2 == 18) {
                            n2 = 1;
                        } else if ((n2 = (int)(n2 + 1)) == 10) {
                            n2 = 16;
                        }
                        n2 = (short)(n2 & 0x1F);
                        sArray[n] = (short)(n2 | s);
                    }
                }
            }
            if (!this.memcmp(this.m_todalarm, this.m_todclock, this.m_todalarm.length)) {
                this.trigger(4);
            }
        }
    }

    protected void trigger(int n) {
        if (n == 0) {
            if ((this.idr & 0x80) != 0) {
                this.interrupt(false);
            }
            this.idr = 0;
            return;
        }
        this.idr = (short)(this.idr | n);
        if ((this.icr & this.idr) != 0 && (this.idr & 0x80) == 0) {
            this.idr = (short)(this.idr | 0x80);
            this.interrupt(true);
        }
    }

    public abstract void interrupt(boolean var1);

    public abstract void portA();

    public abstract void portB();

    @Override
    public void reset() {
        this.ta_latch = 65535;
        this.ta = 65535;
        this.tb_latch = 65535;
        this.tb = 65535;
        this.tb_underflow = false;
        this.ta_underflow = false;
        this.sdr_out = 0;
        this.crb = 0;
        this.cra = 0;
        this.sdr_count = 0;
        this.sdr_buffered = false;
        this.trigger(0);
        this.cnt_high = true;
        this.idr = 0;
        this.icr = 0;
        this.m_accessClk = 0L;
        this.dpa = (short)240;
        int n = 0;
        while (n < this.regs.length) {
            this.regs[n] = 0;
            ++n;
        }
        n = 0;
        while (n < this.m_todclock.length) {
            this.m_todclock[n] = 0;
            ++n;
        }
        n = 0;
        while (n < this.m_todalarm.length) {
            this.m_todalarm[n] = 0;
            ++n;
        }
        n = 0;
        while (n < this.m_todlatch.length) {
            this.m_todlatch[n] = 0;
            ++n;
        }
        this.m_todlatched = false;
        this.m_todstopped = true;
        this.m_todclock[3] = 1;
        this.m_todCycles = 0L;
        this.event_context.cancel(this.event_ta);
        this.event_context.cancel(this.event_tb);
        this.event_context.schedule(this.event_tod, 0L, this.m_phase);
    }

    @Override
    public short read(short s) {
        if (s > 15) {
            return 0;
        }
        boolean bl = false;
        boolean bl2 = false;
        long l = this.event_context.getTime(this.m_accessClk, this.event_context.phase());
        this.m_accessClk += l;
        if ((this.cra & 0x21) == 1) {
            this.ta = (int)((long)this.ta - l);
            if (this.ta == 0) {
                this.ta_event();
                bl = true;
            }
        }
        if ((this.crb & 0x61) == 1) {
            this.tb = (int)((long)this.tb - l);
            if (this.tb == 0) {
                this.tb_event();
                bl2 = true;
            }
        }
        switch (s) {
            case 0: {
                return (short)(this.regs[0] | ~this.regs[2] & 0xFF);
            }
            case 1: {
                short s2 = (short)(this.regs[1] | ~this.regs[3] & 0xFF);
                if ((this.cra & 2) != 0) {
                    s2 = (short)(s2 & 0xBF);
                    if ((this.cra & 4) != 0 ? this.ta_underflow : bl) {
                        s2 = (short)(s2 | 0x40);
                    }
                }
                if ((this.crb & 2) != 0) {
                    s2 = (short)(s2 & 0x7F);
                    if ((this.crb & 4) != 0 ? this.tb_underflow : bl2) {
                        s2 = (short)(s2 | 0x80);
                    }
                }
                return s2;
            }
            case 4: {
                return SIDEndian.endian_16lo8(this.ta);
            }
            case 5: {
                return SIDEndian.endian_16hi8(this.ta);
            }
            case 6: {
                return SIDEndian.endian_16lo8(this.tb);
            }
            case 7: {
                return SIDEndian.endian_16hi8(this.tb);
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                if (!this.m_todlatched) {
                    int n = 0;
                    while (n < this.m_todlatch.length) {
                        this.m_todlatch[n] = this.m_todclock[n];
                        ++n;
                    }
                }
                if (s == 8) {
                    this.m_todlatched = false;
                }
                if (s == 11) {
                    this.m_todlatched = true;
                }
                return this.m_todlatch[s - 8];
            }
            case 13: {
                short s3 = this.idr;
                this.trigger(0);
                return s3;
            }
            case 14: {
                return this.cra;
            }
            case 15: {
                return this.crb;
            }
        }
        return this.regs[s];
    }

    @Override
    public void write(short s, short s2) {
        if (s > 15) {
            return;
        }
        this.regs[s] = s2;
        long l = this.event_context.getTime(this.m_accessClk, this.event_context.phase());
        if (l != 0L) {
            this.m_accessClk += l;
            if ((this.cra & 0x21) == 1) {
                this.ta = (int)((long)this.ta - l);
                if (this.ta == 0) {
                    this.ta_event();
                }
            }
            if ((this.crb & 0x61) == 1) {
                this.tb = (int)((long)this.tb - l);
                if (this.tb == 0) {
                    this.tb_event();
                }
            }
        }
        switch (s) {
            case 0: 
            case 2: {
                this.portA();
                break;
            }
            case 1: 
            case 3: {
                this.portB();
                break;
            }
            case 4: {
                this.ta_latch = SIDEndian.endian_16lo8(this.ta_latch, s2);
                break;
            }
            case 5: {
                this.ta_latch = SIDEndian.endian_16hi8(this.ta_latch, s2);
                if ((this.cra & 1) != 0) break;
                this.ta = this.ta_latch;
                break;
            }
            case 6: {
                this.tb_latch = SIDEndian.endian_16lo8(this.tb_latch, s2);
                break;
            }
            case 7: {
                this.tb_latch = SIDEndian.endian_16hi8(this.tb_latch, s2);
                if ((this.crb & 1) != 0) break;
                this.tb = this.tb_latch;
                break;
            }
            case 11: {
                s2 = (short)(s2 & 0x9F);
                if ((s2 & 0x1F) == 18 && (this.crb & 0x80) == 0) {
                    s2 = (short)(s2 ^ 0x80);
                }
            }
            case 8: 
            case 9: 
            case 10: {
                if ((this.crb & 0x80) != 0) {
                    this.m_todalarm[s - 8] = s2;
                } else {
                    if (s == 8) {
                        this.m_todstopped = false;
                    }
                    if (s == 11) {
                        this.m_todstopped = true;
                    }
                    this.m_todclock[s - 8] = s2;
                }
                if (this.m_todstopped || this.memcmp(this.m_todalarm, this.m_todclock, this.m_todalarm.length)) break;
                this.trigger(4);
                break;
            }
            case 12: {
                if ((this.cra & 0x40) == 0) break;
                this.sdr_buffered = true;
                break;
            }
            case 13: {
                this.icr = (s2 & 0x80) != 0 ? (short)(this.icr | s2 & 0x1F) : (short)(this.icr & (~s2 & 0xFF));
                this.trigger(this.idr);
                break;
            }
            case 14: {
                if ((s2 & 1) != 0 && (this.cra & 1) == 0) {
                    this.ta = this.ta_latch;
                    this.ta_underflow = true;
                }
                this.cra = s2;
                if ((s2 & 0x10) != 0) {
                    this.cra = (short)(this.cra & 0xEF);
                    this.ta = this.ta_latch;
                }
                if ((s2 & 0x21) == 1) {
                    this.event_context.schedule(this.event_ta, (long)this.ta + 1L, this.m_phase);
                    break;
                }
                this.event_context.cancel(this.event_ta);
                break;
            }
            case 15: {
                if ((s2 & 1) != 0 && (this.crb & 1) == 0) {
                    this.tb = this.tb_latch;
                    this.tb_underflow = true;
                }
                this.crb = s2;
                if ((s2 & 0x10) != 0) {
                    this.crb = (short)(this.crb & 0xEF);
                    this.tb = this.tb_latch;
                }
                if ((s2 & 0x61) == 1) {
                    this.event_context.schedule(this.event_tb, (long)this.tb + 1L, this.m_phase);
                    break;
                }
                this.event_context.cancel(this.event_tb);
                break;
            }
        }
    }

    @Override
    public final String credits() {
        return credit;
    }

    public void clock(double d) {
        this.m_todPeriod = (long)(d * 128.0);
    }

    private boolean memcmp(short[] sArray, short[] sArray2, int n) {
        int n2 = 0;
        while (n2 < n) {
            if (sArray[n2] != sArray2[n2]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected static class EventTa
    extends Event {
        private MOS6526 m_cia;

        @Override
        public void event() {
            this.m_cia.ta_event();
        }

        public EventTa(MOS6526 mOS6526) {
            super("CIA Timer A");
            this.m_cia = mOS6526;
        }
    }

    protected static class EventTb
    extends Event {
        private MOS6526 m_cia;

        @Override
        public void event() {
            this.m_cia.tb_event();
        }

        public EventTb(MOS6526 mOS6526) {
            super("CIA Timer B");
            this.m_cia = mOS6526;
        }
    }

    protected static class EventTod
    extends Event {
        private MOS6526 m_cia;

        @Override
        public void event() {
            this.m_cia.tod_event();
        }

        public EventTod(MOS6526 mOS6526) {
            super("CIA Time of Day");
            this.m_cia = mOS6526;
        }
    }
}

