/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.prediction;

import de.quippy.jmac.prediction.IPredictorDecompress;
import de.quippy.jmac.prediction.NNFilter;
import de.quippy.jmac.prediction.NNFilter1280;
import de.quippy.jmac.prediction.NNFilter16;
import de.quippy.jmac.prediction.NNFilter256;
import de.quippy.jmac.prediction.NNFilter32;
import de.quippy.jmac.prediction.NNFilter64;
import de.quippy.jmac.tools.JMACException;
import de.quippy.jmac.tools.RollBufferFastInt;
import java.util.Arrays;

public class PredictorDecompress3950toCurrent
extends IPredictorDecompress {
    public static final int M_COUNT = 8;
    private static final int WINDOW_BLOCKS = 512;
    protected int[] m_aryMA = new int[8];
    protected int[] m_aryMB = new int[8];
    protected RollBufferFastInt m_rbPredictionA = new RollBufferFastInt(512, 8);
    protected RollBufferFastInt m_rbPredictionB = new RollBufferFastInt(512, 8);
    protected RollBufferFastInt m_rbAdaptA = new RollBufferFastInt(512, 8);
    protected RollBufferFastInt m_rbAdaptB = new RollBufferFastInt(512, 8);
    protected int scaledFilterALV;
    protected int scaledFilterBLV;
    protected int m_nCurrentIndex;
    protected int m_nLastValueA;
    protected int m_nVersion;
    protected NNFilter m_pNNFilter;
    protected NNFilter m_pNNFilter1;
    protected NNFilter m_pNNFilter2;

    public PredictorDecompress3950toCurrent(int n, int n2) {
        super(n, n2);
        this.m_nVersion = n2;
        if (n == 1000) {
            this.m_pNNFilter = null;
            this.m_pNNFilter1 = null;
            this.m_pNNFilter2 = null;
        } else if (n == 2000) {
            this.m_pNNFilter = new NNFilter16(11, n2);
            this.m_pNNFilter1 = null;
            this.m_pNNFilter2 = null;
        } else if (n == 3000) {
            this.m_pNNFilter = new NNFilter64(11, n2);
            this.m_pNNFilter1 = null;
            this.m_pNNFilter2 = null;
        } else if (n == 4000) {
            this.m_pNNFilter = new NNFilter256(13, n2);
            this.m_pNNFilter1 = new NNFilter32(10, n2);
            this.m_pNNFilter2 = null;
        } else if (n == 5000) {
            this.m_pNNFilter = new NNFilter1280(15, n2);
            this.m_pNNFilter1 = new NNFilter256(13, n2);
            this.m_pNNFilter2 = new NNFilter16(11, n2);
        } else {
            throw new JMACException("Unknown Compression Type");
        }
    }

    @Override
    public int DecompressValue(int n) {
        return this.DecompressValue(n, 0);
    }

    @Override
    public int DecompressValue(int n, int n2) {
        int n3;
        if (this.m_nCurrentIndex == 512) {
            this.m_rbPredictionA.Roll();
            this.m_rbPredictionB.Roll();
            this.m_rbAdaptA.Roll();
            this.m_rbAdaptB.Roll();
            this.m_nCurrentIndex = 0;
        }
        if (this.m_pNNFilter2 != null) {
            n = this.m_pNNFilter2.Decompress(n);
        }
        if (this.m_pNNFilter1 != null) {
            n = this.m_pNNFilter1.Decompress(n);
        }
        if (this.m_pNNFilter != null) {
            n = this.m_pNNFilter.Decompress(n);
        }
        RollBufferFastInt rollBufferFastInt = this.m_rbPredictionA;
        int n4 = rollBufferFastInt.index;
        RollBufferFastInt rollBufferFastInt2 = this.m_rbPredictionB;
        int n5 = rollBufferFastInt2.index;
        int[] nArray = rollBufferFastInt.m_pData;
        rollBufferFastInt.m_pData[n4] = n3 = this.m_nLastValueA;
        int n6 = n4 - 1;
        nArray[n6] = n3 - nArray[n6];
        int[] nArray2 = rollBufferFastInt2.m_pData;
        nArray2[n5] = n2 - (this.scaledFilterBLV * 31 >> 5);
        this.scaledFilterBLV = n2;
        int n7 = n5 - 1;
        nArray2[n7] = nArray2[n5] - nArray2[n7];
        int[] nArray3 = this.m_aryMA;
        int n8 = n3 * this.m_aryMA[0] + nArray[n6] * nArray3[1] + nArray[n4 - 2] * nArray3[2] + nArray[n4 - 3] * nArray3[3];
        int[] nArray4 = this.m_aryMB;
        int n9 = nArray2[n5] * this.m_aryMB[0] + nArray2[n7] * nArray4[1] + nArray2[n5 - 2] * nArray4[2] + nArray2[n5 - 3] * nArray4[3] + nArray2[n5 - 4] * nArray4[4];
        int n10 = n + (n8 + (n9 >> 1) >> 10);
        RollBufferFastInt rollBufferFastInt3 = this.m_rbAdaptA;
        int n11 = rollBufferFastInt3.index;
        RollBufferFastInt rollBufferFastInt4 = this.m_rbAdaptB;
        int n12 = rollBufferFastInt4.index;
        int[] nArray5 = this.m_rbAdaptA.m_pData;
        this.m_rbAdaptA.m_pData[n11] = n3 != 0 ? (n3 >> 30 & 2) - 1 : 0;
        nArray5[n11 - 1] = nArray[n6] != 0 ? (nArray[n6] >> 30 & 2) - 1 : 0;
        int[] nArray6 = this.m_rbAdaptB.m_pData;
        this.m_rbAdaptB.m_pData[n12] = nArray2[n5] != 0 ? (nArray2[n5] >> 30 & 2) - 1 : 0;
        int n13 = nArray6[n12 - 1] = nArray2[n7] != 0 ? (nArray2[n7] >> 30 & 2) - 1 : 0;
        if (n > 0) {
            nArray3[0] = nArray3[0] - nArray5[n11];
            nArray3[1] = nArray3[1] - nArray5[n11 - 1];
            nArray3[2] = nArray3[2] - nArray5[n11 - 2];
            nArray3[3] = nArray3[3] - nArray5[n11 - 3];
            nArray4[0] = nArray4[0] - nArray6[n12];
            nArray4[1] = nArray4[1] - nArray6[n12 - 1];
            nArray4[2] = nArray4[2] - nArray6[n12 - 2];
            nArray4[3] = nArray4[3] - nArray6[n12 - 3];
            nArray4[4] = nArray4[4] - nArray6[n12 - 4];
        } else if (n < 0) {
            nArray3[0] = nArray3[0] + nArray5[n11];
            nArray3[1] = nArray3[1] + nArray5[n11 - 1];
            nArray3[2] = nArray3[2] + nArray5[n11 - 2];
            nArray3[3] = nArray3[3] + nArray5[n11 - 3];
            nArray4[0] = nArray4[0] + nArray6[n12];
            nArray4[1] = nArray4[1] + nArray6[n12 - 1];
            nArray4[2] = nArray4[2] + nArray6[n12 - 2];
            nArray4[3] = nArray4[3] + nArray6[n12 - 3];
            nArray4[4] = nArray4[4] + nArray6[n12 - 4];
        }
        this.scaledFilterALV = n10 + (this.scaledFilterALV * 31 >> 5);
        this.m_nLastValueA = n10;
        ++rollBufferFastInt.index;
        ++rollBufferFastInt2.index;
        ++rollBufferFastInt3.index;
        ++rollBufferFastInt4.index;
        ++this.m_nCurrentIndex;
        return this.scaledFilterALV;
    }

    @Override
    public void Flush() {
        NNFilter nNFilter = this.m_pNNFilter;
        if (nNFilter != null) {
            nNFilter.Flush();
        }
        if ((nNFilter = this.m_pNNFilter1) != null) {
            nNFilter.Flush();
        }
        if ((nNFilter = this.m_pNNFilter2) != null) {
            nNFilter.Flush();
        }
        Arrays.fill(this.m_aryMA, 0);
        Arrays.fill(this.m_aryMB, 0);
        this.m_rbPredictionA.Flush();
        this.m_rbPredictionB.Flush();
        this.m_rbAdaptA.Flush();
        this.m_rbAdaptB.Flush();
        int[] nArray = this.m_aryMA;
        this.m_aryMA[0] = 360;
        nArray[1] = 317;
        nArray[2] = -109;
        nArray[3] = 98;
        this.scaledFilterALV = 0;
        this.scaledFilterBLV = 0;
        this.m_nLastValueA = 0;
        this.m_nCurrentIndex = 0;
    }
}

