/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.info;

import de.quippy.jmac.info.WaveFormat;
import de.quippy.jmac.tools.ByteArrayReader;
import de.quippy.jmac.tools.ByteArrayWriter;
import de.quippy.jmac.tools.File;
import java.io.EOFException;
import java.io.IOException;

public class WaveHeader {
    public static final int WAVE_HEADER_BYTES = 44;
    public String cRIFFHeader;
    public long nRIFFBytes;
    public String cDataTypeID;
    public String cFormatHeader;
    public long nFormatBytes;
    public int nFormatTag;
    public int nChannels;
    public long nSamplesPerSec;
    public long nAvgBytesPerSec;
    public int nBlockAlign;
    public int nBitsPerSample;
    public String cDataHeader;
    public long nDataBytes;

    public static void FillWaveHeader(WaveHeader waveHeader, int n, WaveFormat waveFormat, int n2) {
        waveHeader.cRIFFHeader = "RIFF";
        waveHeader.nRIFFBytes = n + 44 - 8 + n2;
        waveHeader.cDataTypeID = "WAVE";
        waveHeader.cFormatHeader = "fmt ";
        waveHeader.nFormatBytes = 16L;
        waveHeader.nFormatTag = waveFormat.wFormatTag;
        waveHeader.nChannels = waveFormat.nChannels;
        waveHeader.nSamplesPerSec = waveFormat.nSamplesPerSec;
        waveHeader.nAvgBytesPerSec = waveFormat.nAvgBytesPerSec;
        waveHeader.nBlockAlign = waveFormat.nBlockAlign;
        waveHeader.nBitsPerSample = waveFormat.wBitsPerSample;
        waveHeader.cDataHeader = "data";
        waveHeader.nDataBytes = n;
    }

    public static final WaveHeader read(File file) throws IOException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(file, 44);
            return WaveHeader.read(byteArrayReader);
        }
        catch (EOFException eOFException) {
            return null;
        }
    }

    public static final WaveHeader read(byte[] byArray) {
        ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
        return WaveHeader.read(byteArrayReader);
    }

    private static final WaveHeader read(ByteArrayReader byteArrayReader) {
        WaveHeader waveHeader = new WaveHeader();
        waveHeader.cRIFFHeader = byteArrayReader.readString(4, "US-ASCII");
        waveHeader.nRIFFBytes = byteArrayReader.readUnsignedInt();
        waveHeader.cDataTypeID = byteArrayReader.readString(4, "US-ASCII");
        waveHeader.cFormatHeader = byteArrayReader.readString(4, "US-ASCII");
        waveHeader.nFormatBytes = byteArrayReader.readUnsignedInt();
        waveHeader.nFormatTag = byteArrayReader.readUnsignedShort();
        waveHeader.nChannels = byteArrayReader.readUnsignedShort();
        waveHeader.nSamplesPerSec = byteArrayReader.readUnsignedInt();
        waveHeader.nAvgBytesPerSec = byteArrayReader.readUnsignedInt();
        waveHeader.nBlockAlign = byteArrayReader.readUnsignedShort();
        waveHeader.nBitsPerSample = byteArrayReader.readUnsignedShort();
        waveHeader.cDataHeader = byteArrayReader.readString(4, "US-ASCII");
        waveHeader.nDataBytes = byteArrayReader.readUnsignedInt();
        return waveHeader;
    }

    public final byte[] write() {
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter(44);
        byteArrayWriter.writeString(this.cRIFFHeader, 4, "US-ASCII");
        byteArrayWriter.writeUnsignedInt(this.nRIFFBytes);
        byteArrayWriter.writeString(this.cDataTypeID, 4, "US-ASCII");
        byteArrayWriter.writeString(this.cFormatHeader, 4, "US-ASCII");
        byteArrayWriter.writeUnsignedInt(this.nFormatBytes);
        byteArrayWriter.writeUnsignedShort(this.nFormatTag);
        byteArrayWriter.writeUnsignedShort(this.nChannels);
        byteArrayWriter.writeUnsignedInt(this.nSamplesPerSec);
        byteArrayWriter.writeUnsignedInt(this.nAvgBytesPerSec);
        byteArrayWriter.writeUnsignedShort(this.nBlockAlign);
        byteArrayWriter.writeUnsignedShort(this.nBitsPerSample);
        byteArrayWriter.writeString(this.cDataHeader, 4, "US-ASCII");
        byteArrayWriter.writeUnsignedInt(this.nDataBytes);
        return byteArrayWriter.getBytes();
    }
}

