/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.info;

import de.quippy.jmac.tools.File;
import de.quippy.jmac.tools.JMACException;
import de.quippy.jmac.tools.RandomAccessFile;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class APELink {
    private static final String APE_LINK_HEADER = "[Monkey's Audio Image Link File]";
    private static final String APE_LINK_IMAGE_FILE_TAG = "Image File=";
    private static final String APE_LINK_START_BLOCK_TAG = "Start Block=";
    private static final String APE_LINK_FINISH_BLOCK_TAG = "Finish Block=";
    protected boolean m_bIsLinkFile;
    protected int m_nStartBlock;
    protected int m_nFinishBlock;
    protected String m_cImageFilename;

    public APELink(String string) throws IOException {
        this.m_bIsLinkFile = false;
        this.m_nStartBlock = 0;
        this.m_nFinishBlock = 0;
        this.m_cImageFilename = "";
        RandomAccessFile randomAccessFile = new RandomAccessFile(new java.io.File(string), "r");
        byte[] byArray = new byte[1024];
        int n = ((File)randomAccessFile).read(byArray);
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        this.ParseData(byArray2, string);
    }

    public APELink(byte[] byArray, String string) {
        this.ParseData(byArray, string);
    }

    public boolean GetIsLinkFile() {
        return this.m_bIsLinkFile;
    }

    public int GetStartBlock() {
        return this.m_nStartBlock;
    }

    public int GetFinishBlock() {
        return this.m_nFinishBlock;
    }

    public String GetImageFilename() {
        return this.m_cImageFilename;
    }

    protected void ParseData(byte[] byArray, String string) {
        this.m_bIsLinkFile = false;
        this.m_nStartBlock = 0;
        this.m_nFinishBlock = 0;
        this.m_cImageFilename = "";
        if (byArray != null) {
            String string2 = null;
            try {
                string2 = new String(byArray, "US-ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new JMACException("Unsupported encoding", unsupportedEncodingException);
            }
            int n = string2.indexOf(APE_LINK_HEADER);
            int n2 = string2.indexOf(APE_LINK_IMAGE_FILE_TAG);
            int n3 = string2.indexOf(APE_LINK_START_BLOCK_TAG);
            int n4 = string2.indexOf(APE_LINK_FINISH_BLOCK_TAG);
            if (n >= 0 && n2 >= 0 && n3 >= 0 && n4 >= 0) {
                int n5;
                int n6 = string2.indexOf(13, n3);
                int n7 = string2.indexOf(10, n3);
                int n8 = n6 > 0 && n7 > 0 ? Math.min(n6, n7) : Math.max(n6, n7);
                try {
                    this.m_nStartBlock = Integer.parseInt(string2.substring(n3 + APE_LINK_START_BLOCK_TAG.length(), n8 >= 0 ? n8 : string2.length()));
                }
                catch (Exception exception) {
                    this.m_nStartBlock = -1;
                }
                n6 = string2.indexOf(13, n4);
                n7 = string2.indexOf(10, n4);
                n8 = n6 > 0 && n7 > 0 ? Math.min(n6, n7) : Math.max(n6, n7);
                try {
                    this.m_nFinishBlock = Integer.parseInt(string2.substring(n4 + APE_LINK_FINISH_BLOCK_TAG.length(), n8 >= 0 ? n8 : string2.length()));
                }
                catch (Exception exception) {
                    this.m_nFinishBlock = -1;
                }
                n6 = string2.indexOf(13, n2);
                n7 = string2.indexOf(10, n2);
                n8 = n6 > 0 && n7 > 0 ? Math.min(n6, n7) : Math.max(n6, n7);
                String string3 = string2.substring(n2 + APE_LINK_IMAGE_FILE_TAG.length(), n8 >= 0 ? n8 : string2.length());
                this.m_cImageFilename = string3.lastIndexOf(92) < 0 ? ((n5 = string.lastIndexOf(92)) >= 0 ? String.valueOf(string.substring(0, n5)) + string3 : string3) : string3;
                this.m_bIsLinkFile = true;
            }
        }
    }
}

