/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.decoder;

import de.quippy.jmac.decoder.IAPEDecompress;
import de.quippy.jmac.decoder.UnMAC;
import de.quippy.jmac.info.APEFileInfo;
import de.quippy.jmac.info.APEInfo;
import de.quippy.jmac.info.APETag;
import de.quippy.jmac.info.WaveFormat;
import de.quippy.jmac.info.WaveHeader;
import de.quippy.jmac.tools.ByteBuffer;
import de.quippy.jmac.tools.File;
import de.quippy.jmac.tools.JMACException;
import java.io.IOException;
import java.util.Arrays;

public class APEDecompressOld
extends IAPEDecompress {
    protected byte[] m_spBuffer;
    protected int m_nBufferTail;
    protected ByteBuffer output = new ByteBuffer();
    protected int m_nBlockAlign;
    protected int m_nCurrentFrame;
    protected int m_nStartBlock;
    protected int m_nFinishBlock;
    protected int m_nCurrentBlock;
    protected boolean m_bIsRanged;
    protected UnMAC m_UnMAC = new UnMAC();
    protected APEInfo m_spAPEInfo;
    protected boolean m_bDecompressorInitialized;

    public APEDecompressOld(APEInfo aPEInfo) {
        this(aPEInfo, -1, -1);
    }

    public APEDecompressOld(APEInfo aPEInfo, int n) {
        this(aPEInfo, n, -1);
    }

    public APEDecompressOld(APEInfo aPEInfo, int n, int n2) {
        this.m_spAPEInfo = aPEInfo;
        if (this.getApeInfoFileVersion() > 3920) {
            throw new JMACException("Wrong Version");
        }
        this.m_nBlockAlign = this.getApeInfoBlockAlign();
        this.m_nBufferTail = 0;
        this.m_bDecompressorInitialized = false;
        this.m_nCurrentFrame = 0;
        this.m_nCurrentBlock = 0;
        this.m_nStartBlock = n < 0 ? 0 : Math.min(n, this.getApeInfoTotalBlocks());
        this.m_nFinishBlock = n2 < 0 ? this.getApeInfoTotalBlocks() : Math.min(n2, this.getApeInfoTotalBlocks());
        this.m_bIsRanged = this.m_nStartBlock != 0 || this.m_nFinishBlock != this.getApeInfoTotalBlocks();
    }

    @Override
    public int GetData(byte[] byArray, int n) throws IOException {
        int n2;
        this.InitializeDecompressor();
        int n3 = this.m_nFinishBlock - this.m_nCurrentBlock;
        n = Math.min(n, n3);
        int n4 = 0;
        int n5 = n2 = n * this.m_nBlockAlign;
        int n6 = 1;
        while (n5 > 0 && n6 > 0) {
            int n7 = this.m_nBufferTail;
            int n8 = Math.min(n5, n7);
            if (n8 > 0) {
                System.arraycopy(this.m_spBuffer, 0, byArray, n2 - n5, n8);
                if (this.m_nBufferTail - n8 > 0) {
                    System.arraycopy(this.m_spBuffer, n8, this.m_spBuffer, 0, this.m_nBufferTail - n8);
                }
                n5 -= n8;
                this.m_nBufferTail -= n8;
            }
            if (n5 <= 0) continue;
            this.output.reset(this.m_spBuffer, this.m_nBufferTail);
            n6 = this.m_UnMAC.DecompressFrame(this.output, this.m_nCurrentFrame++);
            this.m_nBufferTail += n6 * this.m_nBlockAlign;
        }
        n4 = (n2 - n5) / this.m_nBlockAlign;
        this.m_nCurrentBlock += n4;
        return n4;
    }

    @Override
    public void Seek(int n) throws IOException {
        this.InitializeDecompressor();
        if ((n += this.m_nStartBlock) >= this.m_nFinishBlock) {
            n = this.m_nFinishBlock - 1;
        }
        if (n < this.m_nStartBlock) {
            n = this.m_nStartBlock;
        }
        this.m_nBufferTail = 0;
        int n2 = n / this.getApeInfoBlocksPerFrame();
        int n3 = n % this.getApeInfoBlocksPerFrame();
        int n4 = n3 * this.m_nBlockAlign;
        int n5 = this.m_nBlockAlign * this.getApeInfoBlocksPerFrame();
        byte[] byArray = new byte[n5 + 16];
        Arrays.fill(byArray, (byte)0);
        this.m_nCurrentFrame = n2;
        this.output.reset(byArray);
        int n6 = this.m_UnMAC.DecompressFrame(this.output, this.m_nCurrentFrame++);
        if (n6 == -1) {
            throw new JMACException("Error While Decoding");
        }
        int n7 = n6 * this.m_nBlockAlign - n4;
        System.arraycopy(byArray, n4, this.m_spBuffer, this.m_nBufferTail, n7);
        this.m_nBufferTail += n7;
        this.m_nCurrentBlock = n;
    }

    protected void InitializeDecompressor() throws IOException {
        if (this.m_bDecompressorInitialized) {
            return;
        }
        this.m_UnMAC.Initialize(this);
        int n = this.m_nBlockAlign * this.getApeInfoBlocksPerFrame();
        int n2 = Math.max(65536, (n + 16) * 2);
        this.m_spBuffer = new byte[n2];
        this.m_bDecompressorInitialized = true;
        this.Seek(0);
    }

    @Override
    public int getApeInfoDecompressCurrentBlock() {
        return this.m_nCurrentBlock - this.m_nStartBlock;
    }

    @Override
    public int getApeInfoDecompressCurrentMS() {
        int n = this.m_spAPEInfo.getApeInfoSampleRate();
        if (n > 0) {
            return (int)((long)this.m_nCurrentBlock * 1000L / (long)n);
        }
        return 0;
    }

    @Override
    public int getApeInfoDecompressTotalBlocks() {
        return this.m_nFinishBlock - this.m_nStartBlock;
    }

    @Override
    public int getApeInfoDecompressLengthMS() {
        int n = this.m_spAPEInfo.getApeInfoSampleRate();
        if (n > 0) {
            return (int)((long)(this.m_nFinishBlock - this.m_nStartBlock) * 1000L / (long)n);
        }
        return 0;
    }

    @Override
    public int getApeInfoDecompressCurrentBitRate() throws IOException {
        return this.m_spAPEInfo.getApeInfoFrameBitrate(this.m_nCurrentFrame);
    }

    @Override
    public int getApeInfoDecompressAverageBitrate() throws IOException {
        if (this.m_bIsRanged) {
            int n = this.m_spAPEInfo.getApeInfoBlocksPerFrame();
            int n2 = this.m_nStartBlock / n;
            int n3 = (this.m_nFinishBlock + n - 1) / n;
            int n4 = this.m_spAPEInfo.getApeInfoFrameBytes(n2) * (this.m_nStartBlock % n) / n;
            if (n3 != n2) {
                n4 += this.m_spAPEInfo.getApeInfoFrameBytes(n3) * (this.m_nFinishBlock % n) / n;
            }
            int n5 = this.m_spAPEInfo.getApeInfoTotalFrames();
            int n6 = n2 + 1;
            while (n6 < n3 && n6 < n5) {
                n4 += this.m_spAPEInfo.getApeInfoFrameBytes(n6);
                ++n6;
            }
            n6 = (int)((long)(this.m_nFinishBlock - this.m_nStartBlock) * 1000L / (long)this.m_spAPEInfo.getApeInfoSampleRate());
            if (n6 != 0) {
                return n4 * 8 / n6;
            }
        } else {
            return this.m_spAPEInfo.getApeInfoAverageBitrate();
        }
        return 0;
    }

    @Override
    public int getApeInfoWavHeaderBytes() {
        if (this.m_bIsRanged) {
            return 44;
        }
        return this.m_spAPEInfo.getApeInfoWavHeaderBytes();
    }

    @Override
    public byte[] getApeInfoWavHeaderData(int n) {
        if (this.m_bIsRanged) {
            if (44 > n) {
                return null;
            }
            WaveFormat waveFormat = this.m_spAPEInfo.getApeInfoWaveFormatEx();
            WaveHeader waveHeader = new WaveHeader();
            WaveHeader.FillWaveHeader(waveHeader, (this.m_nFinishBlock - this.m_nStartBlock) * this.m_spAPEInfo.getApeInfoBlockAlign(), waveFormat, 0);
            return waveHeader.write();
        }
        return this.m_spAPEInfo.getApeInfoWavHeaderData(n);
    }

    @Override
    public int getApeInfoWavTerminatingBytes() {
        if (this.m_bIsRanged) {
            return 0;
        }
        return this.m_spAPEInfo.getApeInfoWavTerminatingBytes();
    }

    @Override
    public byte[] getApeInfoWavTerminatingData(int n) throws IOException {
        if (this.m_bIsRanged) {
            return null;
        }
        return this.m_spAPEInfo.getApeInfoWavTerminatingData(n);
    }

    @Override
    public WaveFormat getApeInfoWaveFormatEx() {
        return this.m_spAPEInfo.getApeInfoWaveFormatEx();
    }

    @Override
    public File getApeInfoIoSource() {
        return this.m_spAPEInfo.getApeInfoIoSource();
    }

    @Override
    public int getApeInfoBlocksPerFrame() {
        return this.m_spAPEInfo.getApeInfoBlocksPerFrame();
    }

    @Override
    public int getApeInfoFileVersion() {
        return this.m_spAPEInfo.getApeInfoFileVersion();
    }

    @Override
    public int getApeInfoCompressionLevel() {
        return this.m_spAPEInfo.getApeInfoCompressionLevel();
    }

    @Override
    public int getApeInfoFormatFlags() {
        return this.m_spAPEInfo.getApeInfoFormatFlags();
    }

    @Override
    public int getApeInfoSampleRate() {
        return this.m_spAPEInfo.getApeInfoSampleRate();
    }

    @Override
    public int getApeInfoBitsPerSample() {
        return this.m_spAPEInfo.getApeInfoBitsPerSample();
    }

    @Override
    public int getApeInfoBytesPerSample() {
        return this.m_spAPEInfo.getApeInfoBytesPerSample();
    }

    @Override
    public int getApeInfoChannels() {
        return this.m_spAPEInfo.getApeInfoChannels();
    }

    @Override
    public int getApeInfoBlockAlign() {
        return this.m_spAPEInfo.getApeInfoBlockAlign();
    }

    @Override
    public int getApeInfoFinalFrameBlocks() {
        return this.m_spAPEInfo.getApeInfoFinalFrameBlocks();
    }

    @Override
    public int getApeInfoTotalFrames() {
        return this.m_spAPEInfo.getApeInfoTotalFrames();
    }

    @Override
    public int getApeInfoWavDataBytes() {
        return this.m_spAPEInfo.getApeInfoWavDataBytes();
    }

    @Override
    public int getApeInfoWavTotalBytes() {
        return this.m_spAPEInfo.getApeInfoWavTotalBytes();
    }

    @Override
    public int getApeInfoApeTotalBytes() {
        return this.m_spAPEInfo.getApeInfoApeTotalBytes();
    }

    @Override
    public int getApeInfoTotalBlocks() {
        return this.m_spAPEInfo.getApeInfoTotalBlocks();
    }

    @Override
    public int getApeInfoLengthMs() {
        return this.m_spAPEInfo.getApeInfoLengthMs();
    }

    @Override
    public int getApeInfoAverageBitrate() {
        return this.m_spAPEInfo.getApeInfoAverageBitrate();
    }

    @Override
    public int getApeInfoSeekByte(int n) {
        return this.m_spAPEInfo.getApeInfoSeekByte(n);
    }

    @Override
    public int getApeInfoFrameBytes(int n) throws IOException {
        return this.m_spAPEInfo.getApeInfoFrameBytes(n);
    }

    @Override
    public int getApeInfoFrameBlocks(int n) {
        return this.m_spAPEInfo.getApeInfoFrameBlocks(n);
    }

    @Override
    public int getApeInfoFrameBitrate(int n) throws IOException {
        return this.m_spAPEInfo.getApeInfoFrameBitrate(n);
    }

    @Override
    public int getApeInfoDecompressedBitrate() {
        return this.m_spAPEInfo.getApeInfoDecompressedBitrate();
    }

    @Override
    public int getApeInfoPeakLevel() {
        return this.m_spAPEInfo.getApeInfoPeakLevel();
    }

    @Override
    public int getApeInfoSeekBit(int n) {
        return this.m_spAPEInfo.getApeInfoSeekBit(n);
    }

    @Override
    public APETag getApeInfoTag() {
        return this.m_spAPEInfo.getApeInfoTag();
    }

    @Override
    public APEFileInfo getApeInfoInternalInfo() {
        return this.m_spAPEInfo.getApeInfoInternalInfo();
    }
}

