/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jflac;

import de.quippy.jflac.ChannelData;
import de.quippy.jflac.Constants;
import de.quippy.jflac.FrameDecodeException;
import de.quippy.jflac.FrameListener;
import de.quippy.jflac.FrameListeners;
import de.quippy.jflac.PCMProcessor;
import de.quippy.jflac.PCMProcessors;
import de.quippy.jflac.frame.BadHeaderException;
import de.quippy.jflac.frame.ChannelConstant;
import de.quippy.jflac.frame.ChannelFixed;
import de.quippy.jflac.frame.ChannelLPC;
import de.quippy.jflac.frame.ChannelVerbatim;
import de.quippy.jflac.frame.Frame;
import de.quippy.jflac.frame.Header;
import de.quippy.jflac.io.BitInputStream;
import de.quippy.jflac.io.RandomFileInputStream;
import de.quippy.jflac.metadata.Application;
import de.quippy.jflac.metadata.CueSheet;
import de.quippy.jflac.metadata.Metadata;
import de.quippy.jflac.metadata.Padding;
import de.quippy.jflac.metadata.Picture;
import de.quippy.jflac.metadata.SeekPoint;
import de.quippy.jflac.metadata.SeekTable;
import de.quippy.jflac.metadata.StreamInfo;
import de.quippy.jflac.metadata.Unknown;
import de.quippy.jflac.metadata.VorbisComment;
import de.quippy.jflac.util.ByteData;
import de.quippy.jflac.util.CRC16;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class FLACDecoder {
    private static final int FRAME_FOOTER_CRC_LEN = 16;
    private static final byte[] ID3V2_TAG = new byte[]{73, 68, 51};
    private BitInputStream bitStream;
    private ChannelData[] channelData = new ChannelData[8];
    private int outputCapacity = 0;
    private int outputChannels = 0;
    private int lastFrameNumber;
    private long samplesDecoded = 0L;
    private StreamInfo streamInfo;
    private SeekTable seekTable;
    private VorbisComment vorbisComment;
    private Frame frame = new Frame();
    private byte[] headerWarmup = new byte[2];
    private int channels;
    private int channelAssignment;
    private int bitsPerSample;
    private int sampleRate;
    private int blockSize;
    private InputStream inputStream = null;
    private int badFrames;
    private boolean eof = false;
    private FrameListeners frameListeners = new FrameListeners();
    private PCMProcessors pcmProcessors = new PCMProcessors();

    public FLACDecoder(InputStream inputStream) {
        this.inputStream = inputStream;
        this.bitStream = new BitInputStream(inputStream);
        this.lastFrameNumber = 0;
        this.samplesDecoded = 0L;
    }

    public StreamInfo getStreamInfo() {
        return this.streamInfo;
    }

    public SeekTable getSeekTable() {
        return this.seekTable;
    }

    public VorbisComment getVorbisComment() {
        return this.vorbisComment;
    }

    public ChannelData[] getChannelData() {
        return this.channelData;
    }

    public BitInputStream getBitInputStream() {
        return this.bitStream;
    }

    public Frame getCurrentFrame() {
        return this.frame;
    }

    public int getChannelAssignment() {
        return this.channelAssignment;
    }

    public int getBitsPerSample() {
        return this.bitsPerSample;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getLastFrameNumber() {
        return this.lastFrameNumber;
    }

    public long getSamplesDecoded() {
        return this.samplesDecoded;
    }

    public int getBadFrames() {
        return this.badFrames;
    }

    public boolean isEOF() {
        return this.eof;
    }

    public void addFrameListener(FrameListener frameListener) {
        this.frameListeners.addFrameListener(frameListener);
    }

    public void removeFrameListener(FrameListener frameListener) {
        this.frameListeners.removeFrameListener(frameListener);
    }

    public void addPCMProcessor(PCMProcessor pCMProcessor) {
        this.pcmProcessors.addPCMProcessor(pCMProcessor);
    }

    public void removePCMProcessor(PCMProcessor pCMProcessor) {
        this.pcmProcessors.removePCMProcessor(pCMProcessor);
    }

    private void callPCMProcessors(Frame frame) {
        ByteData byteData = this.decodeFrame(frame, null);
        this.pcmProcessors.processPCM(byteData);
    }

    public ByteData decodeFrame(Frame frame, ByteData byteData) {
        block9: {
            block10: {
                block8: {
                    int n = frame.header.blockSize * this.channels * ((this.streamInfo.getBitsPerSample() + 7) / 2);
                    if (byteData == null || byteData.getData().length < n) {
                        byteData = new ByteData(n);
                    } else {
                        byteData.setLen(0);
                    }
                    if (this.streamInfo.getBitsPerSample() != 8) break block8;
                    int n2 = 0;
                    while (n2 < frame.header.blockSize) {
                        int n3 = 0;
                        while (n3 < this.channels) {
                            byteData.append((byte)(this.channelData[n3].getOutput()[n2] + 128));
                            ++n3;
                        }
                        ++n2;
                    }
                    break block9;
                }
                if (this.streamInfo.getBitsPerSample() != 16) break block10;
                int n = 0;
                while (n < frame.header.blockSize) {
                    int n4 = 0;
                    while (n4 < this.channels) {
                        short s = (short)this.channelData[n4].getOutput()[n];
                        byteData.append((byte)(s & 0xFF));
                        byteData.append((byte)(s >> 8 & 0xFF));
                        ++n4;
                    }
                    ++n;
                }
                break block9;
            }
            if (this.streamInfo.getBitsPerSample() != 24) break block9;
            int n = 0;
            while (n < frame.header.blockSize) {
                int n5 = 0;
                while (n5 < this.channels) {
                    int n6 = this.channelData[n5].getOutput()[n];
                    byteData.append((byte)(n6 & 0xFF));
                    byteData.append((byte)(n6 >> 8 & 0xFF));
                    byteData.append((byte)(n6 >> 16 & 0xFF));
                    ++n5;
                }
                ++n;
            }
        }
        return byteData;
    }

    public StreamInfo readStreamInfo() throws IOException {
        this.readStreamSync();
        Metadata metadata = this.readNextMetadata();
        if (!(metadata instanceof StreamInfo)) {
            throw new IOException("StreamInfo metadata block missing");
        }
        return (StreamInfo)metadata;
    }

    public Metadata[] readMetadata() throws IOException {
        Metadata metadata;
        this.readStreamSync();
        ArrayList<Metadata> arrayList = new ArrayList<Metadata>();
        do {
            metadata = this.readNextMetadata();
            arrayList.add(metadata);
        } while (!metadata.isLast());
        return arrayList.toArray(new Metadata[0]);
    }

    public Metadata[] readMetadata(StreamInfo streamInfo) throws IOException {
        Metadata metadata;
        if (streamInfo.isLast()) {
            return new Metadata[0];
        }
        ArrayList<Metadata> arrayList = new ArrayList<Metadata>();
        do {
            metadata = this.readNextMetadata();
            arrayList.add(metadata);
        } while (!metadata.isLast());
        return arrayList.toArray(new Metadata[0]);
    }

    public void decode() throws IOException {
        this.readMetadata();
        try {
            while (true) {
                this.findFrameSync();
                try {
                    this.readFrame();
                    this.frameListeners.processFrame(this.frame);
                    this.callPCMProcessors(this.frame);
                }
                catch (FrameDecodeException frameDecodeException) {
                    ++this.badFrames;
                }
            }
        }
        catch (EOFException eOFException) {
            this.eof = true;
            return;
        }
    }

    public void decodeFrames() throws IOException {
        try {
            while (true) {
                this.findFrameSync();
                try {
                    this.readFrame();
                    this.frameListeners.processFrame(this.frame);
                    this.callPCMProcessors(this.frame);
                }
                catch (FrameDecodeException frameDecodeException) {
                    ++this.badFrames;
                }
            }
        }
        catch (EOFException eOFException) {
            this.eof = true;
            return;
        }
    }

    public void decode(SeekPoint seekPoint, SeekPoint seekPoint2) throws IOException {
        if (!(this.inputStream instanceof RandomFileInputStream)) {
            throw new IOException("Not a RandomFileInputStream: " + this.inputStream.getClass().getName());
        }
        ((RandomFileInputStream)this.inputStream).seek(seekPoint.getStreamOffset());
        this.bitStream.reset();
        this.samplesDecoded = seekPoint.getSampleNumber();
        try {
            do {
                this.findFrameSync();
                try {
                    this.readFrame();
                    this.frameListeners.processFrame(this.frame);
                    this.callPCMProcessors(this.frame);
                }
                catch (FrameDecodeException frameDecodeException) {
                    ++this.badFrames;
                }
            } while (seekPoint2 == null || this.samplesDecoded < seekPoint2.getSampleNumber());
            return;
        }
        catch (EOFException eOFException) {
            this.eof = true;
            return;
        }
    }

    public Frame readNextFrame() throws IOException {
        try {
            while (true) {
                this.findFrameSync();
                try {
                    this.readFrame();
                    return this.frame;
                }
                catch (FrameDecodeException frameDecodeException) {
                    ++this.badFrames;
                    continue;
                }
                break;
            }
        }
        catch (EOFException eOFException) {
            this.eof = true;
            return null;
        }
    }

    public long getTotalBytesRead() {
        return this.bitStream.getTotalBytesRead();
    }

    private void allocateOutput(int n, int n2) {
        if (n <= this.outputCapacity && n2 <= this.outputChannels) {
            return;
        }
        int n3 = 0;
        while (n3 < 8) {
            this.channelData[n3] = null;
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            this.channelData[n3] = new ChannelData(n);
            ++n3;
        }
        this.outputCapacity = n;
        this.outputChannels = n2;
    }

    private void readStreamSync() throws IOException {
        int n = 0;
        int n2 = 0;
        while (n2 < 4) {
            int n3 = this.bitStream.readRawUInt(8);
            if (n3 == Constants.STREAM_SYNC_STRING[n2]) {
                ++n2;
                n = 0;
                continue;
            }
            if (n3 == ID3V2_TAG[n]) {
                n2 = 0;
                if (++n != 3) continue;
                this.skipID3v2Tag();
                n = 0;
                continue;
            }
            throw new IOException("Could not find Stream Sync");
        }
    }

    public Metadata readNextMetadata() throws IOException {
        Metadata metadata = null;
        boolean bl = this.bitStream.readRawUInt(1) != 0;
        int n = this.bitStream.readRawUInt(7);
        int n2 = this.bitStream.readRawUInt(24);
        if (n == 0) {
            metadata = this.streamInfo = new StreamInfo(this.bitStream, n2, bl);
            this.pcmProcessors.processStreamInfo((StreamInfo)metadata);
        } else if (n == 3) {
            this.seekTable = new SeekTable(this.bitStream, n2, bl);
            metadata = this.seekTable;
        } else if (n == 2) {
            metadata = new Application(this.bitStream, n2, bl);
        } else if (n == 1) {
            metadata = new Padding(this.bitStream, n2, bl);
        } else if (n == 4) {
            this.vorbisComment = new VorbisComment(this.bitStream, n2, bl);
            metadata = this.vorbisComment;
        } else {
            metadata = n == 5 ? new CueSheet(this.bitStream, n2, bl) : (n == 6 ? new Picture(this.bitStream, n2, bl) : new Unknown(this.bitStream, n2, bl));
        }
        this.frameListeners.processMetadata(metadata);
        return metadata;
    }

    private void skipID3v2Tag() throws IOException {
        this.bitStream.readRawInt(8);
        this.bitStream.readRawInt(8);
        this.bitStream.readRawInt(8);
        int n = 0;
        int n2 = 0;
        while (n2 < 4) {
            int n3 = this.bitStream.readRawUInt(8);
            n <<= 7;
            n |= n3 & 0x7F;
            ++n2;
        }
        this.bitStream.readByteBlockAlignedNoCRC(null, n);
    }

    public void findFrameSync() throws IOException {
        boolean bl = true;
        if (this.streamInfo != null && this.streamInfo.getTotalSamples() != 0L && this.samplesDecoded >= this.streamInfo.getTotalSamples()) {
            return;
        }
        if (!this.bitStream.isConsumedByteAligned()) {
            this.bitStream.readRawUInt(this.bitStream.bitsLeftForByteAlignment());
        }
        try {
            while (true) {
                int n;
                if ((n = this.bitStream.readRawUInt(8)) == 255) {
                    this.headerWarmup[0] = (byte)n;
                    n = this.bitStream.peekRawUInt(8);
                    if (n >> 2 == 62) {
                        this.headerWarmup[1] = (byte)this.bitStream.readRawUInt(8);
                        return;
                    }
                }
                if (!bl) continue;
                this.frameListeners.processError("FindSync LOST_SYNC: " + Integer.toHexString(n & 0xFF));
                bl = false;
            }
        }
        catch (EOFException eOFException) {
            if (!bl) {
                this.frameListeners.processError("FindSync LOST_SYNC: Left over data in file");
            }
            return;
        }
    }

    public Frame readFrame() throws IOException, FrameDecodeException {
        block24: {
            int n;
            int n2;
            short s;
            block23: {
                s = 0;
                s = CRC16.update(this.headerWarmup[0], s);
                s = CRC16.update(this.headerWarmup[1], s);
                this.bitStream.resetReadCRC16(s);
                try {
                    this.frame.header = new Header(this.bitStream, this.headerWarmup, this.streamInfo);
                }
                catch (BadHeaderException badHeaderException) {
                    this.frameListeners.processError("Found bad header: " + badHeaderException);
                    throw new FrameDecodeException("Bad Frame Header: " + badHeaderException);
                }
                this.allocateOutput(this.frame.header.blockSize, this.frame.header.channels);
                n2 = 0;
                while (n2 < this.frame.header.channels) {
                    n = this.frame.header.bitsPerSample;
                    switch (this.frame.header.channelAssignment) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            if (n2 != 1) break;
                            ++n;
                            break;
                        }
                        case 2: {
                            if (n2 != 0) break;
                            ++n;
                            break;
                        }
                        case 3: {
                            if (n2 != 1) break;
                            ++n;
                        }
                    }
                    try {
                        this.readSubframe(n2, n);
                    }
                    catch (IOException iOException) {
                        this.frameListeners.processError("ReadSubframe: " + iOException);
                        throw iOException;
                    }
                    ++n2;
                }
                this.readZeroPadding();
                s = this.bitStream.getReadCRC16();
                this.frame.setCRC((short)this.bitStream.readRawUInt(16));
                if (s != this.frame.getCRC()) break block23;
                switch (this.frame.header.channelAssignment) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        int n3 = 0;
                        while (n3 < this.frame.header.blockSize) {
                            this.channelData[1].getOutput()[n3] = this.channelData[0].getOutput()[n3] - this.channelData[1].getOutput()[n3];
                            ++n3;
                        }
                        break block24;
                    }
                    case 2: {
                        int n4 = 0;
                        while (n4 < this.frame.header.blockSize) {
                            int[] nArray = this.channelData[0].getOutput();
                            int n5 = n4;
                            nArray[n5] = nArray[n5] + this.channelData[1].getOutput()[n4];
                            ++n4;
                        }
                        break block24;
                    }
                    case 3: {
                        int n6 = 0;
                        while (n6 < this.frame.header.blockSize) {
                            int n7 = this.channelData[0].getOutput()[n6];
                            int n8 = this.channelData[1].getOutput()[n6];
                            n7 <<= 1;
                            if ((n8 & 1) != 0) {
                                ++n7;
                            }
                            int n9 = n7 + n8;
                            int n10 = n7 - n8;
                            this.channelData[0].getOutput()[n6] = n9 >>> 1;
                            this.channelData[1].getOutput()[n6] = n10 >>> 1;
                            ++n6;
                        }
                        break block24;
                    }
                }
                break block24;
            }
            this.frameListeners.processError("CRC Error: " + Integer.toHexString(s & 0xFFFF) + " vs " + Integer.toHexString(this.frame.getCRC() & 0xFFFF));
            n2 = 0;
            while (n2 < this.frame.header.channels) {
                n = 0;
                while (n < this.frame.header.blockSize) {
                    this.channelData[n2].getOutput()[n] = 0;
                    ++n;
                }
                ++n2;
            }
        }
        this.channels = this.frame.header.channels;
        this.channelAssignment = this.frame.header.channelAssignment;
        this.bitsPerSample = this.frame.header.bitsPerSample;
        this.sampleRate = this.frame.header.sampleRate;
        this.blockSize = this.frame.header.blockSize;
        this.samplesDecoded += (long)this.frame.header.blockSize;
        return this.frame;
    }

    private void readSubframe(int n, int n2) throws IOException, FrameDecodeException {
        int n3 = this.bitStream.readRawUInt(8);
        boolean bl = (n3 & 1) != 0;
        n3 &= 0xFE;
        int n4 = 0;
        if (bl) {
            n4 = this.bitStream.readUnaryUnsigned() + 1;
            n2 -= n4;
        }
        if ((n3 & 0x80) != 0) {
            this.frameListeners.processError("ReadSubframe LOST_SYNC: " + Integer.toHexString(n3 & 0xFF));
            throw new FrameDecodeException("ReadSubframe LOST_SYNC: " + Integer.toHexString(n3 & 0xFF));
        }
        if (n3 == 0) {
            this.frame.subframes[n] = new ChannelConstant(this.bitStream, this.frame.header, this.channelData[n], n2, n4);
        } else if (n3 == 2) {
            this.frame.subframes[n] = new ChannelVerbatim(this.bitStream, this.frame.header, this.channelData[n], n2, n4);
        } else {
            if (n3 < 16) {
                throw new FrameDecodeException("ReadSubframe Bad Subframe Type: " + Integer.toHexString(n3 & 0xFF));
            }
            if (n3 <= 24) {
                this.frame.subframes[n] = new ChannelFixed(this.bitStream, this.frame.header, this.channelData[n], n2, n4, n3 >> 1 & 7);
            } else {
                if (n3 < 64) {
                    throw new FrameDecodeException("ReadSubframe Bad Subframe Type: " + Integer.toHexString(n3 & 0xFF));
                }
                this.frame.subframes[n] = new ChannelLPC(this.bitStream, this.frame.header, this.channelData[n], n2, n4, (n3 >> 1 & 0x1F) + 1);
            }
        }
        if (bl) {
            n3 = this.frame.subframes[n].getWastedBits();
            int n5 = 0;
            while (n5 < this.frame.header.blockSize) {
                int[] nArray = this.channelData[n].getOutput();
                int n6 = n5++;
                nArray[n6] = nArray[n6] << n3;
            }
        }
    }

    private void readZeroPadding() throws IOException, FrameDecodeException {
        int n;
        if (!this.bitStream.isConsumedByteAligned() && (n = this.bitStream.readRawUInt(this.bitStream.bitsLeftForByteAlignment())) != 0) {
            this.frameListeners.processError("ZeroPaddingError: " + Integer.toHexString(n));
            throw new FrameDecodeException("ZeroPaddingError: " + Integer.toHexString(n));
        }
    }

    public void seekTo(long l) throws IOException {
        if (this.seekTable != null) {
            int n = 0;
            while (n < this.seekTable.numberOfPoints()) {
                SeekPoint seekPoint = this.seekTable.getSeekPoint(n);
                this.samplesDecoded = seekPoint.getSampleNumber();
                if (this.samplesDecoded >= l) {
                    if (n > 0) {
                        seekPoint = this.seekTable.getSeekPoint(n - 1);
                    }
                    this.samplesDecoded = seekPoint.getSampleNumber();
                    this.bitStream.skip(seekPoint.getStreamOffset());
                    break;
                }
                ++n;
            }
        }
        while (this.samplesDecoded < l) {
            try {
                this.findFrameSync();
                this.readFrame();
                if (this.frame == null || this.frame.header == null) continue;
                this.samplesDecoded = this.frame.header.sampleNumber;
                if (this.samplesDecoded + (long)this.frame.header.blockSize < l) continue;
                break;
            }
            catch (Throwable throwable) {}
        }
    }
}

