/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod.loader.tracker;

import de.quippy.javamod.io.ModfileInputStream;
import de.quippy.javamod.multimedia.mod.loader.Module;
import de.quippy.javamod.multimedia.mod.loader.ModuleFactory;
import de.quippy.javamod.multimedia.mod.loader.instrument.InstrumentsContainer;
import de.quippy.javamod.multimedia.mod.loader.instrument.Sample;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternContainer;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternElement;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternRow;
import de.quippy.javamod.multimedia.mod.mixer.BasicModMixer;
import de.quippy.javamod.multimedia.mod.mixer.ScreamTrackerMixer;
import de.quippy.javamod.system.Helpers;
import java.io.IOException;

public class ScreamTrackerMod
extends Module {
    private static final String[] MODFILEEXTENSION = new String[]{"s3m"};
    protected int version;
    protected int flags;
    protected int samplesType;
    protected boolean isStereo;
    protected boolean usePanningValues;
    protected int[] channelSettings;
    protected int[] panningValue;
    private int[] channelMap;

    static {
        ModuleFactory.registerModule(new ScreamTrackerMod());
    }

    public ScreamTrackerMod() {
    }

    protected ScreamTrackerMod(String string) {
        super(string);
    }

    @Override
    public String[] getFileExtensionList() {
        return MODFILEEXTENSION;
    }

    @Override
    public BasicModMixer getModMixer(int n, int n2, int n3) {
        return new ScreamTrackerMixer(this, n, n2, n3);
    }

    @Override
    public int getPanningValue(int n) {
        return this.panningValue[n];
    }

    @Override
    public int getChannelVolume(int n) {
        return 64;
    }

    @Override
    public int getFrequencyTable() {
        return 0;
    }

    @Override
    public boolean doFastSlides() {
        return (this.flags & 0x40) != 0;
    }

    private void setPattern(int n, ModfileInputStream modfileInputStream) throws IOException {
        int n2 = 0;
        PatternRow patternRow = this.getPatternContainer().getPatternRow(n, n2);
        int n3 = modfileInputStream.readIntelWord() - 2;
        while (n3 >= 0) {
            int n4 = modfileInputStream.readByteAsInt();
            --n3;
            if (n4 == 0) {
                if (++n2 >= 64) break;
                patternRow = this.getPatternContainer().getPatternRow(n, n2);
                continue;
            }
            int n5 = n4 & 0x1F;
            n5 = this.channelMap[n5];
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = -1;
            int n10 = 0;
            int n11 = 0;
            if ((n4 & 0x20) != 0) {
                int n12 = modfileInputStream.readByteAsInt();
                --n3;
                if (n12 == 254) {
                    n6 = -2;
                    n7 = -2;
                } else {
                    n7 = ((n12 >> 4) + 1) * 12 + (n12 & 0xF);
                    if (n7 >= Helpers.noteValues.length) {
                        n6 = 0;
                        n7 = 0;
                    } else {
                        n6 = Helpers.noteValues[n7];
                        ++n7;
                    }
                }
                n8 = modfileInputStream.readByteAsInt();
                --n3;
            }
            if ((n4 & 0x40) != 0) {
                n9 = modfileInputStream.readByteAsInt();
                --n3;
            }
            if ((n4 & 0x80) != 0) {
                n10 = modfileInputStream.readByteAsInt();
                --n3;
                n11 = modfileInputStream.readByteAsInt();
                --n3;
            }
            if (n5 == -1) continue;
            PatternElement patternElement = patternRow.getPatternElement(n5);
            patternElement.setNoteIndex(n7);
            patternElement.setPeriod(n6);
            patternElement.setInstrument(n8);
            if (n9 != -1) {
                patternElement.setVolumeEffekt(1);
                patternElement.setVolumeEffektOp(n9);
            }
            patternElement.setEffekt(n10);
            patternElement.setEffektOp(n11);
        }
    }

    @Override
    public boolean checkLoadingPossible(ModfileInputStream modfileInputStream) throws IOException {
        modfileInputStream.seek(44L);
        String string = modfileInputStream.readString(4);
        modfileInputStream.seek(0L);
        return string.equals("SCRM");
    }

    @Override
    protected Module getNewInstance(String string) {
        return new ScreamTrackerMod(string);
    }

    @Override
    public void loadModFileInternal(ModfileInputStream modfileInputStream) throws IOException {
        int n;
        this.setModType(4);
        modfileInputStream.seek(29L);
        int n2 = modfileInputStream.readByteAsInt();
        if (n2 != 16) {
            throw new IOException("Unsupported S3M MOD (ID!=0x10)");
        }
        modfileInputStream.seek(0L);
        this.setSongName(modfileInputStream.readString(28));
        modfileInputStream.seek(32L);
        this.setSongLength(modfileInputStream.readIntelWord());
        this.setNSamples(modfileInputStream.readIntelWord());
        this.setNInstruments(this.getNSamples());
        this.setNPattern(modfileInputStream.readIntelWord());
        this.setNChannels(32);
        this.flags = modfileInputStream.readIntelWord();
        this.version = modfileInputStream.readIntelWord();
        this.samplesType = modfileInputStream.readIntelWord();
        this.setModID(modfileInputStream.readString(4));
        this.setTrackerName("ScreamTracker V" + (this.version >> 8 & 0xF) + '.' + (this.version & 0xFF));
        this.setBaseVolume(modfileInputStream.readByteAsInt() << 1);
        this.setTempo(modfileInputStream.readByteAsInt());
        this.setBPMSpeed(modfileInputStream.readByteAsInt());
        this.isStereo = (modfileInputStream.readByteAsInt() & 0x80) != 0;
        modfileInputStream.readByteAsInt();
        this.usePanningValues = modfileInputStream.readByteAsInt() == 252;
        modfileInputStream.skip(10L);
        this.channelSettings = new int[32];
        this.channelMap = new int[32];
        int n3 = 0;
        int n4 = 0;
        while (n4 < 32) {
            n = modfileInputStream.readByteAsInt();
            if (n != 255) {
                this.channelMap[n4] = n3;
                this.channelSettings[n3++] = n;
            } else {
                this.channelMap[n4] = -1;
            }
            ++n4;
        }
        this.setNChannels(n3);
        this.allocArrangement(this.getSongLength());
        n4 = 0;
        while (n4 < this.getSongLength()) {
            this.getArrangement()[n4] = modfileInputStream.readByteAsInt();
            ++n4;
        }
        InstrumentsContainer instrumentsContainer = new InstrumentsContainer(this, 0, this.getNSamples());
        this.setInstrumentContainer(instrumentsContainer);
        n = 0;
        while (n < this.getNSamples()) {
            int n5;
            modfileInputStream.seek(96L + (long)this.getSongLength() + (long)(n << 1));
            long l = modfileInputStream.readIntelWord();
            modfileInputStream.seek(l << 4);
            Sample sample = new Sample();
            sample.setType(modfileInputStream.readByteAsInt());
            sample.setDosFileName(modfileInputStream.readString(13));
            long l2 = modfileInputStream.readIntelWord();
            sample.setLength(modfileInputStream.readIntelDWord());
            int n6 = modfileInputStream.readIntelDWord();
            int n7 = modfileInputStream.readIntelDWord();
            sample.setRepeatStart(n6);
            sample.setRepeatStop(n7);
            sample.setRepeatLength(n7 - n6);
            sample.setVolume(modfileInputStream.readByteAsInt());
            modfileInputStream.skip(2L);
            sample.setFlags(modfileInputStream.readByteAsInt());
            sample.setLoopType((sample.flags & 1) == 1 ? 1 : 0);
            sample.setFineTune(0);
            sample.setTranspose(0);
            sample.setBaseFrequency(modfileInputStream.readIntelDWord());
            modfileInputStream.skip(12L);
            sample.setName(modfileInputStream.readString(28));
            modfileInputStream.skip(4L);
            sample.setPanning(-1);
            int n8 = n5 = this.samplesType == 2 ? 1 : 0;
            if ((sample.flags & 4) != 0) {
                n5 |= 4;
            }
            modfileInputStream.seek(l2 << 4);
            this.readSampleData(sample, n5, modfileInputStream);
            instrumentsContainer.setSample(n, sample);
            ++n;
        }
        PatternContainer patternContainer = new PatternContainer(this.getNPattern(), 64, this.getNChannels());
        this.setPatternContainer(patternContainer);
        int n9 = 0;
        while (n9 < this.getNPattern()) {
            int n10 = 0;
            while (n10 < 64) {
                int n11 = 0;
                while (n11 < this.getNChannels()) {
                    PatternElement patternElement = new PatternElement(n9, n10, n11);
                    patternContainer.setPatternElement(patternElement);
                    ++n11;
                }
                ++n10;
            }
            modfileInputStream.seek(96L + (long)this.getSongLength() + (long)(this.getNSamples() << 1) + (long)(n9 << 1));
            long l = modfileInputStream.readIntelWord();
            modfileInputStream.seek(l << 4);
            this.setPattern(n9, modfileInputStream);
            ++n9;
        }
        this.panningValue = new int[this.getNChannels()];
        if (this.usePanningValues) {
            modfileInputStream.seek(96L + (long)this.getSongLength() + (long)(this.getNSamples() << 1) + (long)(this.getNPattern() << 1));
            n9 = 0;
            while (n9 < this.getNChannels()) {
                int n12 = modfileInputStream.readByteAsInt() & 0xF;
                int n13 = this.channelMap[n9];
                if (n13 != -1) {
                    int n14 = n12 << 4;
                    this.panningValue[n13] = this.channelSettings[n13] <= 7 || n12 != 0 ? n14 : 256 - n14;
                }
                ++n9;
            }
        } else if (!this.isStereo) {
            n9 = 0;
            while (n9 < this.getNChannels()) {
                this.panningValue[n9] = 128;
                ++n9;
            }
        } else {
            n9 = 0;
            while (n9 < this.getNChannels()) {
                this.panningValue[n9] = this.channelSettings[n9] <= 7 ? 256 : 0;
                ++n9;
            }
        }
        n9 = 0;
        int n15 = 0;
        while (n15 < this.getSongLength()) {
            if (this.getArrangement()[n15] < 254 && this.getArrangement()[n15] < this.getNPattern()) {
                this.getArrangement()[n9++] = this.getArrangement()[n15];
            }
            ++n15;
        }
        this.setSongLength(n9);
        this.cleanUpArrangement();
    }
}

