/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod.loader.pattern;

import de.quippy.javamod.system.Helpers;

public class PatternElement {
    private int patternIndex;
    private int row;
    private int channel;
    private int period;
    private int noteIndex;
    private int instrument;
    private int effekt;
    private int effektOp;
    private int volumeEffekt;
    private int volumeEffektOp;

    public PatternElement(int n, int n2, int n3) {
        this.patternIndex = n;
        this.row = n2;
        this.channel = n3;
        this.period = 0;
        this.noteIndex = 0;
        this.instrument = 0;
        this.volumeEffekt = 0;
        this.volumeEffektOp = 0;
        this.effekt = 0;
        this.effektOp = 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(Helpers.getNoteNameToPeriod(this.noteIndex));
        if (this.period == 0 && this.noteIndex != 0 || this.period != 0 && this.noteIndex == 0) {
            stringBuilder.append('!');
        } else {
            stringBuilder.append(' ');
        }
        if (this.instrument != 0) {
            stringBuilder.append(Helpers.getAsHex(this.instrument, 2));
        } else {
            stringBuilder.append("..");
        }
        if (this.volumeEffekt != 0) {
            switch (this.volumeEffekt) {
                case 1: {
                    stringBuilder.append('v');
                    break;
                }
                case 2: {
                    stringBuilder.append('d');
                    break;
                }
                case 3: {
                    stringBuilder.append('c');
                    break;
                }
                case 4: {
                    stringBuilder.append('b');
                    break;
                }
                case 5: {
                    stringBuilder.append('a');
                    break;
                }
                case 6: {
                    stringBuilder.append('u');
                    break;
                }
                case 7: {
                    stringBuilder.append('h');
                    break;
                }
                case 8: {
                    stringBuilder.append('p');
                    break;
                }
                case 9: {
                    stringBuilder.append('l');
                    break;
                }
                case 10: {
                    stringBuilder.append('r');
                    break;
                }
                case 11: {
                    stringBuilder.append('g');
                }
            }
            stringBuilder.append(Helpers.getAsHex(this.volumeEffektOp, 2));
        } else {
            stringBuilder.append(" ..");
        }
        stringBuilder.append(' ');
        if (this.effekt != 0) {
            if (this.effekt < 15) {
                stringBuilder.append(Helpers.getAsHex(this.effekt, 1));
            } else {
                stringBuilder.append((char)(70 + this.effekt - 15));
            }
            stringBuilder.append(Helpers.getAsHex(this.effektOp, 2));
        } else {
            stringBuilder.append("...");
        }
        return stringBuilder.toString();
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int n) {
        this.channel = n;
    }

    public int getEffekt() {
        return this.effekt;
    }

    public void setEffekt(int n) {
        this.effekt = n;
    }

    public int getEffektOp() {
        return this.effektOp;
    }

    public void setEffektOp(int n) {
        this.effektOp = n;
    }

    public int getInstrument() {
        return this.instrument;
    }

    public void setInstrument(int n) {
        this.instrument = n;
    }

    public int getNoteIndex() {
        return this.noteIndex;
    }

    public void setNoteIndex(int n) {
        this.noteIndex = n;
    }

    public int getPatternIndex() {
        return this.patternIndex;
    }

    public void setPatternIndex(int n) {
        this.patternIndex = n;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int n) {
        this.period = n;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int n) {
        this.row = n;
    }

    public int getVolumeEffekt() {
        return this.volumeEffekt;
    }

    public void setVolumeEffekt(int n) {
        this.volumeEffekt = n;
    }

    public int getVolumeEffektOp() {
        return this.volumeEffektOp;
    }

    public void setVolumeEffektOp(int n) {
        this.volumeEffektOp = n;
    }
}

