/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod.loader.instrument;

import de.quippy.javamod.multimedia.mod.loader.Module;
import de.quippy.javamod.multimedia.mod.loader.instrument.Instrument;
import de.quippy.javamod.multimedia.mod.loader.instrument.Sample;

public class InstrumentsContainer {
    private Module parent;
    private Instrument[] instruments;
    private Sample[] samples;

    public InstrumentsContainer(Module module, int n, int n2) {
        this.parent = module;
        this.instruments = n != 0 ? new Instrument[n] : null;
        this.samples = n2 != 0 ? new Sample[n2] : null;
    }

    public void reallocSampleSpace(int n) {
        Sample[] sampleArray = new Sample[n];
        if (this.samples != null) {
            int n2 = 0;
            while (n2 < this.samples.length) {
                sampleArray[n2] = this.samples[n2];
                ++n2;
            }
        }
        this.samples = sampleArray;
    }

    public void setInstrument(int n, Instrument instrument) {
        this.instruments[n] = instrument;
    }

    public void setSample(int n, Sample sample) {
        this.samples[n] = sample;
    }

    public Sample getSample(int n) {
        if (this.samples == null || n >= this.samples.length || n < 0) {
            return null;
        }
        return this.samples[n];
    }

    public int getFullSampleLength() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.samples.length) {
            n += this.samples[n2].length;
            ++n2;
        }
        return n;
    }

    public Instrument getInstrument(int n) {
        if (this.instruments == null) {
            return null;
        }
        if (n >= this.instruments.length) {
            return null;
        }
        return this.instruments[n];
    }

    public Instrument[] getInstruments() {
        return this.instruments;
    }

    public Sample[] getSamples() {
        return this.samples;
    }

    public Module getParentModule() {
        return this.parent;
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.instruments != null) {
            n = 0;
            while (n < this.instruments.length) {
                stringBuilder.append(this.instruments[n].toString());
                stringBuilder.append('\n');
                ++n;
            }
        }
        if (this.samples != null) {
            n = 0;
            while (n < this.samples.length) {
                stringBuilder.append(this.samples[n].toShortString());
                stringBuilder.append('\n');
                ++n;
            }
        }
        return stringBuilder.toString();
    }
}

