/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.mixer.dsp.iir.filter;

import de.quippy.javamod.mixer.dsp.iir.filter.IIRFilterBase;
import de.quippy.javamod.system.Helpers;

public class IIRFilter {
    private int channels;
    private int iIndex;
    private int jIndex;
    private int kIndex;
    private int sampleBufferSize;
    private int filterLength;
    private IIRFilterBase[] filters;
    private float preAmp;

    public IIRFilter(IIRFilterBase[] iIRFilterBaseArray) {
        this.filters = iIRFilterBaseArray;
        this.filterLength = iIRFilterBaseArray.length;
        this.preAmp = 1.0f;
    }

    public void initialize(int n, int n2) {
        this.channels = n;
        this.sampleBufferSize = n2;
        this.clearHistory();
    }

    public void clearHistory() {
        int n = 0;
        while (n < this.filterLength) {
            this.filters[n].clearHistory();
            ++n;
        }
        this.iIndex = 0;
        this.jIndex = 1;
        this.kIndex = 2;
    }

    public float getBand(int n) {
        return this.filters[n].getGain();
    }

    public void setBand(int n, float f) {
        this.filters[n].setGain(f);
    }

    public float getPreAmp() {
        return (float)Helpers.getDBValueFrom(this.preAmp);
    }

    public void setPreAmp(float f) {
        this.preAmp = (float)Helpers.getDecimalValueFrom(f);
    }

    public IIRFilterBase[] getFilters() {
        return this.filters;
    }

    public int doFilter(float[] fArray, int n, int n2, int n3) {
        float f = 1.0f / (float)n3;
        float f2 = 1.0f - f;
        int n4 = n + n2;
        int n5 = n;
        while (n5 < n4) {
            int n6 = 0;
            while (n6 < this.channels) {
                int n7 = n5++ % this.sampleBufferSize;
                float f3 = 0.0f;
                float f4 = fArray[n7] * this.preAmp * f;
                int n8 = 0;
                while (n8 < n3) {
                    IIRFilterBase iIRFilterBase = this.filters[n8];
                    f3 += iIRFilterBase.performFilterCalculation(f4, n6, this.iIndex, this.jIndex, this.kIndex) * iIRFilterBase.amplitudeAdj;
                    ++n8;
                }
                fArray[n7] = f3 + fArray[n7] * f2;
                ++n6;
            }
            this.iIndex = (this.iIndex + 1) % 3;
            this.jIndex = (this.jIndex + 1) % 3;
            this.kIndex = (this.kIndex + 1) % 3;
        }
        return n2;
    }
}

