/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.io;

import de.quippy.javamod.system.Helpers;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileOrPackedInputStream
extends InputStream {
    protected InputStream stream;
    private ZipEntry entry;

    public FileOrPackedInputStream(File file) throws IOException, FileNotFoundException {
        if (!file.exists()) {
            try {
                this.stream = this.tryForZippedFile(file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                throw new FileNotFoundException(file.getCanonicalPath());
            }
        } else {
            this.stream = new FileInputStream(file);
        }
    }

    public FileOrPackedInputStream(String string) throws IOException, FileNotFoundException {
        this(new File(string));
    }

    public FileOrPackedInputStream(URL uRL) throws IOException, FileNotFoundException {
        try {
            this.stream = uRL.openStream();
        }
        catch (AccessControlException accessControlException) {
            throw new AccessControlException("[FileOrPackedInputStream] Access denied: " + uRL.toString());
        }
        catch (Exception exception) {
            this.stream = this.tryForZippedFile(uRL);
        }
    }

    private InputStream tryForZippedFile(URL uRL) throws IOException {
        String string = uRL.toString();
        String string2 = "";
        while (string != null && string.length() != 0) {
            ZipEntry zipEntry;
            int n = string.lastIndexOf(47);
            if (n < 0) break;
            string2 = String.valueOf(Helpers.createStringFromURLString(string.substring(n))) + string2;
            string = string.substring(0, n);
            URL uRL2 = new URL(string);
            ZipInputStream zipInputStream = null;
            try {
                zipInputStream = new ZipInputStream(uRL2.openStream());
            }
            catch (Throwable throwable) {
                continue;
            }
            String string3 = string2.substring(1);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory() || !zipEntry.getName().equals(string3)) continue;
                this.entry = zipEntry;
                return zipInputStream;
            }
        }
        throw new FileNotFoundException(uRL.toString());
    }

    public ZipEntry getEntry() {
        return this.entry;
    }

    @Override
    public int available() throws IOException {
        if (this.entry == null) {
            return this.stream.available();
        }
        return (int)this.entry.getSize();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
        super.close();
    }

    @Override
    public synchronized void mark(int n) {
        this.stream.mark(n);
    }

    @Override
    public boolean markSupported() {
        return this.stream.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.stream.reset();
    }

    @Override
    public long skip(long l) throws IOException {
        return this.stream.skip(l);
    }

    @Override
    public int read() throws IOException {
        return this.stream.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.stream.read(byArray);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.stream.read(byArray, n, n2);
    }
}

