/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui.signal;

import ch.oli4.ui.UiPoint;
import ch.oli4.ui.signal.UiSignalZeiger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class UiSignalZeigerPlastic
extends UiSignalZeiger {
    protected Color offColor = Color.gray;
    private UiPoint zeigerCenter = new UiPoint();
    private int outerRadius;
    private int innerRadius;
    private int centerRadius;

    public UiSignalZeigerPlastic() {
        this.setSkalaAngle(90);
        this.setPreferredSize(new Dimension(100, 50));
    }

    public void setOffColor(Color c) {
        this.offColor = c;
    }

    public Color getOffColor() {
        return this.offColor;
    }

    private void calculateRadius() {
        float radius2;
        float radius1 = (float)this.getWidth() / this.getRelativeSkalaWidth();
        this.outerRadius = radius1 < (radius2 = (float)this.getHeight() / this.getRelativeSkalaHeight()) ? (int)radius1 : (int)radius2;
        this.outerRadius -= 10;
        this.innerRadius = this.outerRadius * 7 / 10;
        this.centerRadius = this.outerRadius / 10;
        if (this.centerRadius < 5) {
            this.centerRadius = 5;
        }
    }

    private void calculateZeigerCenter() {
        this.zeigerCenter.x = this.getWidth() / 2;
        this.zeigerCenter.y = this.outerRadius + 8;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.calculateRadius();
        this.calculateZeigerCenter();
        g.setColor(this.offColor);
        g.fillArc(this.zeigerCenter.x - this.outerRadius, this.zeigerCenter.y - this.outerRadius, this.outerRadius * 2, this.outerRadius * 2, (int)this.angleToMathAngle(this.minAngle), this.minAngle - this.maxAngle);
        g.setColor(this.zeigerColor);
        g.fillArc(this.zeigerCenter.x - this.outerRadius, this.zeigerCenter.y - this.outerRadius, this.outerRadius * 2, this.outerRadius * 2, (int)this.angleToMathAngle(this.minAngle), (int)(-(this.dataToWinkel(this.dataIst) - (float)this.minAngle)));
        if (this.coloredRangeColor != null) {
            int i = 0;
            while (i < this.coloredRangeColor.length) {
                double min = Math.max(this.coloredRangeDataMin[i], this.dataMin);
                double max = Math.min(this.coloredRangeDataMax[i], this.dataIst);
                if (max > min) {
                    g.setColor(this.coloredRangeColor[i]);
                    g.fillArc(this.zeigerCenter.x - this.outerRadius, this.zeigerCenter.y - this.outerRadius, this.outerRadius * 2, this.outerRadius * 2, (int)this.angleToMathAngle(this.dataToWinkel(min)), (int)(this.dataToWinkel(min) - this.dataToWinkel(max)));
                }
                ++i;
            }
        }
        if (this.skalaVisible) {
            g.setColor(this.skalaColor);
            g.drawLine(this.zeigerCenter.x, this.zeigerCenter.y, this.zeigerCenter.x + this.toX(this.minAngle, this.outerRadius), this.zeigerCenter.y + this.toY(this.minAngle, this.outerRadius));
            g.drawLine(this.zeigerCenter.x, this.zeigerCenter.y, this.zeigerCenter.x + this.toX(this.maxAngle, this.outerRadius), this.zeigerCenter.y + this.toY(this.maxAngle, this.outerRadius));
        }
        g.setColor(this.getBackground());
        g.fillOval(this.zeigerCenter.x - this.innerRadius, this.zeigerCenter.y - this.innerRadius, this.innerRadius * 2, this.innerRadius * 2);
        if (this.skalaVisible) {
            g.setColor(this.skalaColor);
            g.drawArc(this.zeigerCenter.x - this.outerRadius, this.zeigerCenter.y - this.outerRadius, this.outerRadius * 2, this.outerRadius * 2, (int)this.angleToMathAngle(this.minAngle), -(this.maxAngle - this.minAngle));
            g.drawArc(this.zeigerCenter.x - this.innerRadius, this.zeigerCenter.y - this.innerRadius, this.innerRadius * 2, this.innerRadius * 2, (int)this.angleToMathAngle(this.minAngle), -(this.maxAngle - this.minAngle));
        }
        if (this.nameVisible) {
            g.setColor(this.getForeground());
            g.drawString(this.dataName, this.zeigerCenter.x - this.getFontMetrics(this.getFont()).stringWidth(this.dataName) / 2, this.zeigerCenter.y * 2 / 3);
        }
        if (this.zeigerVisible) {
            g.setColor(this.zeigerColor);
            g.drawLine(this.zeigerCenter.x, this.zeigerCenter.y, this.zeigerCenter.x + this.toX(this.dataToWinkel(this.dataIst), this.outerRadius), this.zeigerCenter.y + this.toY(this.dataToWinkel(this.dataIst), this.outerRadius));
            g.setColor(this.zeigerColor);
            g.fillOval(this.zeigerCenter.x - this.centerRadius, this.zeigerCenter.y - this.centerRadius, 2 * this.centerRadius, 2 * this.centerRadius);
        }
    }

    public static void main(String[] arg) {
        JFrame f = new JFrame();
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        UiSignalZeigerPlastic z = new UiSignalZeigerPlastic();
        z.setDataRange(-1.5, 1.5);
        z.setData(1.27);
        z.setDataName("Leitung");
        z.setSkalaColor(Color.lightGray);
        z.setZeigerColor(Color.blue);
        Color[] colors = new Color[]{Color.red, Color.green, Color.red};
        double[] colorMins = new double[]{-1.5, -1.0, 1.0};
        double[] colorMaxs = new double[]{-1.0, 1.0, 1.5};
        z.setColoredRanges(colors, colorMins, colorMaxs);
        p.add((Component)z, "Center");
        f.getContentPane().add(p);
        f.setSize(new Dimension(100, 100));
        f.setVisible(true);
    }
}

