/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui.signal;

import ch.oli4.ui.signal.UiSignalDouble;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class UiSignalLedBalken
extends UiSignalDouble {
    private int numberOfLeds = 10;
    public static final int VERTICAL = 1;
    public static final int HORIZONTAL = 2;
    private int orientation = 2;
    private Color onColor = Color.green;
    private Color offColor = this.getBackground().darker();
    private int peakLedIndex;
    private boolean peakDetectionEnable = false;
    private int border;
    private int ledWidth;
    private int ledHeight;
    private int ledAbstand;
    private Color actualLedColor;

    public UiSignalLedBalken() {
        this.setPreferredSize(new Dimension(100, 20));
    }

    public void setNumberOfLeds(int n) {
        this.numberOfLeds = n;
        this.repaint();
    }

    public void setOrientation(int o) {
        this.orientation = o;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOnColor(Color c) {
        this.onColor = c;
        this.repaint();
    }

    public void setOffColor(Color c) {
        this.offColor = c;
        this.repaint();
    }

    public void clearPeakDetection() {
        this.peakLedIndex = -1;
    }

    public void setPeakDetectionEnabled(boolean b) {
        this.peakDetectionEnable = b;
    }

    public void repaint() {
        this.repaint(0L, 0, 0, this.getWidth(), this.getHeight());
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.border = 4;
        this.ledAbstand = 3;
        if (this.orientation == 2) {
            this.ledHeight = this.getHeight() - 2 * this.border;
            this.ledWidth = (this.getWidth() - 2 * this.border + this.ledAbstand) / this.numberOfLeds - this.ledAbstand;
        } else {
            this.ledHeight = (this.getHeight() - 2 * this.border + this.ledAbstand) / this.numberOfLeds - this.ledAbstand;
            this.ledWidth = this.getWidth() - 2 * this.border;
        }
        int i = 0;
        while (i < this.numberOfLeds) {
            double ledData = (this.dataMax - this.dataMin) / (double)this.numberOfLeds * (double)i + this.dataMin;
            double ledAboveData = (this.dataMax - this.dataMin) / (double)this.numberOfLeds * (double)(i + 1) + this.dataMin;
            if (ledData < this.dataIst || this.peakDetectionEnable && i == this.peakLedIndex) {
                this.actualLedColor = this.getColorAt(ledData);
                if (this.actualLedColor == null) {
                    this.actualLedColor = this.onColor;
                }
                if (i > this.peakLedIndex) {
                    this.peakLedIndex = i;
                }
            } else {
                this.actualLedColor = this.offColor;
            }
            if (this.orientation == 2) {
                g.setColor(this.actualLedColor);
                g.fillRect(this.border + i * (this.ledWidth + this.ledAbstand), this.border, this.ledWidth, this.ledHeight);
                g.setColor(Color.black);
                g.drawRect(this.border + i * (this.ledWidth + this.ledAbstand), this.border, this.ledWidth, this.ledHeight);
            } else {
                g.setColor(this.actualLedColor);
                g.fillRect(this.border, this.border + (this.numberOfLeds - 1 - i) * (this.ledHeight + this.ledAbstand), this.ledWidth, this.ledHeight);
                g.setColor(Color.black);
                g.drawRect(this.border, this.border + (this.numberOfLeds - 1 - i) * (this.ledHeight + this.ledAbstand), this.ledWidth, this.ledHeight);
            }
            ++i;
        }
    }

    public static void main(String[] arg) {
        new Test();
    }

    private static class Test
    implements ActionListener {
        private UiSignalLedBalken led;
        private JTextField data;
        private JTextField transitionTime;
        private JTextField numberOfLeds;
        private JTextField onColor;
        private JTextField offColor;

        public Test() {
            JFrame f = new JFrame();
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout());
            this.led = new UiSignalLedBalken();
            this.led.setOffColor(Color.red);
            this.led.setData(0.0);
            p.add((Component)this.led, "Center");
            JPanel sp = new JPanel();
            p.add((Component)sp, "South");
            sp.add(new JLabel("data"));
            this.data = new JTextField(5);
            sp.add(this.data);
            this.data.addActionListener(this);
            sp.add(new JLabel("transition-time"));
            this.transitionTime = new JTextField(5);
            sp.add(this.transitionTime);
            this.transitionTime.addActionListener(this);
            sp.add(new JLabel("on-color"));
            this.onColor = new JTextField(5);
            sp.add(this.onColor);
            this.onColor.addActionListener(this);
            sp.add(new JLabel("off-color"));
            this.offColor = new JTextField(5);
            sp.add(this.offColor);
            this.offColor.addActionListener(this);
            sp.add(new JLabel("number-of-leds"));
            this.numberOfLeds = new JTextField(5);
            sp.add(this.numberOfLeds);
            this.numberOfLeds.addActionListener(this);
            f.getContentPane().add(p);
            f.setSize(new Dimension(100, 100));
            f.setVisible(true);
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.data) {
                this.led.setData(Integer.parseInt(this.data.getText()));
            } else if (e.getSource() == this.numberOfLeds) {
                this.led.setNumberOfLeds(Integer.parseInt(this.numberOfLeds.getText()));
            } else if (e.getSource() == this.transitionTime) {
                this.led.setTransitionTime(Integer.parseInt(this.transitionTime.getText()));
            } else if (e.getSource() == this.onColor) {
                this.led.setOnColor(new Color(Integer.valueOf(this.onColor.getText(), 16)));
            } else if (e.getSource() == this.offColor) {
                this.led.setOffColor(new Color(Integer.valueOf(this.offColor.getText(), 16)));
            }
        }
    }
}

