/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui.control;

import ch.oli4.ui.control.UiControlEvent;
import ch.oli4.ui.control.UiControlListener;
import java.awt.Color;
import java.util.WeakHashMap;
import javax.swing.JPanel;

public abstract class UiControl
extends JPanel {
    protected double dataMin = 0.0;
    protected double dataMax = 100.0;
    protected double dataIst = 0.0;
    protected boolean enable = true;
    protected WeakHashMap<UiControlListener, Object> listeners = new WeakHashMap();

    private double limitToRange(double d) {
        if (d > this.dataMax) {
            return this.dataMax;
        }
        if (d < this.dataMin) {
            return this.dataMin;
        }
        return d;
    }

    private boolean changeDetectedOnDataSet(double d) {
        if (d != this.dataIst) {
            this.dataIst = d;
            return true;
        }
        return false;
    }

    protected void doDataChanging(double d) {
        if (this.changeDetectedOnDataSet(this.limitToRange(d))) {
            this.repaint();
            this.fireDataChangingEvent(this);
        }
    }

    protected void doDataChanged(double d) {
        if (this.changeDetectedOnDataSet(this.limitToRange(d))) {
            this.repaint();
        }
        this.fireDataChangedEvent(this);
    }

    public void setData(double d) {
        if (this.changeDetectedOnDataSet(this.limitToRange(d))) {
            this.repaint();
        }
    }

    public double getData() {
        return this.dataIst;
    }

    public void setDataRange(double dMin, double dMax) {
        this.dataMin = dMin;
        this.dataMax = dMax;
        this.repaint();
    }

    public double getDataMax() {
        return this.dataMax;
    }

    public double getDataMin() {
        return this.dataMin;
    }

    public void setEnabled(boolean b) {
        this.enable = b;
        this.repaint();
    }

    public boolean isEnabled() {
        return this.enable;
    }

    public void setBackground(Color c) {
        super.setBackground(c);
    }

    public void setForeground(Color c) {
        super.setForeground(c);
    }

    public void addControlListener(UiControlListener l) {
        this.listeners.put(l, null);
    }

    public void removeControlListener(UiControlListener l) {
        this.listeners.remove(l);
    }

    protected void fireDataChangingEvent(UiControl c) {
        UiControlEvent ce = new UiControlEvent(c);
        for (UiControlListener l : this.listeners.keySet()) {
            l.onDataChanging(ce);
        }
    }

    protected void fireDataChangedEvent(UiControl c) {
        UiControlEvent ce = new UiControlEvent(c);
        for (UiControlListener l : this.listeners.keySet()) {
            l.onDataChanged(ce);
        }
    }

    protected void fireValidateEvent(UiControl c) {
        UiControlEvent ce = new UiControlEvent(c);
        for (UiControlListener l : this.listeners.keySet()) {
            l.onValidate(ce);
        }
    }
}

