/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class UiCartesianLayout
implements LayoutManager2 {
    private JComponent parent;
    private int xCells;
    private int yCells;
    private float borderGapFactor;
    private float cellGapFactor;
    private ArrayList location;

    public UiCartesianLayout(JComponent parent, int xCells, int yCells) {
        this.parent = parent;
        this.xCells = xCells;
        this.yCells = yCells;
        this.borderGapFactor = 0.0f;
        this.cellGapFactor = 0.1f;
        this.location = new ArrayList();
    }

    public void setPreferredCellSize(Dimension s) {
        Insets b = this.parent.getInsets();
        this.parent.setPreferredSize(new Dimension(s.width * this.xCells + b.left + b.right, s.height * this.yCells + b.top + b.bottom));
    }

    public void setBorderGap(float g) {
        this.borderGapFactor = g;
    }

    public void setCellGap(float g) {
        this.cellGapFactor = g;
    }

    public void add(Component c, int x, int y, int w, int h) {
        this.parent.add(c);
        this.location.add(new Rectangle(x, y, w, h));
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public void layoutContainer(Container parent) {
        Insets border = parent.getInsets();
        float parentWidth = parent.getWidth() - border.left - border.right;
        float parentHeight = parent.getHeight() - border.top - border.bottom;
        float xParent = border.left;
        float yParent = border.top;
        float xCellSize = parentWidth / ((float)this.xCells + 2.0f * this.borderGapFactor);
        float yCellSize = parentHeight / ((float)this.yCells + 2.0f * this.borderGapFactor);
        float xCellGap = xCellSize * this.cellGapFactor;
        float yCellGap = yCellSize * this.cellGapFactor;
        float xBorderGap = xCellSize * this.borderGapFactor;
        float yBorderGap = yCellSize * this.borderGapFactor;
        int i = 0;
        while (i < parent.getComponentCount()) {
            Rectangle r = (Rectangle)this.location.get(i);
            parent.getComponent(i).setBounds((int)((float)r.x * xCellSize + xCellGap + xBorderGap + xParent), (int)((float)r.y * yCellSize + yCellGap + yBorderGap + yParent), (int)((float)r.width * xCellSize - 2.0f * xCellGap), (int)((float)r.height * yCellSize - 2.0f * yCellGap));
            ++i;
        }
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints != null) {
            this.location.add(constraints);
        }
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    public void invalidateLayout(Container target) {
    }

    public Dimension maximumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public Dimension preferredLayoutSize(Container parent) {
        float w = 0.0f;
        int i = 0;
        while (i < parent.getComponentCount()) {
            float biggerW = parent.getComponent((int)i).getPreferredSize().width / ((Rectangle)this.location.get((int)i)).width;
            if (biggerW > w) {
                w = biggerW;
            }
            ++i;
        }
        float h = 0.0f;
        int i2 = 0;
        while (i2 < parent.getComponentCount()) {
            float biggerH = parent.getComponent((int)i2).getPreferredSize().height / ((Rectangle)this.location.get((int)i2)).height;
            if (biggerH > h) {
                h = biggerH;
            }
            ++i2;
        }
        return new Dimension((int)((float)this.xCells * w), (int)((float)this.yCells * h));
    }

    public static void main(String[] arg) {
        JFrame f = new JFrame();
        JPanel p = new JPanel();
        f.getContentPane().add(p);
        UiCartesianLayout l = new UiCartesianLayout(p, 10, 10);
        l.setPreferredCellSize(new Dimension(45, 45));
        p.setLayout(l);
        p.add((Component)new JButton("hallo"), new Rectangle(0, 0, 5, 2));
        p.add((Component)new JButton("was?"), new Rectangle(0, 2, 2, 1));
        p.add((Component)new JButton("wie?"), new Rectangle(8, 2, 2, 1));
        l.add(new JButton("c"), 9, 9, 1, 1);
        f.pack();
        f.setVisible(true);
    }
}

