/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.mmedia;

import ch.oli4.mmedia.MPanel;
import ch.oli4.mmedia.MTimer;
import ch.oli4.trace.Trace;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;

public class MMouse
implements MouseListener,
MouseMotionListener {
    private static MMouse mouse;
    private MPanel panel;
    private MouseEvent fastEvent;
    private MouseEvent scanEvent;
    private boolean fastPressed;
    private boolean scanPressed;
    private boolean oldScanPressed;
    private int x;
    private int oldX;
    private int y;
    private int oldY;
    private int currentCursorIndex;
    public static final int FORWARD_CURSOR = 8;
    public static final int BACKWARD_CURSOR = 9;
    public static final int LEFT_CURSOR = 10;
    public static final int RIGHT_CURSOR = 11;
    public static final int NOTHING_CURSOR = 1;
    public static final int TOUCH_CURSOR = 12;
    public static final int DOWN_CURSOR = 9;
    private Map<Integer, Cursor> cursors = new HashMap<Integer, Cursor>();
    private int x1;
    private int y1;
    private int x2;
    private int y2;

    public MMouse() {
        this.cursors.put(8, new Cursor(8));
        this.cursors.put(9, new Cursor(9));
        this.cursors.put(11, new Cursor(11));
        this.cursors.put(10, new Cursor(10));
        this.cursors.put(9, new Cursor(9));
        this.cursors.put(12, new Cursor(12));
        this.cursors.put(1, new Cursor(1));
    }

    public static MMouse getInstance() {
        if (mouse == null) {
            mouse = new MMouse();
        }
        return mouse;
    }

    public void setPanel(MPanel p) {
        this.panel = p;
        this.panel.addMouseListener(this);
        this.panel.addMouseMotionListener(this);
    }

    private int scale(int v) {
        return (int)((double)v / this.panel.getScaleFactor());
    }

    public void scan() {
        if (this.fastEvent != null) {
            this.oldScanPressed = this.scanPressed;
            this.scanPressed = this.fastPressed;
            this.scanEvent = this.fastEvent;
            this.oldX = this.x;
            this.x = this.scale(this.scanEvent.getX());
            this.oldY = this.y;
            this.y = this.scale(this.scanEvent.getY());
            Trace.getInstance().addEntry(9, "mouse x=" + this.x + " y=" + this.y + " b=" + this.scanPressed);
        }
    }

    public boolean justPressed() {
        return this.scanPressed && !this.oldScanPressed;
    }

    public boolean justReleased() {
        return !this.scanPressed && this.oldScanPressed;
    }

    public boolean dragDown() {
        return this.scanPressed && this.y > this.oldY + 2;
    }

    public boolean dragUp() {
        return this.scanPressed && this.y < this.oldY - 2;
    }

    public boolean dragLeft() {
        return this.scanPressed && this.x < this.oldX - 2;
    }

    public boolean dragRight() {
        return this.scanPressed && this.x > this.oldX + 2;
    }

    public boolean isInside(int x1, int y1, int x2, int y2) {
        return this.x >= x1 && this.x <= x2 && this.y >= y1 && this.y <= y2;
    }

    public boolean isRightOf(int x1) {
        return this.x >= x1;
    }

    public boolean isLeftOf(int x1) {
        return this.x <= x1;
    }

    public boolean waitMouseClickOrTimeout(int timeout) {
        MTimer t = new MTimer();
        t.start(timeout);
        while (true) {
            t.run();
            if (t.isTriggered()) {
                return false;
            }
            if (this.fastPressed) {
                return true;
            }
            MTimer.sleep(50);
        }
    }

    public void waitMouseClick() {
        while (!this.fastPressed) {
            MTimer.sleep(50);
        }
    }

    public void waitMouseReleased() {
        while (this.fastPressed) {
            MTimer.sleep(50);
        }
    }

    public void setCursor(int cursorIndex) {
        if (cursorIndex != this.currentCursorIndex) {
            this.currentCursorIndex = cursorIndex;
            if (this.panel != null) {
                this.panel.setCursor(this.cursors.get(cursorIndex));
            }
        }
    }

    public void loadCustomCursor(int index, String file, double activeX, double activeY) {
        this.loadCustomCursor(index, file, new ImageIcon(file), activeX, activeY);
    }

    public void loadCustomCursor(int index, String name, ImageIcon icon, double activeX, double activeY) {
        Dimension cursorSize = Toolkit.getDefaultToolkit().getBestCursorSize(icon.getIconWidth(), icon.getIconHeight());
        Point hotSpot = new Point(Math.min((int)((double)cursorSize.width * activeX), cursorSize.width - 1), Math.min((int)((double)cursorSize.height * activeY), cursorSize.height - 1));
        this.cursors.put(index, Toolkit.getDefaultToolkit().createCustomCursor(icon.getImage().getScaledInstance(cursorSize.width, cursorSize.height, 4), hotSpot, name));
        Trace.getInstance().addEntry(1, "load cursor " + name + ", best size = " + cursorSize.width + "/" + cursorSize.height);
    }

    public void mouseClicked(MouseEvent e) {
        this.fastEvent = e;
    }

    public void mouseEntered(MouseEvent e) {
        this.fastEvent = e;
    }

    public void mouseExited(MouseEvent e) {
        this.fastEvent = e;
    }

    public void mousePressed(MouseEvent e) {
        this.fastEvent = e;
        this.fastPressed = true;
        this.x1 = this.scale(e.getX());
        this.y1 = this.scale(e.getY());
    }

    public void mouseReleased(MouseEvent e) {
        this.fastEvent = e;
        this.fastPressed = false;
        this.x2 = this.scale(e.getX());
        this.y2 = this.scale(e.getY());
        Trace.getInstance().addEntry(3, "dragged rectangle = " + this.x1 + ", " + this.y1 + ", " + this.x2 + ", " + this.y2);
    }

    public void mouseMoved(MouseEvent e) {
        this.fastEvent = e;
    }

    public void mouseDragged(MouseEvent e) {
        this.fastEvent = e;
        this.x2 = this.scale(e.getX());
        this.y2 = this.scale(e.getY());
    }
}

