/*
 * Decompiled with CFR 0.152.
 */
package ch.oli4.console;

import ch.oli4.console.CCommandImpl;
import ch.oli4.console.CConsole;
import ch.oli4.io.CommandLineParser;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class CCommandScript
extends CCommandImpl {
    public CCommandScript(String name) {
        super(name, "filename", "processes script-file");
    }

    public CCommandScript() {
        this("<");
    }

    private static boolean isTrue(String expr) {
        if (expr.equals("0")) {
            return false;
        }
        if (expr.toLowerCase().equals("false")) {
            return false;
        }
        try {
            int i = Integer.parseInt(expr);
            if (i == 0) {
                return false;
            }
        }
        catch (Exception i) {
            // empty catch block
        }
        try {
            double d = Double.parseDouble(expr);
            if (d == 0.0) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onConsoleCommand(CConsole console, String commandLine) {
        block61: {
            t = new StringTokenizer(commandLine);
            if (t.countTokens() != 2) break block61;
            cmd = t.nextToken();
            fileName = t.nextToken();
            if (!cmd.equals(this.name)) break block61;
            try {
                lir = new LineNumberReader(new FileReader(fileName));
                lineNumber = 0;
                currentBlock = mainBlock = new Block("main");
lbl10:
                // 2 sources

                while (true) {
                    block63: {
                        block64: {
                            block62: {
                                if ((l = lir.readLine()) != null) break block62;
                                if (currentBlock != mainBlock) {
                                    console.printError("there are missing .end instructions");
                                    return true;
                                }
                                break block63;
                            }
                            origL = new String(l);
                            ++lineNumber;
                            l.trim();
                            c = l.indexOf(35);
                            if (c >= 0) {
                                l = l.substring(0, c).trim();
                            }
                            if (l.length() == 0 || (p = new CommandLineParser(l)).getNumberOfArguments() == 0) continue;
                            if (p.getNumberOfArguments() < 2 || !p.getArgument(0).trim().equals(".begin")) break block64;
                            b = new Block(p.getArgument(1));
                            i = 2;
                            if (true) ** GOTO lbl249
                        }
                        if (p.getNumberOfArguments() == 1 && p.getArgument(0).trim().equals(".end")) {
                            if (currentBlock.parent == null) {
                                console.printError(String.valueOf(new Line(origL, l, lineNumber).toString()) + " .end without corresponding .begin");
                                return true;
                            }
                            currentBlock = currentBlock.parent;
                            continue;
                        }
                        line = new Line(origL, l, lineNumber);
                        currentBlock.add(line);
                        continue;
                    }
                    stack = new ArrayList<Block>();
                    debugPrintLine = false;
                    debugStepping = false;
                    startTime = System.currentTimeMillis();
                    if (mainBlock == null || mainBlock.lines.size() == 0) {
                        console.printError("no main instruction found");
                        return true;
                    }
                    stack.add(mainBlock);
                    mainBlock.start();
lbl50:
                    // 4 sources

                    block7: while (true) {
                        block67: {
                            block66: {
                                block65: {
                                    block60: {
                                        currentLine = currentBlock.getLine();
                                        mainBlock.setVar(".time", Integer.toString((int)(System.currentTimeMillis() - startTime)));
                                        if (currentLine == null) {
                                            if (currentBlock.mode.equals(".for")) {
                                                i = (int)Double.parseDouble(currentBlock.getParameterVar(0));
                                                end = (int)Double.parseDouble(currentBlock.getParameterVar(1));
                                                iter = (int)Double.parseDouble(currentBlock.getParameterVar(2));
                                                if (iter > 0 && (i += iter) <= end || iter < 0 && i >= end) {
                                                    currentBlock.setParameterVar(0, new Integer(i).toString());
                                                    currentBlock.start();
                                                    currentLine = currentBlock.getLine();
                                                    break block60;
                                                } else {
                                                    if (stack.size() <= 0) {
                                                        return true;
                                                    }
                                                    currentBlock.clearVars();
                                                    currentBlock = (Block)stack.remove(stack.size() - 1);
                                                    continue;
                                                }
                                            }
                                            if (currentBlock.mode.equals(".while")) {
                                                cond = currentBlock.getParameterVar(0);
                                                if (CCommandScript.isTrue(cond)) {
                                                    currentBlock.start();
                                                    currentLine = currentBlock.getLine();
                                                    break block60;
                                                } else {
                                                    if (stack.size() <= 0) {
                                                        return true;
                                                    }
                                                    currentBlock.clearVars();
                                                    currentBlock = (Block)stack.remove(stack.size() - 1);
                                                    continue;
                                                }
                                            }
                                            if (!currentBlock.mode.equals(".call")) {
                                                console.printError("internal block-mode error");
                                                return true;
                                            }
                                            if (stack.size() <= 0) {
                                                return true;
                                            }
                                            currentBlock.clearVars();
                                            currentBlock = (Block)stack.remove(stack.size() - 1);
                                            continue;
                                        }
                                    }
                                    if (debugPrintLine) {
                                        System.out.print("debug mode: ");
                                        System.out.println(currentLine.text);
                                    }
                                    if (debugStepping) {
                                        System.out.print("debug mode: type enter to step, c enter to continue...");
                                        dc = console.readInputCommand();
                                        if (dc.trim().toLowerCase().equals("c")) {
                                            debugStepping = false;
                                        }
                                    }
                                    if ((p = currentLine.parsed).getNumberOfArguments() <= 0) continue;
                                    if (!p.getArgument(0).trim().equals(".call") && !p.getArgument(0).trim().equals(".while") && !p.getArgument(0).trim().equals(".for")) break block65;
                                    bn = p.getArgument(1).trim();
                                    cb = currentBlock.getBlock(bn);
                                    if (cb == null) {
                                        console.printError(String.valueOf(currentLine.toString()) + " no such visible block found");
                                        return true;
                                    }
                                    if (cb.getNumberOfParameters() != p.getNumberOfArguments() - 2) {
                                        console.printError(String.valueOf(currentLine.toString()) + " number of parameters does not match with declaration");
                                        return true;
                                    }
                                    i = 0;
                                    if (true) ** GOTO lbl256
                                }
                                if (p.getArgument(0).trim().equals(".if")) {
                                    bn = "";
                                    if (CCommandScript.isTrue(currentBlock.getVar(p.getArgument(1)))) {
                                        bn = p.getArgument(2).trim();
                                    } else if (p.getNumberOfArguments() >= 4) {
                                        bn = p.getArgument(3).trim();
                                    }
                                    cb = currentBlock.getBlock(bn);
                                    if (bn.equals("")) continue;
                                    if (cb == null) {
                                        console.printError(String.valueOf(currentLine.toString()) + " no such visible block found");
                                        return true;
                                    }
                                    stack.add(currentBlock);
                                    currentBlock = cb;
                                    currentBlock.mode = ".call";
                                    currentBlock.start();
                                    continue;
                                }
                                if (p.getArgument(0).trim().equals(".debug")) {
                                    if (p.containsFlag("p")) {
                                        console.println(mainBlock.toString());
                                    }
                                    debugPrintLine = p.containsFlag("l");
                                    debugStepping = p.containsFlag("s");
                                    continue;
                                }
                                if (p.getArgument(0).trim().equals(".inc")) {
                                    n = p.getArgument(1).trim();
                                    v = (int)Double.parseDouble(currentBlock.getVar(n));
                                    currentBlock.setVar(n, "" + (v + 1));
                                    continue;
                                }
                                if (p.getArgument(0).trim().equals(".dec")) {
                                    n = p.getArgument(1).trim();
                                    v = (int)Double.parseDouble(currentBlock.getVar(n));
                                    currentBlock.setVar(n, "" + (v - 1));
                                    continue;
                                }
                                if (p.getArgument(0).trim().equals(".add")) {
                                    n = p.getArgument(1).trim();
                                    v1 = Double.parseDouble(currentBlock.getVar(p.getArgument(2).trim()));
                                    v2 = Double.parseDouble(currentBlock.getVar(p.getArgument(3).trim()));
                                    currentBlock.setVar(n, "" + (v1 + v2));
                                    continue;
                                }
                                if (p.getArgument(0).trim().equals(".sub")) {
                                    n = p.getArgument(1).trim();
                                    v1 = Double.parseDouble(currentBlock.getVar(p.getArgument(2).trim()));
                                    v2 = Double.parseDouble(currentBlock.getVar(p.getArgument(3).trim()));
                                    currentBlock.setVar(n, "" + (v1 - v2));
                                    continue;
                                }
                                if (p.getArgument(0).trim().equals(".mul")) {
                                    n = p.getArgument(1).trim();
                                    v1 = Double.parseDouble(currentBlock.getVar(p.getArgument(2).trim()));
                                    v2 = Double.parseDouble(currentBlock.getVar(p.getArgument(3).trim()));
                                    currentBlock.setVar(n, "" + v1 * v2);
                                    continue;
                                }
                                if (p.getArgument(0).trim().equals(".div")) {
                                    n = p.getArgument(1).trim();
                                    v1 = Double.parseDouble(currentBlock.getVar(p.getArgument(2).trim()));
                                    v2 = Double.parseDouble(currentBlock.getVar(p.getArgument(3).trim()));
                                    currentBlock.setVar(n, "" + v1 / v2);
                                    continue;
                                }
                                if (p.getArgument(0).trim().equals(".eq")) {
                                    n = p.getArgument(1).trim();
                                    try {
                                        v1 = Double.parseDouble(currentBlock.getVar(p.getArgument(2).trim()));
                                        v2 = Double.parseDouble(currentBlock.getVar(p.getArgument(3).trim()));
                                        currentBlock.setVar(n, v1 == v2 ? "true" : "false");
                                    }
                                    catch (Exception e) {
                                        v1 = currentBlock.getVar(p.getArgument(2).trim());
                                        v2 = currentBlock.getVar(p.getArgument(3).trim());
                                        currentBlock.setVar(n, v1.equals(v2) != false ? "true" : "false");
                                    }
                                    continue;
                                }
                                if (p.getArgument(0).trim().equals(".not")) {
                                    currentBlock.setVar(n, CCommandScript.isTrue(currentBlock.getVar(n = p.getArgument(1).trim())) != false ? "false" : "true");
                                    continue;
                                }
                                if (p.getArgument(0).trim().equals(".gt")) {
                                    n = p.getArgument(1).trim();
                                    v1 = Double.parseDouble(currentBlock.getVar(p.getArgument(2).trim()));
                                    currentBlock.setVar(n, v1 > (v2 = Double.parseDouble(currentBlock.getVar(p.getArgument(3).trim()))) ? "true" : "false");
                                    continue;
                                }
                                if (p.getArgument(0).trim().equals(".lt")) {
                                    n = p.getArgument(1).trim();
                                    v1 = Double.parseDouble(currentBlock.getVar(p.getArgument(2).trim()));
                                    currentBlock.setVar(n, v1 < (v2 = Double.parseDouble(currentBlock.getVar(p.getArgument(3).trim()))) ? "true" : "false");
                                    continue;
                                }
                                if (p.getArgument(0).trim().equals(".gteq")) {
                                    n = p.getArgument(1).trim();
                                    v1 = Double.parseDouble(currentBlock.getVar(p.getArgument(2).trim()));
                                    currentBlock.setVar(n, v1 >= (v2 = Double.parseDouble(currentBlock.getVar(p.getArgument(3).trim()))) ? "true" : "false");
                                    continue;
                                }
                                if (p.getArgument(0).trim().equals(".lteq")) {
                                    n = p.getArgument(1).trim();
                                    v1 = Double.parseDouble(currentBlock.getVar(p.getArgument(2).trim()));
                                    currentBlock.setVar(n, v1 <= (v2 = Double.parseDouble(currentBlock.getVar(p.getArgument(3).trim()))) ? "true" : "false");
                                    continue;
                                }
                                if (p.getArgument(0).trim().equals(".set")) {
                                    currentBlock.setVar(p.getArgument(1).trim(), currentBlock.getVar(p.getArgument(2).trim()));
                                    continue;
                                }
                                if (p.getArgument(0).trim().equals(".input")) {
                                    currentBlock.setVar(p.getArgument(1).trim(), console.readInputCommand().trim());
                                    continue;
                                }
                                if (p.getArgument(0).trim().equals(".sleep")) {
                                    try {
                                        Thread.sleep((int)Double.parseDouble(currentBlock.getVar(p.getArgument(1))));
                                    }
                                    catch (Exception n) {}
                                    continue;
                                }
                                if (!p.getArgument(0).trim().equals(".println")) break block66;
                                i = 1;
                                if (true) ** GOTO lbl266
                            }
                            if (!p.getArgument(0).trim().equals(".print")) break block67;
                            i = 1;
                            if (true) ** GOTO lbl272
                        }
                        if (p.getArgument(0).trim().equals(".exit")) {
                            return true;
                        }
                        if (currentLine.text.equals(commandLine)) {
                            console.printError(String.valueOf(currentLine.toString()) + " recursion-problem");
                            return true;
                        }
                        sb = new StringBuffer();
                        i = 0;
                        while (true) {
                            if (i >= p.getNumberOfArguments()) {
                                if (!console.fireOnConsoleCommand(sb.toString())) {
                                    console.printError(String.valueOf(currentLine.toString()) + " command not found");
                                    return true;
                                }
                                currentBlock.setVar(".return", console.getReturnString());
                                continue block7;
                            }
                            sb.append(currentBlock.getVar(p.getArgument(i)));
                            sb.append(" ");
                            ++i;
                        }
                        break;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
        do {
            b.addParameter(p.getArgument(i));
            ++i;
lbl249:
            // 2 sources

        } while (i < p.getNumberOfArguments());
        currentBlock.add(b);
        currentBlock = b;
        ** while (true)
        do {
            cb.setParameterVar(i, currentBlock.getVar(p.getArgument(i + 2).trim()));
            ++i;
lbl256:
            // 2 sources

        } while (i < cb.getNumberOfParameters());
        stack.add(currentBlock);
        currentBlock = cb;
        currentBlock.mode = p.getArgument(0).trim();
        currentBlock.start();
        ** GOTO lbl50
        do {
            console.print(String.valueOf(currentBlock.getVar(p.getArgument(i))) + " ");
            ++i;
lbl266:
            // 2 sources

        } while (i < p.getNumberOfArguments());
        console.println();
        ** GOTO lbl50
        do {
            console.print(String.valueOf(currentBlock.getVar(p.getArgument(i))) + " ");
            ++i;
lbl272:
            // 2 sources

        } while (i < p.getNumberOfArguments());
        ** while (true)
    }

    public void onConsoleStart() {
    }

    public void onConsoleStop() {
    }

    public String getManPage() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        sb.append("desctription\n");
        sb.append("------------\n");
        sb.append("\n");
        sb.append("console script interpreter. loads a script file an process it. the\n");
        sb.append("script contains commands, on per line. the syntax of the commands\n");
        sb.append("is the same as if they were typed into the console by hand. the script\n");
        sb.append("is processed line by line. \n");
        sb.append("\n");
        sb.append("command-one\n");
        sb.append("command-two\n");
        sb.append("...\n");
        sb.append("\n");
        sb.append("line-comment are supported, they start with #. they may begin at the\n");
        sb.append("line beginning or anywhere at the right side of a valid command. empty\n");
        sb.append("lines are ignored.\n");
        sb.append("\n");
        sb.append("...\n");
        sb.append("#this comment uses the whole line\n");
        sb.append("\n");
        sb.append("command-sixteen #this line contains a interpreted command and this comment\n");
        sb.append("...\n");
        sb.append("\n");
        sb.append("since this console script-interpreter is also a console-command like the\n");
        sb.append("others, , it is allowed to start a sub-script from any script. so a script-\n");
        sb.append("hierarchy is possible. but they do not share any variable or subroutine.\n");
        sb.append("the called script does not know his caller.\n");
        sb.append("\n");
        sb.append("...\n");
        sb.append("command-seventeen\n");
        sb.append("< script-file-five\n");
        sb.append("command-eightteen\n");
        sb.append("...\n");
        sb.append("\n");
        sb.append("the main reason to provide this script-interpreter is to perform a sequence of\n");
        sb.append("user-commands automatically without typing the commands by hand again and again.\n");
        sb.append("but this script-interpreter has many more features. it contains plenty of\n");
        sb.append("additional internal commands, for things like calling nested subroutines, iterations,\n");
        sb.append("loop and branches, input and output text from/to the console, using variables\n");
        sb.append("respecting restricted access/visiblity, basic number operations, basic compare\n");
        sb.append("operations, using output of user-commands to be processed, using variables for\n");
        sb.append("user-command inputs... and so on. a real script language is provided here.\n");
        sb.append("all internal commands begin with a dot, to avoid conflicts with user-command\n");
        sb.append("names.\n");
        sb.append("\n");
        sb.append("...\n");
        sb.append("command-twenty-one \t#this is a user-command\n");
        sb.append(".set w 4 \t\t\t\t#this is an internal command\n");
        sb.append("...\n");
        sb.append("\n");
        sb.append("the command-sequences may be grouped in a subroutine. a subroutine begins with\n");
        sb.append("the command .begin containing the name and any number of parameters, and ends\n");
        sb.append("with the command .end. an unlimited number of subroutines may be defined.\n");
        sb.append("subroutines contain a sequence of commands. they may also contain nested\n");
        sb.append("subroutines. nested subroutines are only accessible from the subroutine where\n");
        sb.append("it was defined. commands may be placed above or below the subroutines, it\n");
        sb.append("doesn't matter. subroutines are called using .call followed by the name and\n");
        sb.append("the same number of parameters as the subroutine-definition. \n");
        sb.append("\n");
        sb.append("...\n");
        sb.append(".call subroutine-one 44\n");
        sb.append("command-ninety-nine\n");
        sb.append("...\n");
        sb.append(".begin subroutine-one parameter-1\n");
        sb.append("\tcommand-fifty-seven\n");
        sb.append("\tcommand-fifty-eight\n");
        sb.append("\t.begin nested-subroutine-five\n");
        sb.append("\t\tcommand-xxx\n");
        sb.append("\t.end\n");
        sb.append("\tcommand-fifty-nine\n");
        sb.append("\t.call nested-subroutine-five\n");
        sb.append(".end\n");
        sb.append("...\n");
        sb.append(".call nested-subroutine-five    #ERROR, the nested subroutine is not accessible here\n");
        sb.append("...\n");
        sb.append("\n");
        sb.append("the commands are interpreted in the following order:\n");
        sb.append("command-fifty-seven\n");
        sb.append("command-fifty-eight\n");
        sb.append("command-fifty-nine\n");
        sb.append("command-xxx\n");
        sb.append("command-ninety-nine\n");
        sb.append("\n");
        sb.append("the internal commands may use variables. basically all parameters and variables\n");
        sb.append("are handled as strings, but some of them may be interpreted as integer or\n");
        sb.append("floating-point numbers, depending of the command. a variable defined in a subroutine\n");
        sb.append("is only accessible from there and from all its nested subroutines, it is a local\n");
        sb.append("variable. variables in the main script routine are accessible from anywhere, they\n");
        sb.append("are global. variables of a subroutine have a life cycle of the subroutine processing.\n");
        sb.append("when exiting the subroutine, the variable's content get lost. variables do not need\n");
        sb.append("to be declared. they are implicitely declared on first use. subroutine-parameters are\n");
        sb.append("used the same way than the variables. if a command uses a variable, the content of\n");
        sb.append("the variable is used. if a command uses an inacessible or unknown variable, then simply \n");
        sb.append("the name of the variable is used as a string.\n");
        sb.append("\n");
        sb.append("...\n");
        sb.append(".begin subroutine-one parameter-one\n");
        sb.append("\t.set variable-one 45\n");
        sb.append("\t.inc \tvariable-one\n");
        sb.append("\tcommand-fifty-eight\n");
        sb.append("\t.begin nested-subroutine-five x y z\n");
        sb.append("\t\t.input answer\n");
        sb.append("\t\t.println answer\t\t\t#the content of answer is print out\n");
        sb.append("\t\t.println variable-one\t#46 is print out\n");
        sb.append("\t\t.inc \tvariable-one\t\t#legal\n");
        sb.append("\t\t.add x x 4\n");
        sb.append("\t.end\n");
        sb.append("\t.println answer\t\t\t\t#the word \"answer\" is print out\n");
        sb.append(".end\n");
        sb.append(".inc \tvariable-one\t\t\t\t#illegal, variable is not accessible here\n");
        sb.append("...\n");
        sb.append("\n");
        sb.append("\n");
        sb.append(">>>>>>>>>>>>>>>> continue tutorial here <<<<<<<<<<<<<<<<<<<<<<<<<\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("list of the internal commands:\n");
        sb.append("\n");
        sb.append(".begin <name> [<p0> [<p1>..]].....begins the definition of a nested subroutine block. any\n");
        sb.append("                                  number of parameters may be declared.\n");
        sb.append("\n");
        sb.append(".end..............................end of a nested subroutine block.\n");
        sb.append("\n");
        sb.append(".call <name> [<p0> [<p1>..]]......calls a nested subroutine block. the exact number of declared parameters\n");
        sb.append("                                  must be passed here. recursive calls are not supported!\n");
        sb.append("\n");
        sb.append(".set <name> <value>...............(re)defines a variable, visible in the current block and subblocks\n");
        sb.append("\n");
        sb.append(".println <text>...................prints the given text on the console and new line\n");
        sb.append("\n");
        sb.append(".print <text>.....................prints the given text on the console\n");
        sb.append("\n");
        sb.append(".input <name>.....................reads in a value from the console and stores it in variable \"name\"\n");
        sb.append("\n");
        sb.append(".return...........................is not a command, it is a build-in variable that contains the return value of\n");
        sb.append("                                  the last user-command, this is visible in the current running block only. a\n");
        sb.append("                                  return value is generated by performing print/println. do not print in the\n");
        sb.append("                                  script between the command and the usage of return.\n");
        sb.append("\n");
        sb.append(".time.............................is not a command, it is a build-in variable that contains current time in\n");
        sb.append("                                  milliseconds since start of script.\n");
        sb.append("\n");
        sb.append(".for <name> b e [<p0> [<p1>..]]...iterates a nested subroutine block. b is the start value. b increments\n");
        sb.append("                                  on each loop until e is reached. any additional number of parameters may\n");
        sb.append("                                  be passed. the exact number of declared parameters must be passed here.\n");
        sb.append("\n");
        sb.append(".while <name> z [<p0> [<p1>..]]...loops in a nested subroutine block. if z is false/0, then the loop breaks.\n");
        sb.append("                                  z is accessible like any other parameter. any additional number of parameters\n");
        sb.append("                                  may be passed. the exact number of declared parameters must be passed here.\n");
        sb.append("\n");
        sb.append(".if <cond> <then> <else>..........when condition is not false/0, then the then-subroutine is performed, else\n");
        sb.append("                                  the else-subroutine is performed. only zero-parameter subroutines are allowed\n");
        sb.append("                                  here.\n");
        sb.append("\n");
        sb.append(".inc <var>........................increments the integer variable (converts floating-point to integer)\n");
        sb.append("\n");
        sb.append(".dec <var>........................decrements the integer variable (converts floating-point to integer)\n");
        sb.append("\n");
        sb.append(".add <result> <lval> <rval>.......result = lval + rval, interpreted as floating-point\n");
        sb.append("\n");
        sb.append(".sub <result> <lval> <rval>.......result = lval - rval, interpreted as floating-point\n");
        sb.append("\n");
        sb.append(".mul <result> <lval> <rval>.......result = lval * rval, interpreted as floating-point\n");
        sb.append("\n");
        sb.append(".div <result> <lval> <rval>.......result = lval / rval, interpreted as floating-point\n");
        sb.append("\n");
        sb.append(".eq <result> <lval> <rval>........result = (lval == rval), interpreted as floating-point or string, returns a boolean\n");
        sb.append("\n");
        sb.append(".not <var>........................result = !var, interpreted as floating-point, returns a boolean\n");
        sb.append("\n");
        sb.append(".gt <result> <lval> <rval>........result = lval > rval, interpreted as floating-point, returns a boolean\n");
        sb.append("\n");
        sb.append(".lt <result> <lval> <rval>........result = lval < rval, interpreted as floating-point, returns a boolean\n");
        sb.append("\n");
        sb.append(".gteq <result> <lval> <rval>......result = lval >= rval, interpreted as floating-point, returns a boolean\n");
        sb.append("\n");
        sb.append(".lteq <result> <lval> <rval>......result = lval <= rval, interpreted as floating-point, returns a boolean\n");
        sb.append("\n");
        sb.append(".sleep <timeout in ms>............sleeps for the given timeout\n");
        sb.append("\n");
        sb.append(".exit.............................exits the script (but not the java process)\n");
        sb.append("\n");
        sb.append(".debug -pl........................flag p: prints the parsed script structure now\n");
        sb.append("                                  flag l: prints the line when processed\n");
        sb.append("                                  flag s: steps through single commands\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("# an ubus script example...\n");
        sb.append(".begin init-bus\n");
        sb.append("\t.println launch...\n");
        sb.append("\tinputs -s on\n");
        sb.append("\tubus -s start\n");
        sb.append("\t.println wait a little...\n");
        sb.append("\t.sleep 6000\n");
        sb.append("\t.println configure node...\n");
        sb.append("\tnode -i 4\n");
        sb.append("\tevent.add -txn 0 -rxn 4 -txe 0 -rxe 0 -id 88\n");
        sb.append("\tappl -s start\n");
        sb.append(".end\n");
        sb.append("\n");
        sb.append(".begin ampere-consult i n d\n");
        sb.append("\tconsult.write -i 20 -t u16 -v i\n");
        sb.append("\t.sleep 330\n");
        sb.append(".end\n");
        sb.append("\n");
        sb.append(".begin ampere-event\n");
        sb.append("\tmonitor -n fl -e on\n");
        sb.append("\tevent.send -id 88 -data 00,00\n");
        sb.append("\t.println 00,00\n");
        sb.append("\t.sleep 1000\n");
        sb.append("\tevent.send -id 88 -data 00,64\n");
        sb.append("\t.println 00,64\n");
        sb.append("\t.sleep 1000\n");
        sb.append("\tevent.send -id 88 -data 00,C8\n");
        sb.append("\t.println 00,C8\n");
        sb.append("\t.sleep 1000\n");
        sb.append("\tevent.send -id 88 -data 01,2C\n");
        sb.append("\t.println 01,2C\n");
        sb.append("\t.sleep 1000\n");
        sb.append("\tevent.send -id 88 -data 01,90\n");
        sb.append("\t.println 01,90\n");
        sb.append("\t.sleep 1000\n");
        sb.append("\tmonitor -n fl -e off\n");
        sb.append(".end\n");
        sb.append("\n");
        sb.append("##.for ampere-consult 400 -400 -200\n");
        sb.append("#.debug -l\n");
        sb.append(".call init-bus\n");
        sb.append("#.debug\n");
        sb.append(".call ampere-event\n");
        sb.append(".while loop-it true\n");
        sb.append("\n");
        sb.append(".begin loop-it z\n");
        sb.append("\t.for ampere-consult 400 -400 -50\n");
        sb.append("\t.for ampere-consult -400 400 50\n");
        sb.append(".end\n");
        return sb.toString();
    }

    private class Block
    extends Line {
        public String mode;
        public String name;
        public List lines;
        int lineCounter;
        public Map blocks;
        private Map vars;
        private List params;

        public Block(String name) {
            super("", "", -1);
            this.name = name;
            this.lines = new ArrayList();
            this.blocks = new HashMap();
            this.mode = ".call";
            this.vars = new HashMap();
            this.params = new ArrayList();
        }

        public void add(Line l) {
            l.parent = this;
            if (l instanceof Block) {
                this.blocks.put(((Block)l).name, l);
            } else {
                this.lines.add(l);
            }
        }

        public Line getLine() {
            if (this.lineCounter < this.lines.size()) {
                return (Line)this.lines.get(this.lineCounter++);
            }
            return null;
        }

        public Block getBlock(String blockName) {
            Block b = (Block)this.blocks.get(blockName);
            if (b == null) {
                if (this.parent != null) {
                    return this.parent.getBlock(blockName);
                }
                return null;
            }
            return b;
        }

        public void start() {
            this.lineCounter = 0;
        }

        public String getVar(String varName) {
            for (String k : this.vars.keySet()) {
                if (!varName.equals(k)) continue;
                return (String)this.vars.get(k);
            }
            if (this.parent != null) {
                return this.parent.getVar(varName);
            }
            return varName;
        }

        public void setVar(String name, String value) {
            this.vars.put(name, value);
        }

        public void clearVars() {
            this.vars.clear();
        }

        public List getAllVisibleVars() {
            ArrayList l = new ArrayList();
            Iterator it = this.vars.keySet().iterator();
            while (it.hasNext()) {
                l.add(it.next());
            }
            if (this.parent != null) {
                l.addAll(this.parent.getAllVisibleVars());
            }
            return l;
        }

        public void addParameter(String parameter) {
            this.params.add(parameter);
        }

        public int getNumberOfParameters() {
            return this.params.size();
        }

        public String getParameterVar(int index) {
            return this.getVar(this.getParameterName(index));
        }

        public String getParameterName(int index) {
            return (String)this.params.get(index);
        }

        public void setParameterVar(int index, String value) {
            this.setVar(this.getParameterName(index), value);
        }

        public String toString() {
            return this.toString(0);
        }

        private String toString(int hierarchy) {
            StringBuffer tabsb = new StringBuffer();
            int i = 0;
            while (i < hierarchy) {
                tabsb.append("   ");
                ++i;
            }
            String tab = tabsb.toString();
            tabsb.append("   ");
            String tab2 = tabsb.toString();
            StringBuffer sb = new StringBuffer();
            sb.append(tab);
            sb.append("block " + this.name + ": \n");
            Iterator<Object> it = this.lines.iterator();
            sb.append(tab2);
            sb.append("lines:\n");
            while (it.hasNext()) {
                sb.append(tab2);
                sb.append(it.next().toString());
                sb.append("\n");
            }
            it = this.params.iterator();
            sb.append(tab2);
            sb.append("params:\n");
            while (it.hasNext()) {
                sb.append(tab2);
                sb.append(it.next().toString());
                sb.append("\n");
            }
            it = this.blocks.keySet().iterator();
            sb.append(tab2);
            sb.append("subblocks:\n");
            while (it.hasNext()) {
                sb.append(((Block)this.blocks.get(it.next())).toString(hierarchy + 1));
                sb.append("\n");
            }
            return sb.toString();
        }
    }

    private class Line {
        public Block parent;
        public String origText;
        public String text;
        public CommandLineParser parsed;
        public int lineNumber;

        public Line(String origText, String text, int lineNumber) {
            this.origText = origText;
            this.text = text;
            this.parsed = new CommandLineParser(text);
            this.lineNumber = lineNumber;
            this.parent = null;
        }

        public String toString() {
            return (String.valueOf(this.origText) + " at line " + this.lineNumber).trim();
        }
    }
}

