/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.ui;

import ch.laoe.plugin.GPlugin;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GClipFrame;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GPersistence;
import ch.laoe.ui.GToolkit;
import ch.laoe.ui.Laoe;
import java.awt.Dimension;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;

public class GMainFrame
extends JFrame
implements WindowListener {
    protected GPersistence persistence;
    private JPanel buttonPanel;

    public GMainFrame() {
        Debug.println(3, "create main-frame");
        this.setSize(new Dimension(145, 245));
        ImageIcon imageIcon = GToolkit.loadIcon(this, "laoe");
        if (imageIcon != null) {
            this.setIconImage(imageIcon.getImage());
        }
        this.setTitle(GLanguage.translate("laoe"));
        this.buttonPanel = new JPanel();
        this.getContentPane().add(this.buttonPanel);
        this.persistence = GPersistence.createPersistance();
        this.setAlwaysOnTop(this.persistence.getBoolean("mainFrame.alwaysOnTop"));
        this.setLocation(this.persistence.getInt("mainFrame.frameLocation.x"), this.persistence.getInt("mainFrame.frameLocation.y"));
        this.setSize(new Dimension(this.persistence.getInt("mainFrame.frameSize.width"), this.persistence.getInt("mainFrame.frameSize.height")));
        this.setVisible(false);
        this.addWindowListener(this);
        this.setDefaultCloseOperation(0);
    }

    public void tryToExit() {
        Debug.println(3, "try to exit");
        boolean bl = true;
        Object[] objectArray = Laoe.getInstance().getAllClipFrames();
        for (int i = 0; i < objectArray.length; ++i) {
            if (((GClipFrame)objectArray[i]).tryToClose()) continue;
            bl = false;
            break;
        }
        if (bl) {
            Debug.println(3, "backup persistent objects");
            this.persistence.setInt("mainFrame.frameLocation.x", this.getLocation().x);
            this.persistence.setInt("mainFrame.frameLocation.y", this.getLocation().y);
            this.persistence.setInt("mainFrame.frameSize.width", this.getSize().width);
            this.persistence.setInt("mainFrame.frameSize.height", this.getSize().height);
            try {
                GPersistence.createPersistance().backup();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setVisible(false);
            Debug.println(3, "exit LAoE now");
            System.exit(0);
        }
    }

    public void setMenuBar(JMenuBar jMenuBar) {
        this.setJMenuBar(jMenuBar);
        this.validate();
    }

    private void addButton(JButton jButton) {
        this.buttonPanel.add(jButton);
        this.validate();
        this.repaint();
    }

    private void removeAllButtons() {
        this.buttonPanel.removeAll();
        this.validate();
        this.repaint();
    }

    public void updateButtons() {
        GPersistence gPersistence = GPersistence.createPersistance();
        Object[] objectArray = Laoe.getInstance().getPluginHandler().getAllPlugins();
        this.removeAllButtons();
        for (int i = 0; i < objectArray.length; ++i) {
            GPlugin gPlugin = (GPlugin)objectArray[i];
            if (!gPersistence.getBoolean("mainFrame.button." + gPlugin.getName() + ".visible", false)) continue;
            this.addButton(gPlugin.createButton());
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.tryToExit();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
        Laoe.getInstance().deiconifyAllFrames();
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
        Laoe.getInstance().iconifyAllFrames();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }
}

