/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.AClip;
import ch.laoe.clip.ALayer;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GClipEditor;
import ch.laoe.ui.GClipFrame;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GPersistence;
import ch.laoe.ui.GToolkit;
import ch.laoe.ui.Laoe;
import ch.oli4.persistence.Persistence;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public abstract class GPlugin
implements ActionListener,
MouseListener,
MouseMotionListener,
Persistence.PersistenceListener {
    protected GPluginHandler pluginHandler;
    protected GPersistence persistance;
    private ImageIcon icon;

    public GPlugin(GPluginHandler gPluginHandler) {
        this.setPluginHandler(gPluginHandler);
        this.persistance = GPersistence.createPersistance();
        this.persistance.addPersistanceListener(this);
    }

    public abstract String getName();

    private final String getDescription() {
        return this.getName() + "Description";
    }

    public final String getKeyMouseHelp(boolean bl, boolean bl2) {
        return this.getName() + "KeyMouse" + (bl ? "Shift" : "") + (bl2 ? "Ctrl" : "");
    }

    protected void setPluginHandler(GPluginHandler gPluginHandler) {
        this.pluginHandler = gPluginHandler;
    }

    public boolean isVisible() {
        return false;
    }

    protected AClip getFocussedClip() {
        try {
            return this.pluginHandler.getFocussedClipEditor().getClip();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    protected ALayer getSelectedLayer() {
        try {
            return this.pluginHandler.getFocussedClipEditor().getClip().getSelectedLayer();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    protected GClipEditor getFocussedClipEditor() {
        return this.pluginHandler.getFocussedClipEditor();
    }

    protected GClipFrame getFocussedClipFrame() {
        return Laoe.getInstance().getFocussedClipFrame();
    }

    protected void autoScaleFocussedClip() {
        try {
            this.pluginHandler.getFocussedClipEditor().getClip().getPlotter().autoScale();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected final void repaintFocussedClipEditor() {
        try {
            this.pluginHandler.getFocussedClipEditor().repaint();
            this.getFocussedClipFrame().getStatusBar().update();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected final void reloadFocussedClipEditor() {
        try {
            Debug.println(7, "reloadFocussedClipEditor()");
            this.pluginHandler.reloadAllPlugins(this);
            this.pluginHandler.getFocussedClipEditor().reload();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected void updateHistory(String string) {
        try {
            this.getFocussedClip().getHistory().store(this.loadIcon(), string);
            this.updateFrameTitle();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected void updateFrameTitle() {
        if (this.getFocussedClip().getHistory().hasUnsavedModifications()) {
            this.getFocussedClipFrame().setTitle(this.getFocussedClip().getName() + " *");
        } else {
            this.getFocussedClipFrame().setTitle(this.getFocussedClip().getName());
        }
    }

    protected ImageIcon loadIcon(String string) {
        return GToolkit.loadIcon(this, string);
    }

    protected final ImageIcon loadIcon() {
        if (this.icon == null) {
            this.icon = GToolkit.loadIcon(this, this.getName());
        }
        return this.icon;
    }

    public JButton createButton() {
        JButton jButton = this.createActionlessButton();
        jButton.addActionListener(this);
        return jButton;
    }

    public JButton createActionlessButton() {
        JButton jButton = new JButton(this.loadIcon(this.getName()));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><body><b>" + GLanguage.translate(this.getName()));
        if (this instanceof GPluginFrame) {
            stringBuffer.append("...");
        }
        stringBuffer.append("</b><br>");
        stringBuffer.append(GLanguage.translate(this.getDescription()));
        stringBuffer.append("</body></html>");
        jButton.setToolTipText(stringBuffer.toString());
        jButton.setPreferredSize(new Dimension(26, 26));
        jButton.setName(this.getName());
        return jButton;
    }

    private JMenuItem createMenuItem(String string, String string2, int n) {
        String string3 = GLanguage.translate(string2);
        if (this instanceof GPluginFrame) {
            string3 = new String(string3 + "...");
        }
        JMenuItem jMenuItem = string != null ? new JMenuItem(string3, this.loadIcon(string)) : new JMenuItem(string3);
        if (n != 0) {
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n, 2));
        }
        jMenuItem.addActionListener(this);
        return jMenuItem;
    }

    public JMenuItem createMenuItem() {
        return this.createMenuItem(this.getName(), this.getName(), 0);
    }

    protected JMenuItem createMenuItem(int n) {
        return this.createMenuItem(this.getName(), this.getName(), n);
    }

    public void start() {
        Debug.println(5, "plugin " + this.getClass().getName() + " starts");
        if (this.isFocussingMouseEvents()) {
            this.pluginHandler.setFocussedPlugin(this);
        }
        this.repaintFocussedClipEditor();
    }

    public void focuss() {
        Debug.println(5, "plugin " + this.getClass().getName() + " focusses");
    }

    protected boolean isFocussingMouseEvents() {
        return false;
    }

    public void reload() {
        Debug.println(5, "plugin " + this.getClass().getName() + " reloads");
    }

    public void paintOntoClip(Graphics2D graphics2D, Rectangle rectangle) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        ((Component)mouseEvent.getSource()).setCursor(new Cursor(0));
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
    }

    protected Cursor createCustomCursor(String string) {
        return GToolkit.createCustomCursor(this, string);
    }

    @Override
    public void onBackup(Persistence persistence) {
    }

    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        this.start();
        this.focuss();
    }

    protected static class Worker
    implements Runnable {
        private static Object o = new Object();
        private Runnable runnable;
        private boolean running = false;

        public Worker(Runnable runnable) {
            Debug.println(1, "worker starts");
            this.runnable = runnable;
            new Thread(this).start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean testSetRunning() {
            Object object = o;
            synchronized (object) {
                if (this.running) {
                    return false;
                }
                this.running = true;
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clearRunning() {
            Object object = o;
            synchronized (object) {
                this.running = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.testSetRunning()) {
                try {
                    Debug.println(1, "worker thread begin");
                    this.runnable.run();
                    Debug.println(1, "worker thread end");
                }
                catch (Exception exception) {
                }
                finally {
                    this.clearRunning();
                }
            } else {
                Debug.println(1, "worker thread refused");
            }
        }
    }
}

