/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.AChannel;
import ch.laoe.clip.AClip;
import ch.laoe.clip.ALayerSelection;
import ch.laoe.operation.AOSpectrum;
import ch.laoe.operation.AOToolkit;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GClipEditor;
import ch.laoe.ui.GComboBoxPowerOf2;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.LProgressViewer;
import ch.laoe.ui.LWorker;
import ch.laoe.ui.Laoe;
import ch.oli4.ui.UiCartesianLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GPSpectrum
extends GPluginFrame {
    private GComboBoxPowerOf2 bufferLength;
    private JComboBox window;
    private JButton createSpectrum;
    private JButton update;
    private JCheckBox autoscale;
    private EventDispatcher eventDispatcher;
    private GClipEditor spectrumClipEditor;

    public GPSpectrum(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "spectrum";
    }

    private void initGui() {
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 4);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("bufferLength")), 0, 0, 4, 1);
        this.bufferLength = new GComboBoxPowerOf2(4, 18);
        this.bufferLength.setSelectedExponent(14);
        uiCartesianLayout.add(this.bufferLength, 4, 0, 6, 1);
        uiCartesianLayout.add(new JLabel(GLanguage.translate("window")), 0, 1, 4, 1);
        this.window = new JComboBox<String>(AOToolkit.getFFTWindowNames());
        uiCartesianLayout.add(this.window, 4, 1, 6, 1);
        this.autoscale = new JCheckBox(GLanguage.translate("autoscale"));
        this.autoscale.setSelected(true);
        uiCartesianLayout.add(this.autoscale, 0, 2, 10, 1);
        this.createSpectrum = new JButton(GLanguage.translate("new"));
        uiCartesianLayout.add(this.createSpectrum, 1, 3, 4, 1);
        this.update = new JButton(GLanguage.translate("update"));
        uiCartesianLayout.add(this.update, 5, 3, 4, 1);
        this.frame.getContentPane().add(jPanel);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.createSpectrum.addActionListener(this.eventDispatcher);
        this.update.addActionListener(new LWorker(this.eventDispatcher));
        this.updateGui();
    }

    private void updateGui() {
        if (this.spectrumClipEditor != null) {
            this.update.setEnabled(true);
        } else {
            this.update.setEnabled(false);
        }
    }

    private void onCreateSpectrum() {
        AClip aClip = new AClip(1, 1, this.bufferLength.getSelectedValue());
        aClip.setName("<" + GLanguage.translate("spectrum") + ">");
        aClip.setSampleRate(this.getFocussedClip().getSampleRate());
        aClip.getPlotter().setPlotterXUnit(5);
        aClip.getPlotter().setPlotterYUnit(1);
        Laoe.getInstance().addClipFrame(aClip);
        this.spectrumClipEditor = this.getFocussedClipEditor();
    }

    private void onUpdate() {
        AOSpectrum aOSpectrum = new AOSpectrum(this.bufferLength.getSelectedValue(), this.window.getSelectedIndex());
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getSelection();
        aLayerSelection.operateEachChannel(aOSpectrum);
        AClip aClip = this.spectrumClipEditor.getClip();
        AChannel aChannel = aClip.getLayer(0).getChannel(0);
        aChannel.setSamples(aOSpectrum.getSpectrum());
        aChannel.markChange();
        try {
            aClip.getHistory().store(this.loadIcon(), GLanguage.translate(this.getName()));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (this.autoscale.isSelected()) {
            aClip.getPlotter().autoScale();
        }
        this.spectrumClipEditor.reload();
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPSpectrum.this.update) {
                LProgressViewer.getInstance().entrySubProgress(GPSpectrum.this.getName());
                LProgressViewer.getInstance().entrySubProgress(0.7);
                Debug.println(1, "plugin " + GPSpectrum.this.getName() + " [update] clicked");
                GPSpectrum.this.onUpdate();
                LProgressViewer.getInstance().exitSubProgress();
                LProgressViewer.getInstance().exitSubProgress();
            } else if (actionEvent.getSource() == GPSpectrum.this.createSpectrum) {
                Debug.println(1, "plugin " + GPSpectrum.this.getName() + " [create spectrum] clicked");
                GPSpectrum.this.onCreateSpectrum();
            }
            GPSpectrum.this.updateGui();
        }
    }
}

