/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.AClip;
import ch.laoe.clip.AClipSelection;
import ch.laoe.clip.ALayerSelection;
import ch.laoe.operation.AOPitchShift;
import ch.laoe.operation.AOResample;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GClipLayerChooser;
import ch.laoe.ui.GComboBoxPowerOf2;
import ch.laoe.ui.GControlTextA;
import ch.laoe.ui.GControlTextAF;
import ch.laoe.ui.GControlTextX;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.LProgressViewer;
import ch.laoe.ui.LWorker;
import ch.laoe.ui.Laoe;
import ch.oli4.ui.UiCartesianLayout;
import ch.oli4.ui.control.UiControlText;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;

public class GPPitchShiftTimeStretch
extends GPluginFrame {
    private GComboBoxPowerOf2 pitchConstBufferLength;
    private GComboBoxPowerOf2 pitchVarBufferLength;
    private GComboBoxPowerOf2 timeBufferLength;
    private JRadioButton byFactor;
    private JRadioButton byNewTime;
    private UiControlText pitchFactor;
    private UiControlText pitchConstTransition;
    private UiControlText pitchVarTransition;
    private UiControlText timeTransition;
    private UiControlText timeFactor;
    private UiControlText newTime;
    private GClipLayerChooser layerChooser;
    private JButton pitchConstApply;
    private JButton pitchVarApply;
    private JButton timeApply;
    private EventDispatcher eventDispatcher;

    public GPPitchShiftTimeStretch(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "pitchShiftTimeStretch";
    }

    private void initGui() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        JTabbedPane jTabbedPane2 = new JTabbedPane();
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 10, 6);
        uiCartesianLayout.setPreferredCellSize(new Dimension(25, 35));
        jPanel.setLayout(uiCartesianLayout);
        jPanel.add((Component)new JLabel(GLanguage.translate("factor")), new Rectangle(0, 0, 4, 1));
        this.pitchFactor = new GControlTextAF(6, true, true);
        this.pitchFactor.setDataRange(0.2, 5.0);
        this.pitchFactor.setData(1.0);
        jPanel.add((Component)this.pitchFactor, new Rectangle(4, 0, 6, 1));
        jPanel.add((Component)new JLabel(GLanguage.translate("bufferLength")), new Rectangle(0, 3, 4, 1));
        this.pitchConstBufferLength = new GComboBoxPowerOf2(4, 15);
        this.pitchConstBufferLength.setSelectedExponent(13);
        jPanel.add((Component)this.pitchConstBufferLength, new Rectangle(4, 3, 6, 1));
        jPanel.add((Component)new JLabel(GLanguage.translate("overlap")), new Rectangle(0, 4, 4, 1));
        this.pitchConstTransition = new GControlTextA(6, true, true);
        this.pitchConstTransition.setDataRange(0.01, 0.9);
        this.pitchConstTransition.setData(0.67);
        jPanel.add((Component)this.pitchConstTransition, new Rectangle(4, 4, 6, 1));
        this.pitchConstApply = new JButton(GLanguage.translate("apply"));
        jPanel.add((Component)this.pitchConstApply, new Rectangle(3, 5, 4, 1));
        jTabbedPane2.add(GLanguage.translate("constant"), jPanel);
        JPanel jPanel2 = new JPanel();
        UiCartesianLayout uiCartesianLayout2 = new UiCartesianLayout(jPanel2, 10, 6);
        uiCartesianLayout2.setPreferredCellSize(new Dimension(25, 35));
        jPanel2.setLayout(uiCartesianLayout2);
        this.layerChooser = new GClipLayerChooser(Laoe.getInstance(), "pitchShiftCurve");
        jPanel2.add((Component)this.layerChooser, new Rectangle(0, 0, 10, 3));
        jPanel2.add((Component)new JLabel(GLanguage.translate("bufferLength")), new Rectangle(0, 3, 4, 1));
        this.pitchVarBufferLength = new GComboBoxPowerOf2(4, 15);
        this.pitchVarBufferLength.setSelectedExponent(13);
        jPanel2.add((Component)this.pitchVarBufferLength, new Rectangle(4, 3, 6, 1));
        jPanel2.add((Component)new JLabel(GLanguage.translate("overlap")), new Rectangle(0, 4, 4, 1));
        this.pitchVarTransition = new GControlTextA(6, true, true);
        this.pitchVarTransition.setDataRange(0.01, 0.9);
        this.pitchVarTransition.setData(0.67);
        jPanel2.add((Component)this.pitchVarTransition, new Rectangle(4, 4, 6, 1));
        this.pitchVarApply = new JButton(GLanguage.translate("apply"));
        jPanel2.add((Component)this.pitchVarApply, new Rectangle(3, 5, 4, 1));
        jTabbedPane2.add(GLanguage.translate("f(time)"), jPanel2);
        jTabbedPane.add(GLanguage.translate("pitchShift"), jTabbedPane2);
        JPanel jPanel3 = new JPanel();
        UiCartesianLayout uiCartesianLayout3 = new UiCartesianLayout(jPanel3, 10, 6);
        uiCartesianLayout3.setPreferredCellSize(new Dimension(25, 35));
        jPanel3.setLayout(uiCartesianLayout3);
        this.byFactor = new JRadioButton(GLanguage.translate("factor"));
        uiCartesianLayout3.add(this.byFactor, 0, 0, 4, 1);
        this.byNewTime = new JRadioButton(GLanguage.translate("newTime"));
        uiCartesianLayout3.add(this.byNewTime, 0, 1, 4, 1);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.byFactor);
        buttonGroup.add(this.byNewTime);
        this.byFactor.setSelected(true);
        this.timeFactor = new GControlTextA(6, true, true);
        this.timeFactor.setDataRange(0.2, 5.0);
        this.timeFactor.setData(1.0);
        uiCartesianLayout3.add(this.timeFactor, 4, 0, 6, 1);
        this.newTime = new GControlTextX(Laoe.getInstance(), 6, true, true);
        this.newTime.setDataRange(0.0, 1.0E9);
        this.newTime.setData(1000.0);
        uiCartesianLayout3.add(this.newTime, 4, 1, 6, 1);
        uiCartesianLayout3.add(new JLabel(GLanguage.translate("bufferLength")), 0, 3, 4, 1);
        this.timeBufferLength = new GComboBoxPowerOf2(4, 15);
        this.timeBufferLength.setSelectedExponent(13);
        uiCartesianLayout3.add(this.timeBufferLength, 4, 3, 6, 1);
        jPanel3.add((Component)new JLabel(GLanguage.translate("overlap")), new Rectangle(0, 4, 4, 1));
        this.timeTransition = new GControlTextA(6, true, true);
        this.timeTransition.setDataRange(0.01, 0.9);
        this.timeTransition.setData(0.67);
        jPanel3.add((Component)this.timeTransition, new Rectangle(4, 4, 6, 1));
        this.timeApply = new JButton(GLanguage.translate("apply"));
        uiCartesianLayout3.add(this.timeApply, 3, 5, 4, 1);
        jTabbedPane.add(GLanguage.translate("timeStretch"), jPanel3);
        this.frame.getContentPane().add(jTabbedPane);
        this.pack();
        this.updateActiveComponents();
        this.eventDispatcher = new EventDispatcher();
        this.pitchConstApply.addActionListener(new LWorker(this.eventDispatcher));
        this.pitchVarApply.addActionListener(new LWorker(this.eventDispatcher));
        this.timeApply.addActionListener(new LWorker(this.eventDispatcher));
        this.byFactor.addActionListener(this.eventDispatcher);
        this.byNewTime.addActionListener(this.eventDispatcher);
    }

    @Override
    public void reload() {
        super.reload();
        this.layerChooser.reload();
        this.pitchFactor.refresh();
        this.pitchConstTransition.refresh();
        this.pitchVarTransition.refresh();
        this.timeTransition.refresh();
        this.timeFactor.refresh();
        this.newTime.refresh();
    }

    private void updateActiveComponents() {
        if (this.byFactor.isSelected()) {
            this.timeFactor.setEnabled(true);
            this.newTime.setEnabled(false);
        } else if (this.byNewTime.isSelected()) {
            this.timeFactor.setEnabled(false);
            this.newTime.setEnabled(true);
        }
    }

    private void onPitchConstApply() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getSelection();
        float f = (float)this.pitchFactor.getData();
        float f2 = (float)this.pitchConstTransition.getData();
        aLayerSelection.operateEachChannel(new AOPitchShift(f, this.pitchConstBufferLength.getSelectedValue(), f2));
    }

    private void onPitchVarApply() {
        float f = (float)this.pitchVarTransition.getData();
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getSelection();
        ALayerSelection aLayerSelection2 = this.layerChooser.getSelectedLayer().createSelection();
        AClipSelection aClipSelection = new AClipSelection(new AClip());
        aClipSelection.addLayerSelection(aLayerSelection);
        aClipSelection.addLayerSelection(aLayerSelection2);
        aClipSelection.operateLayer0WithLayer1(new AOPitchShift(this.pitchVarBufferLength.getSelectedValue(), f));
    }

    private void onTimeApply() {
        ALayerSelection aLayerSelection = this.getFocussedClip().getSelectedLayer().getSelection();
        float f = 1.0f;
        float f2 = (float)this.timeTransition.getData();
        if (this.byFactor.isSelected()) {
            f = (float)this.timeFactor.getData();
        } else if (this.byNewTime.isSelected()) {
            f = (float)this.newTime.getData() / (float)aLayerSelection.getMaxLength();
        }
        LProgressViewer.getInstance().entrySubProgress(0.7);
        aLayerSelection.operateEachChannel(new AOPitchShift(f, this.timeBufferLength.getSelectedValue(), f2));
        aLayerSelection.operateEachChannel(new AOResample(1.0f / f, 3));
        this.pluginHandler.getFocussedClip().getSelectedLayer().setEmptySelection();
        LProgressViewer.getInstance().exitSubProgress();
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPPitchShiftTimeStretch.this.pitchConstApply) {
                LProgressViewer.getInstance().entrySubProgress(GPPitchShiftTimeStretch.this.getName());
                LProgressViewer.getInstance().entrySubProgress(0.7);
                Debug.println(1, "plugin " + GPPitchShiftTimeStretch.this.getName() + " [pitch const apply] clicked");
                GPPitchShiftTimeStretch.this.onPitchConstApply();
                GPPitchShiftTimeStretch.this.updateHistory(GLanguage.translate(GPPitchShiftTimeStretch.this.getName()));
                LProgressViewer.getInstance().exitSubProgress();
                LProgressViewer.getInstance().exitSubProgress();
                GPPitchShiftTimeStretch.this.reloadFocussedClipEditor();
                GPPitchShiftTimeStretch.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPPitchShiftTimeStretch.this.pitchVarApply) {
                LProgressViewer.getInstance().entrySubProgress(GPPitchShiftTimeStretch.this.getName());
                LProgressViewer.getInstance().entrySubProgress(0.7);
                Debug.println(1, "plugin " + GPPitchShiftTimeStretch.this.getName() + " [pitch var apply] clicked");
                GPPitchShiftTimeStretch.this.onPitchVarApply();
                GPPitchShiftTimeStretch.this.updateHistory(GLanguage.translate(GPPitchShiftTimeStretch.this.getName()));
                LProgressViewer.getInstance().exitSubProgress();
                LProgressViewer.getInstance().exitSubProgress();
                GPPitchShiftTimeStretch.this.reloadFocussedClipEditor();
                GPPitchShiftTimeStretch.this.autoCloseNow();
            } else if (actionEvent.getSource() == GPPitchShiftTimeStretch.this.timeApply) {
                LProgressViewer.getInstance().entrySubProgress(GPPitchShiftTimeStretch.this.getName());
                LProgressViewer.getInstance().entrySubProgress(0.7);
                Debug.println(1, "plugin " + GPPitchShiftTimeStretch.this.getName() + " [time apply] clicked");
                GPPitchShiftTimeStretch.this.onTimeApply();
                GPPitchShiftTimeStretch.this.updateHistory(GLanguage.translate(GPPitchShiftTimeStretch.this.getName()));
                LProgressViewer.getInstance().exitSubProgress();
                LProgressViewer.getInstance().exitSubProgress();
                GPPitchShiftTimeStretch.this.reloadFocussedClipEditor();
                GPPitchShiftTimeStretch.this.autoCloseNow();
            } else {
                GPPitchShiftTimeStretch.this.updateActiveComponents();
            }
        }
    }
}

