/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.operation.AOToolkit;
import ch.laoe.plugin.GPlugin;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GColorPicker;
import ch.laoe.ui.GControlTextX;
import ch.laoe.ui.GDialog;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GPersistence;
import ch.laoe.ui.Laoe;
import ch.oli4.ui.control.UiControlText;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class GPOptions
extends GPluginFrame {
    private JTree tree;
    private JPanel nodePanel;
    private JTextField language;
    private UiControlText debugTraceLevel;
    private GControlTextX zeroCrossWidth;
    private JCheckBox undoHistoryEnable;
    private JCheckBox undoHistoryCompression;
    private JCheckBox mainFrameAlwaysOnTop;
    private JCheckBox pluginFrameAlwaysOnTop;
    private JCheckBox pluginAutoClose;
    private PluginButtons mainFrameButtons;
    private UiControlText clipWidth;
    private UiControlText clipHeight;
    private JTextArea defaultComment;
    private GColorPicker gridColor;
    private GColorPicker backgroundColor;
    private GColorPicker sampleColor;
    private UiControlText fontSize;
    private JComboBox font;
    private JComboBox uiTheme;
    private JButton apply;
    private EventDispatcher eventDispatcher;

    public GPOptions(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
    }

    @Override
    public String getName() {
        return "laoeOptions";
    }

    @Override
    public void start() {
        boolean bl = this.isVisible();
        super.start();
        if (!bl) {
            this.frame.getContentPane().removeAll();
            this.initGui();
            this.restoreOptions();
        }
    }

    private void initGui() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(GLanguage.translate("laoe"));
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(GLanguage.translate("general"));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        OptionNode optionNode = new OptionNode(GLanguage.translate("ui"));
        defaultMutableTreeNode2.add(optionNode);
        this.uiTheme = new JComboBox<String>(Laoe.getAllThemes());
        optionNode.add(new OptionEntry("theme", this.uiTheme));
        OptionNode optionNode2 = new OptionNode(GLanguage.translate("font"));
        defaultMutableTreeNode2.add(optionNode2);
        this.font = new JComboBox<String>(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        optionNode2.add(new OptionEntry("font", this.font));
        this.fontSize = new UiControlText(5, true, false);
        optionNode2.add(new OptionEntry("size", this.fontSize));
        OptionNode optionNode3 = new OptionNode(GLanguage.translate("language"));
        defaultMutableTreeNode2.add(optionNode3);
        this.language = new JTextField(7);
        optionNode3.add(new OptionEntry("language", this.language));
        OptionNode optionNode4 = new OptionNode(GLanguage.translate("debug"));
        defaultMutableTreeNode2.add(optionNode4);
        this.debugTraceLevel = new UiControlText(7, true, false);
        this.debugTraceLevel.setDataRange(0.0, 10.0);
        optionNode4.add(new OptionEntry("verboseLevel", this.debugTraceLevel));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(GLanguage.translate("edit"));
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        OptionNode optionNode5 = new OptionNode(GLanguage.translate("zeroCross"));
        defaultMutableTreeNode3.add(optionNode5);
        this.zeroCrossWidth = new GControlTextX(Laoe.getInstance(), 8, true, true);
        this.zeroCrossWidth.setData(AOToolkit.getZeroCrossWidth());
        this.zeroCrossWidth.setDataRange(0.0, 300.0);
        this.zeroCrossWidth.setUnit(" ");
        optionNode5.add(new OptionEntry("zeroCrossWidth", this.zeroCrossWidth));
        OptionNode optionNode6 = new OptionNode(GLanguage.translate("undoStack"));
        defaultMutableTreeNode3.add(optionNode6);
        this.undoHistoryEnable = new JCheckBox(GLanguage.translate("enable"));
        optionNode6.add(new OptionEntry("", this.undoHistoryEnable));
        this.undoHistoryCompression = new JCheckBox(GLanguage.translate("compression"));
        optionNode6.add(new OptionEntry("", this.undoHistoryCompression));
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(GLanguage.translate("mainFrame"));
        defaultMutableTreeNode.add(defaultMutableTreeNode4);
        OptionNode optionNode7 = new OptionNode(GLanguage.translate("window"));
        defaultMutableTreeNode4.add(optionNode7);
        this.mainFrameAlwaysOnTop = new JCheckBox(GLanguage.translate("alwaysOnTop"));
        optionNode7.add(new OptionEntry("", this.mainFrameAlwaysOnTop));
        OptionNode optionNode8 = new OptionNode(GLanguage.translate("buttons"));
        defaultMutableTreeNode4.add(optionNode8);
        this.mainFrameButtons = new PluginButtons();
        optionNode8.add(this.mainFrameButtons);
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(GLanguage.translate("plugins"));
        defaultMutableTreeNode.add(defaultMutableTreeNode5);
        OptionNode optionNode9 = new OptionNode(GLanguage.translate("window"));
        defaultMutableTreeNode5.add(optionNode9);
        this.pluginFrameAlwaysOnTop = new JCheckBox(GLanguage.translate("alwaysOnTop"));
        optionNode9.add(new OptionEntry("", this.pluginFrameAlwaysOnTop));
        this.pluginAutoClose = new JCheckBox(GLanguage.translate("autoClose"));
        optionNode9.add(new OptionEntry("", this.pluginAutoClose));
        DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(GLanguage.translate("clip"));
        defaultMutableTreeNode.add(defaultMutableTreeNode6);
        OptionNode optionNode10 = new OptionNode(GLanguage.translate("frameSize"));
        defaultMutableTreeNode6.add(optionNode10);
        this.clipWidth = new UiControlText(7, true, false);
        this.clipWidth.setDataRange(30.0, 2000.0);
        optionNode10.add(new OptionEntry("width", this.clipWidth));
        this.clipHeight = new UiControlText(7, true, false);
        this.clipHeight.setDataRange(30.0, 2000.0);
        optionNode10.add(new OptionEntry("height", this.clipHeight));
        OptionNode optionNode11 = new OptionNode(GLanguage.translate("defaultComment"));
        defaultMutableTreeNode6.add(optionNode11);
        this.defaultComment = new JTextArea(4, 19);
        optionNode11.add(new OptionEntry("defaultComment", this.defaultComment));
        OptionNode optionNode12 = new OptionNode(GLanguage.translate("defaultColors"));
        defaultMutableTreeNode6.add(optionNode12);
        this.gridColor = new GColorPicker(GLanguage.translate("grid"), GLanguage.translate("gridColor"));
        this.gridColor.setToolTipText(GLanguage.translate("gridColor"));
        optionNode12.add(new OptionEntry("gridColor", this.gridColor));
        this.gridColor.addActionListener(this.eventDispatcher);
        this.backgroundColor = new GColorPicker(GLanguage.translate("background"), GLanguage.translate("backgroundColor"));
        this.backgroundColor.setToolTipText(GLanguage.translate("backgroundColor"));
        optionNode12.add(new OptionEntry("backgroundColor", this.backgroundColor));
        this.backgroundColor.addActionListener(this.eventDispatcher);
        this.sampleColor = new GColorPicker(GLanguage.translate("samples"), GLanguage.translate("sampleColor"));
        this.sampleColor.setToolTipText(GLanguage.translate("sampleColor"));
        optionNode12.add(new OptionEntry("sampleColor", this.sampleColor));
        this.sampleColor.addActionListener(this.eventDispatcher);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.tree = new JTree(defaultMutableTreeNode);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setScrollsOnExpand(true);
        this.tree.setShowsRootHandles(true);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setOpenIcon(this.loadIcon("open"));
        defaultTreeCellRenderer.setClosedIcon(this.loadIcon("close"));
        defaultTreeCellRenderer.setLeafIcon(this.loadIcon("laoe"));
        this.tree.setCellRenderer(defaultTreeCellRenderer);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        this.nodePanel = new JPanel();
        this.nodePanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane2 = new JScrollPane(this.nodePanel);
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, jScrollPane2);
        jPanel.add((Component)jSplitPane, "Center");
        this.apply = new JButton(GLanguage.translate("apply"));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.apply);
        jPanel.add((Component)jPanel2, "South");
        this.frame.getContentPane().add(jPanel);
        this.pack();
        this.frame.setResizable(true);
        this.frame.setSize(300, 400);
        jSplitPane.setDividerLocation(0.5);
        this.eventDispatcher = new EventDispatcher();
        this.apply.addActionListener(this.eventDispatcher);
        this.tree.addTreeSelectionListener(this.eventDispatcher);
    }

    private void restoreOptions() {
        GPersistence gPersistence = GPersistence.createPersistance();
        this.language.setText(gPersistence.getString("language"));
        this.debugTraceLevel.setData(gPersistence.getInt("debug.verboseLevel"));
        this.zeroCrossWidth.setData(gPersistence.getInt("zerocross.width", 30));
        this.zeroCrossWidth.refresh();
        this.undoHistoryEnable.setSelected(gPersistence.getBoolean("history.enable"));
        this.undoHistoryCompression.setSelected(gPersistence.getBoolean("history.compression"));
        this.clipWidth.setData(gPersistence.getInt("clip.frameSize.width"));
        this.clipHeight.setData(gPersistence.getInt("clip.frameSize.height"));
        this.defaultComment.setText(gPersistence.getString("clip.defaultComment"));
        this.gridColor.setSelectedColor(new Color(gPersistence.getInt("clip.defaultGridColor")));
        this.backgroundColor.setSelectedColor(new Color(gPersistence.getInt("clip.defaultBackgroundColor")));
        this.sampleColor.setSelectedColor(new Color(gPersistence.getInt("clip.defaultSampleColor")));
        this.uiTheme.setSelectedItem(gPersistence.getString("ui.theme"));
        this.font.setSelectedItem(gPersistence.getString("font.name"));
        this.fontSize.setData(gPersistence.getInt("font.size"));
        this.pluginFrameAlwaysOnTop.setSelected(gPersistence.getBoolean("pluginFrame.alwaysOnTop"));
        this.mainFrameAlwaysOnTop.setSelected(gPersistence.getBoolean("mainFrame.alwaysOnTop"));
        this.mainFrameButtons.restore(gPersistence);
        this.pluginAutoClose.setSelected(gPersistence.getBoolean("plugin.autoclose"));
    }

    private void onApply() {
        if (GDialog.showYesNoQuestionDialog(this.frame, GLanguage.translate("information"), GLanguage.translate("changesWillBeDoneAfterNewStartOfLaoe"))) {
            GPersistence gPersistence = GPersistence.createPersistance();
            gPersistence.setString("language", this.language.getText());
            gPersistence.setInt("debug.verboseLevel", (int)this.debugTraceLevel.getData());
            gPersistence.setInt("zerocross.width", (int)this.zeroCrossWidth.getData());
            AOToolkit.setZeroCrossWidth((int)this.zeroCrossWidth.getData());
            gPersistence.setBoolean("history.enable", this.undoHistoryEnable.isSelected());
            gPersistence.setBoolean("history.compression", this.undoHistoryCompression.isSelected());
            gPersistence.setInt("clip.frameSize.width", (int)this.clipWidth.getData());
            gPersistence.setInt("clip.frameSize.height", (int)this.clipHeight.getData());
            gPersistence.setString("clip.defaultComment", this.defaultComment.getText());
            gPersistence.setInt("clip.defaultGridColor", this.gridColor.getSelectedColor().getRGB());
            gPersistence.setInt("clip.defaultBackgroundColor", this.backgroundColor.getSelectedColor().getRGB());
            gPersistence.setInt("clip.defaultSampleColor", this.sampleColor.getSelectedColor().getRGB());
            gPersistence.setString("ui.theme", (String)this.uiTheme.getSelectedItem());
            gPersistence.setString("font.name", (String)this.font.getSelectedItem());
            gPersistence.setInt("font.size", (int)this.fontSize.getData());
            gPersistence.setBoolean("pluginFrame.alwaysOnTop", this.pluginFrameAlwaysOnTop.isSelected());
            gPersistence.setBoolean("mainFrame.alwaysOnTop", this.mainFrameAlwaysOnTop.isSelected());
            this.mainFrameButtons.backup(GPersistence.createPersistance());
            gPersistence.setBoolean("plugin.autoclose", this.pluginAutoClose.isSelected());
        }
        this.autoCloseNow();
    }

    private class EventDispatcher
    implements ActionListener,
    TreeSelectionListener {
        private JPanel actualNode;

        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPOptions.this.apply) {
                Debug.println(1, "plugin " + GPOptions.this.getName() + " [apply] clicked");
                GPOptions.this.onApply();
            }
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
            if (this.actualNode != null) {
                this.actualNode.setVisible(false);
            }
            if (defaultMutableTreeNode instanceof OptionNode) {
                this.actualNode = ((OptionNode)defaultMutableTreeNode).getPanel();
                GPOptions.this.nodePanel.add((Component)this.actualNode, "Center");
                this.actualNode.setVisible(true);
                GPOptions.this.nodePanel.validate();
            }
        }
    }

    private class OptionEntry
    extends JPanel {
        public OptionEntry(String string, JComponent jComponent) {
            this.add(new JLabel(GLanguage.translate(string)));
            this.add(jComponent);
        }
    }

    private class OptionNode
    extends DefaultMutableTreeNode {
        private String name;
        private JPanel panel;

        public OptionNode(String string) {
            this.name = string;
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 1));
        }

        @Override
        public String toString() {
            return this.name;
        }

        public void add(JComponent jComponent, int n, int n2, int n3, int n4) {
            this.panel.add(jComponent);
        }

        public void add(JComponent jComponent) {
            this.panel.add(jComponent);
        }

        public JPanel getPanel() {
            return this.panel;
        }
    }

    private class PluginButtons
    extends JPanel
    implements ActionListener {
        private HashMap<String, GPlugin> plugins;
        private ArrayList<String> unselectedPlugins;
        private ArrayList<String> selectedPlugins;

        public PluginButtons() {
            this.setLayout(new GridLayout(1, 2));
            this.setPreferredSize(new Dimension(250, 1600));
            this.plugins = new HashMap();
            Object[] objectArray = Laoe.getInstance().getPluginHandler().getAllPlugins();
            for (int i = 0; i < objectArray.length; ++i) {
                GPlugin gPlugin = (GPlugin)objectArray[i];
                this.plugins.put(gPlugin.getName(), gPlugin);
            }
            this.unselectedPlugins = new ArrayList();
            this.selectedPlugins = new ArrayList();
            this.restore(GPersistence.createPersistance());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = ((JButton)actionEvent.getSource()).getName();
            if (this.selectedPlugins.contains(string)) {
                this.selectedPlugins.remove(string);
                this.unselectedPlugins.add(string);
            } else {
                this.unselectedPlugins.remove(string);
                this.selectedPlugins.add(string);
            }
            this.refresh();
        }

        private void refresh() {
            this.removeAll();
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createTitledBorder("unselected"));
            for (String object : this.unselectedPlugins) {
                JButton jButton = this.plugins.get(object).createActionlessButton();
                jButton.addActionListener(this);
                jPanel.add(jButton);
            }
            this.add(jPanel);
            JPanel jPanel2 = new JPanel();
            jPanel2.setBorder(BorderFactory.createTitledBorder("selected"));
            for (String string : this.selectedPlugins) {
                JButton jButton = this.plugins.get(string).createActionlessButton();
                jButton.addActionListener(this);
                jPanel2.add(jButton);
            }
            this.add(jPanel2);
            this.validate();
            this.repaint();
        }

        public void restore(GPersistence gPersistence) {
            this.selectedPlugins.clear();
            this.unselectedPlugins.clear();
            for (String string : this.plugins.keySet()) {
                if (gPersistence.getBoolean("mainFrame.button." + string + ".visible", false)) {
                    this.selectedPlugins.add(string);
                    continue;
                }
                this.unselectedPlugins.add(string);
            }
            this.refresh();
            Laoe.getInstance().getMainFrame().updateButtons();
        }

        public void backup(GPersistence gPersistence) {
            for (String string : this.selectedPlugins) {
                gPersistence.setBoolean("mainFrame.button." + string + ".visible", true);
            }
            for (String string : this.unselectedPlugins) {
                gPersistence.setBoolean("mainFrame.button." + string + ".visible", false);
            }
            Laoe.getInstance().getMainFrame().updateButtons();
        }
    }
}

