/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.clip.ALayer;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.laoe.ui.GColorPicker;
import ch.laoe.ui.GGraphicObjects;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GToolkit;
import ch.oli4.ui.UiCartesianLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class GPGraphicDocumentation
extends GPluginFrame {
    private GGraphicObjects graphicObjects = null;
    private JToggleButton lineButton;
    private JToggleButton rectangleButton;
    private JToggleButton textButton;
    private JToggleButton eraseButton;
    private GColorPicker color;
    private EventDispatcher eventDispatcher;

    public GPGraphicDocumentation(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "graphicDoc";
    }

    @Override
    public void start() {
        super.start();
        this.repaintFocussedClipEditor();
        this.reloadGui();
    }

    @Override
    public void reload() {
        super.reload();
        this.lineButton.setSelected(GGraphicObjects.getOperation() == 1);
        this.rectangleButton.setSelected(GGraphicObjects.getOperation() == 2);
        this.textButton.setSelected(GGraphicObjects.getOperation() == 3);
        this.color.setSelectedColor(GGraphicObjects.getCurrentColor());
        this.repaintFocussedClipEditor();
        this.reloadGui();
    }

    @Override
    protected boolean isFocussingMouseEvents() {
        return true;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        ALayer aLayer = this.getFocussedClip().getSelectedLayer();
        int n = aLayer.getPlotter().getInsideChannelIndex(mouseEvent.getPoint());
        if (n >= 0) {
            this.graphicObjects = aLayer.getChannel(n).getGraphicObjects();
        }
        try {
            if (this.graphicObjects != null) {
                if (GGraphicObjects.getOperation() == 3) {
                    String string = JOptionPane.showInputDialog(GLanguage.translate("enterText"));
                    if (string == null) {
                        string = "";
                    }
                    GGraphicObjects.setCurrentText(string);
                }
                this.graphicObjects.mousePressed(mouseEvent);
            }
            this.reloadGui();
            this.repaintFocussedClipEditor();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        try {
            if (this.graphicObjects != null) {
                this.graphicObjects.mouseMoved(mouseEvent);
            }
            this.reloadGui();
            this.repaintFocussedClipEditor();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.graphicObjects != null) {
            this.graphicObjects.mouseDragged(mouseEvent);
        }
        this.reloadGui();
        this.repaintFocussedClipEditor();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.graphicObjects != null) {
            this.graphicObjects.mouseReleased(mouseEvent);
        }
        this.reloadGui();
        this.repaintFocussedClipEditor();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.graphicObjects != null) {
            this.graphicObjects.mouseClicked(mouseEvent);
        }
        this.reloadGui();
        this.repaintFocussedClipEditor();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.graphicObjects != null) {
            this.graphicObjects.mouseEntered(mouseEvent);
        }
        this.reloadGui();
        this.repaintFocussedClipEditor();
    }

    @Override
    public void paintOntoClip(Graphics2D graphics2D, Rectangle rectangle) {
        try {
            ALayer aLayer = this.getSelectedLayer();
            for (int i = 0; i < aLayer.getNumberOfChannels(); ++i) {
                aLayer.getChannel(i).getGraphicObjects().paintOntoClip(graphics2D, rectangle);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initGui() {
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 4, 2);
        uiCartesianLayout.setPreferredCellSize(new Dimension(35, 35));
        jPanel.setLayout(uiCartesianLayout);
        this.lineButton = new JToggleButton(GToolkit.loadIcon(this, "drawLine"));
        this.lineButton.setToolTipText(GLanguage.translate("drawLine"));
        jPanel.add((Component)this.lineButton, new Rectangle(0, 0, 1, 1));
        this.rectangleButton = new JToggleButton(GToolkit.loadIcon(this, "drawRectangle"));
        this.rectangleButton.setToolTipText(GLanguage.translate("drawRectangle"));
        jPanel.add((Component)this.rectangleButton, new Rectangle(1, 0, 1, 1));
        this.textButton = new JToggleButton(GToolkit.loadIcon(this, "drawText"));
        this.textButton.setToolTipText(GLanguage.translate("drawText"));
        jPanel.add((Component)this.textButton, new Rectangle(2, 0, 1, 1));
        this.eraseButton = new JToggleButton(GToolkit.loadIcon(this, "erase"));
        this.eraseButton.setToolTipText(GLanguage.translate("erase"));
        jPanel.add((Component)this.eraseButton, new Rectangle(3, 0, 1, 1));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.lineButton);
        buttonGroup.add(this.rectangleButton);
        buttonGroup.add(this.textButton);
        buttonGroup.add(this.eraseButton);
        this.color = new GColorPicker(GLanguage.translate("color"), GLanguage.translate("color"));
        jPanel.add((Component)this.color, new Rectangle(0, 1, 3, 1));
        this.frame.getContentPane().add(jPanel);
        this.pack();
        this.eventDispatcher = new EventDispatcher();
        this.lineButton.addActionListener(this.eventDispatcher);
        this.rectangleButton.addActionListener(this.eventDispatcher);
        this.textButton.addActionListener(this.eventDispatcher);
        this.eraseButton.addActionListener(this.eventDispatcher);
        this.color.addActionListener(this.eventDispatcher);
    }

    private void reloadGui() {
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GPGraphicDocumentation.this.lineButton) {
                Debug.println(1, "plugin " + GPGraphicDocumentation.this.getName() + " [line] clicked");
                GGraphicObjects.setOperation(1);
            } else if (actionEvent.getSource() == GPGraphicDocumentation.this.rectangleButton) {
                Debug.println(1, "plugin " + GPGraphicDocumentation.this.getName() + " [rectangle] clicked");
                GGraphicObjects.setOperation(2);
            } else if (actionEvent.getSource() == GPGraphicDocumentation.this.textButton) {
                Debug.println(1, "plugin " + GPGraphicDocumentation.this.getName() + " [text] clicked");
                GGraphicObjects.setOperation(3);
            } else if (actionEvent.getSource() == GPGraphicDocumentation.this.eraseButton) {
                Debug.println(1, "plugin " + GPGraphicDocumentation.this.getName() + " [erase] clicked");
                GGraphicObjects.setOperation(4);
            } else if (actionEvent.getSource() == GPGraphicDocumentation.this.color) {
                Debug.println(1, "plugin " + GPGraphicDocumentation.this.getName() + " [color chooser] clicked");
                GGraphicObjects.setCurrentColor(GPGraphicDocumentation.this.color.getSelectedColor());
            }
        }
    }
}

