/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.plugin;

import ch.laoe.operation.AOToolkit;
import ch.laoe.plugin.GPluginFrame;
import ch.laoe.plugin.GPluginHandler;
import ch.laoe.ui.Debug;
import ch.oli4.ui.UiCartesianLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GPCalculator
extends GPluginFrame {
    private JTextField display;
    private JButton[][] keyboard;
    private static final int KEY_COL = 5;
    private static final int KEY_ROW = 6;
    private static final String[][] keyName = new String[][]{{"+oct", "+htone", "->s", "->dB", "CE"}, {"-oct", "-htone", "s->", "dB->", "/"}, {"sqrt", "7", "8", "9", "*"}, {"x^2", "4", "5", "6", "-"}, {"1/x", "1", "2", "3", "+"}, {"", "0", ".", "+/-", "="}};
    private static final int[][] keyColor = new int[][]{{0, 0, 0, 0, 2}, {0, 0, 0, 0, 0}, {0, 1, 1, 1, 0}, {0, 1, 1, 1, 0}, {0, 1, 1, 1, 0}, {0, 1, 0, 0, 0}};
    private EventDispatcher eventDispatcher;
    private double input1;
    private double input2;
    private String binaryOperation;

    public GPCalculator(GPluginHandler gPluginHandler) {
        super(gPluginHandler);
        this.initGui();
    }

    @Override
    public String getName() {
        return "calculator";
    }

    private void initGui() {
        JPanel jPanel = new JPanel();
        UiCartesianLayout uiCartesianLayout = new UiCartesianLayout(jPanel, 5, 7);
        uiCartesianLayout.setPreferredCellSize(new Dimension(60, 25));
        uiCartesianLayout.setCellGap(0.03f);
        jPanel.setLayout(uiCartesianLayout);
        Color color = new Color(0xA0A060);
        Color color2 = new Color(0xA06060);
        this.display = new JTextField(30);
        this.display.addActionListener(this.eventDispatcher);
        uiCartesianLayout.add(this.display, 0, 0, 5, 1);
        this.eventDispatcher = new EventDispatcher();
        this.keyboard = new JButton[6][5];
        for (int i = 0; i < 6; ++i) {
            this.keyboard[i] = new JButton[5];
            block5: for (int j = 0; j < 5; ++j) {
                this.keyboard[i][j] = new JButton(keyName[i][j]);
                uiCartesianLayout.add(this.keyboard[i][j], j, i + 1, 1, 1);
                this.keyboard[i][j].addActionListener(this.eventDispatcher);
                this.keyboard[i][j].setMargin(new Insets(1, 1, 1, 1));
                switch (keyColor[i][j]) {
                    case 1: {
                        this.keyboard[i][j].setBackground(color);
                        continue block5;
                    }
                    case 2: {
                        this.keyboard[i][j].setBackground(color2);
                    }
                }
            }
        }
        this.frame.getContentPane().add(jPanel);
        this.pack();
    }

    private void calculate(String string) {
        try {
            if (string.compareTo("0") == 0) {
                this.display.setText(new String(this.display.getText() + "0"));
            } else if (string.compareTo("1") == 0) {
                this.display.setText(new String(this.display.getText() + "1"));
            } else if (string.compareTo("2") == 0) {
                this.display.setText(new String(this.display.getText() + "2"));
            } else if (string.compareTo("3") == 0) {
                this.display.setText(new String(this.display.getText() + "3"));
            } else if (string.compareTo("4") == 0) {
                this.display.setText(new String(this.display.getText() + "4"));
            } else if (string.compareTo("5") == 0) {
                this.display.setText(new String(this.display.getText() + "5"));
            } else if (string.compareTo("6") == 0) {
                this.display.setText(new String(this.display.getText() + "6"));
            } else if (string.compareTo("7") == 0) {
                this.display.setText(new String(this.display.getText() + "7"));
            } else if (string.compareTo("8") == 0) {
                this.display.setText(new String(this.display.getText() + "8"));
            } else if (string.compareTo("9") == 0) {
                this.display.setText(new String(this.display.getText() + "9"));
            } else if (string.compareTo(".") == 0) {
                this.display.setText(new String(this.display.getText() + "."));
            } else if (string.compareTo("CE") == 0) {
                this.display.setText("");
            } else if (string.compareTo("enter") == 0) {
                this.input1 = Double.parseDouble(this.display.getText());
                this.display.setText(String.valueOf(this.input1));
            } else if (string.compareTo("1/x") == 0) {
                this.input1 = Double.parseDouble(this.display.getText());
                this.input1 = 1.0 / this.input1;
                this.display.setText(String.valueOf(this.input1));
            } else if (string.compareTo("+/-") == 0) {
                this.input1 = Double.parseDouble(this.display.getText());
                this.input1 = -this.input1;
                this.display.setText(String.valueOf(this.input1));
            } else if (string.compareTo("+oct") == 0) {
                this.input1 = Double.parseDouble(this.display.getText());
                this.input1 *= 2.0;
                this.display.setText(String.valueOf(this.input1));
            } else if (string.compareTo("-oct") == 0) {
                this.input1 = Double.parseDouble(this.display.getText());
                this.input1 *= 0.5;
                this.display.setText(String.valueOf(this.input1));
            } else if (string.compareTo("+htone") == 0) {
                this.input1 = Double.parseDouble(this.display.getText());
                this.input1 *= 1.0594630943592953;
                this.display.setText(String.valueOf(this.input1));
            } else if (string.compareTo("-htone") == 0) {
                this.input1 = Double.parseDouble(this.display.getText());
                this.input1 /= 1.0594630943592953;
                this.display.setText(String.valueOf(this.input1));
            } else if (string.compareTo("->s") == 0) {
                this.input1 = Double.parseDouble(this.display.getText());
                this.input1 /= (double)this.pluginHandler.getFocussedClip().getSampleRate();
                this.display.setText(String.valueOf(this.input1));
            } else if (string.compareTo("s->") == 0) {
                this.input1 = Double.parseDouble(this.display.getText());
                this.input1 *= (double)this.pluginHandler.getFocussedClip().getSampleRate();
                this.display.setText(String.valueOf(this.input1));
            } else if (string.compareTo("sqrt") == 0) {
                this.input1 = Double.parseDouble(this.display.getText());
                this.input1 = Math.sqrt(this.input1);
                this.display.setText(String.valueOf(this.input1));
            } else if (string.compareTo("x^2") == 0) {
                this.input1 = Double.parseDouble(this.display.getText());
                this.input1 *= this.input1;
                this.display.setText(String.valueOf(this.input1));
            } else if (string.compareTo("->dB") == 0) {
                this.input1 = Double.parseDouble(this.display.getText());
                this.input1 = AOToolkit.todB((float)this.input1);
                this.display.setText(String.valueOf(this.input1));
            } else if (string.compareTo("dB->") == 0) {
                this.input1 = Double.parseDouble(this.display.getText());
                this.input1 = AOToolkit.fromdB((float)this.input1);
                this.display.setText(String.valueOf(this.input1));
            } else if (string.compareTo("*") == 0) {
                this.input1 = Double.parseDouble(this.display.getText());
                this.binaryOperation = "*";
                this.display.setText("");
            } else if (string.compareTo("/") == 0) {
                this.input1 = Double.parseDouble(this.display.getText());
                this.binaryOperation = "/";
                this.display.setText("");
            } else if (string.compareTo("+") == 0) {
                this.input1 = Double.parseDouble(this.display.getText());
                this.binaryOperation = "+";
                this.display.setText("");
            } else if (string.compareTo("-") == 0) {
                this.input1 = Double.parseDouble(this.display.getText());
                this.binaryOperation = "-";
                this.display.setText("");
            } else if (string.compareTo("=") == 0) {
                this.input2 = Double.parseDouble(this.display.getText());
                if (this.binaryOperation.compareTo("*") == 0) {
                    this.display.setText(String.valueOf(this.input1 * this.input2));
                } else if (this.binaryOperation.compareTo("/") == 0) {
                    this.display.setText(String.valueOf(this.input1 / this.input2));
                } else if (this.binaryOperation.compareTo("+") == 0) {
                    this.display.setText(String.valueOf(this.input1 + this.input2));
                } else if (this.binaryOperation.compareTo("-") == 0) {
                    this.display.setText(String.valueOf(this.input1 - this.input2));
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.display.setText("ERROR");
        }
    }

    private class EventDispatcher
    implements ActionListener {
        private EventDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 5; ++j) {
                    if (actionEvent.getSource() != GPCalculator.this.keyboard[i][j]) continue;
                    Debug.println(1, "plugin " + GPCalculator.this.getName() + " [" + actionEvent.getActionCommand() + "] clicked");
                    GPCalculator.this.calculate(actionEvent.getActionCommand());
                    return;
                }
            }
            if (actionEvent.getSource() == GPCalculator.this.display) {
                Debug.println(1, "plugin " + GPCalculator.this.getName() + " display [enter] clicked");
                GPCalculator.this.calculate("enter");
            }
        }
    }
}

