/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOToolkit;
import ch.laoe.operation.AOperation;
import ch.laoe.ui.Debug;
import ch.laoe.ui.LProgressViewer;

public class AOSpectrum
extends AOperation {
    private int windowType;
    private int convertBufferLength;
    private MMArray re;
    private MMArray im;
    private MMArray spectrum;

    public AOSpectrum(int n, int n2) {
        this.convertBufferLength = n;
        this.windowType = n2;
        this.re = new MMArray(this.convertBufferLength, 0.0f);
        this.im = new MMArray(this.convertBufferLength, 0.0f);
        this.spectrum = new MMArray(this.convertBufferLength / 2, 0.0f);
    }

    public MMArray getSpectrum() {
        return this.spectrum;
    }

    private void operateTWindow() {
        AOToolkit.applyFFTWindow(this.windowType, this.re, this.re.getLength());
    }

    private void addToSpectrum() {
        for (int i = 0; i < this.spectrum.getLength(); ++i) {
            this.spectrum.set(i, this.spectrum.get(i) + AOToolkit.cartesianToMagnitude(this.re.get(i), this.im.get(i)));
        }
    }

    private void reduceSpectrum(int n) {
        for (int i = 0; i < this.spectrum.getLength(); ++i) {
            this.spectrum.set(i, this.spectrum.get(i) / (float)n);
        }
    }

    @Override
    public final void operate(AChannelSelection aChannelSelection) {
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        try {
            int n3 = n2 / this.convertBufferLength + 1;
            LProgressViewer.getInstance().entrySubProgress(0.7);
            for (int i = 0; i < n3; ++i) {
                if (LProgressViewer.getInstance().setProgress((double)(i + 1) * 1.0 / (double)n3)) {
                    return;
                }
                for (int j = 0; j < this.convertBufferLength; ++j) {
                    int n4 = n + i * this.convertBufferLength + j;
                    if (n4 < n + n2) {
                        this.re.set(j, mMArray.get(n4));
                    } else {
                        this.re.set(j, 0.0f);
                    }
                    this.im.set(j, 0.0f);
                }
                this.operateTWindow();
                AOToolkit.complexFft(this.re, this.im);
                this.addToSpectrum();
            }
            this.reduceSpectrum(n3);
            LProgressViewer.getInstance().exitSubProgress();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Debug.printStackTrace(5, arrayIndexOutOfBoundsException);
        }
    }
}

