/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOFftBlockProcessing;
import ch.laoe.operation.AOToolkit;
import ch.laoe.operation.AOperation;

public class AOMultiPitch
extends AOperation
implements AOFftBlockProcessing.Processor {
    private AOFftBlockProcessing blockProcessing = new AOFftBlockProcessing(this);
    private MMArray tmpRe;
    private MMArray tmpIm;
    private float[] pitch;
    private float[] amplitude;

    public AOMultiPitch(float[] fArray, float[] fArray2, float f, float f2, int n, int n2, float f3) {
        this.blockProcessing.setFftBlockLength(n);
        this.blockProcessing.setFftWindowType(n2);
        this.blockProcessing.setOverlapFactor(f3);
        this.blockProcessing.setRmsAdaptionEnabled(true);
        this.blockProcessing.setZeroCrossEnabled(false);
        this.pitch = fArray;
        this.amplitude = fArray2;
        this.tmpRe = new MMArray(n / 2, 0.0f);
        this.tmpIm = new MMArray(n / 2, 0.0f);
    }

    @Override
    public void process(MMArray mMArray, MMArray mMArray2, int n, int n2) {
        this.tmpRe.clear();
        this.tmpIm.clear();
        for (int i = 0; i < this.pitch.length; ++i) {
            if (!(this.pitch[i] > 0.0f)) continue;
            for (int j = 0; j < n2; ++j) {
                float f = (float)j / this.pitch[i];
                if (f < (float)this.tmpRe.getLength()) {
                    this.tmpRe.set(j, this.tmpRe.get(j) + AOToolkit.interpolate3(mMArray, f) * this.amplitude[i]);
                }
                if (!(f < (float)this.tmpIm.getLength())) continue;
                this.tmpIm.set(j, this.tmpIm.get(j) + AOToolkit.interpolate3(mMArray2, f) * this.amplitude[i]);
            }
        }
        mMArray.copy(this.tmpRe, 0, 0, this.tmpRe.getLength());
        mMArray2.copy(this.tmpIm, 0, 0, this.tmpIm.getLength());
    }

    @Override
    public final void operate(AChannelSelection aChannelSelection) {
        this.blockProcessing.operate(aChannelSelection);
    }
}

