/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.operation;

import ch.laoe.clip.AChannelSelection;
import ch.laoe.clip.MMArray;
import ch.laoe.operation.AOFifo;
import ch.laoe.operation.AOToolkit;
import ch.laoe.operation.AOperation;
import ch.laoe.ui.LProgressViewer;

public class AOChorusFlange
extends AOperation {
    private float wet;
    private float dry;
    private float feedback;
    private float baseDelay;
    private float modulationDelay;
    private float modulationPeriod;
    private int modulationShape;
    private boolean negFeedback;
    public static final int SINUS = 1;
    public static final int TRIANGLE = 2;
    public static final int SAW = 3;

    public AOChorusFlange(float f, float f2, float f3, boolean bl, int n, int n2, int n3, int n4) {
        this.dry = f;
        this.wet = f2;
        this.feedback = f3;
        this.negFeedback = bl;
        this.baseDelay = n;
        this.modulationDelay = n2;
        this.modulationPeriod = n3;
        this.modulationShape = n4;
    }

    @Override
    public void operate(AChannelSelection aChannelSelection) {
        MMArray mMArray = aChannelSelection.getChannel().getSamples();
        int n = aChannelSelection.getOffset();
        int n2 = aChannelSelection.getLength();
        aChannelSelection.getChannel().markChange();
        AOFifo aOFifo = new AOFifo((int)(this.baseDelay + this.modulationDelay + 10.0f));
        LProgressViewer.getInstance().entrySubProgress(0.7);
        for (int i = n; i < n + n2; ++i) {
            if (LProgressViewer.getInstance().setProgress((double)(i + 1 - n) * 1.0 / (double)n2)) {
                return;
            }
            float f = this.baseDelay;
            switch (this.modulationShape) {
                case 1: {
                    f += (float)Math.sin((double)((float)(i % (int)this.modulationPeriod) / this.modulationPeriod * 2.0f) * Math.PI) * this.modulationDelay;
                    break;
                }
                case 2: {
                    f += (Math.abs((float)(i % (int)this.modulationPeriod) / this.modulationPeriod * 4.0f - 2.0f) - 1.0f) * this.modulationDelay;
                    break;
                }
                case 3: {
                    f += ((float)(i % (int)this.modulationPeriod) / this.modulationPeriod * 2.0f - 1.0f) * this.modulationDelay;
                }
            }
            float f2 = mMArray.get(i);
            if ((int)f < aOFifo.getActualSize() - 1) {
                aOFifo.put(f2 + aOFifo.pickFromHead(f - 1.0f) * this.feedback);
                f2 = this.negFeedback ? f2 * this.dry - aOFifo.pickFromHead(f) * this.wet : f2 * this.dry + aOFifo.pickFromHead(f) * this.wet;
            } else {
                aOFifo.put(f2);
                f2 *= this.dry;
            }
            mMArray.set(i, aChannelSelection.mixIntensity(i, mMArray.get(i), f2));
        }
        AOToolkit.applyZeroCross(mMArray, n);
        AOToolkit.applyZeroCross(mMArray, n + n2);
        LProgressViewer.getInstance().exitSubProgress();
    }
}

