/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.clip;

import ch.laoe.audio.Audio;
import ch.laoe.audio.AudioException;
import ch.laoe.clip.AClipHistory;
import ch.laoe.clip.AClipPlotter;
import ch.laoe.clip.AClipSelection;
import ch.laoe.clip.AContainerModel;
import ch.laoe.clip.ALayer;
import ch.laoe.clip.ALayerSelection;
import ch.laoe.operation.AOMix;
import ch.laoe.ui.GLanguage;
import ch.laoe.ui.GPersistence;
import ch.laoe.ui.LProgressViewer;
import java.io.File;

public class AClip
extends AContainerModel {
    private Audio audio;
    private static int uniqueIdIndex = 0;
    private String uniqueId;
    private AClipHistory history;
    private static int nameCounter;
    private String comments;
    private float sampleRate;
    private static final float DEFAULT_SAMPLE_RATE = 8000.0f;
    private int sampleWidth;
    private static final int DEFAULT_SAMPLE_WIDTH = 16;
    private boolean bigEndian;

    public AClip() {
        this.markChange();
        this.sampleRate = 8000.0f;
        this.sampleWidth = 16;
        this.comments = GPersistence.createPersistance().getString("clip.defaultComment");
        this.selection = new AClipSelection(this);
        this.plotter = new AClipPlotter(this);
    }

    public AClip(int n, int n2) {
        this();
        for (int i = 0; i < n; ++i) {
            this.add(new ALayer(n2));
        }
        this.audio = new Audio(this);
        this.history = new AClipHistory(this);
        this.history.store(GLanguage.translate("initialState"));
    }

    public AClip(int n, int n2, int n3) {
        this();
        for (int i = 0; i < n; ++i) {
            this.add(new ALayer(n2, n3));
        }
        this.audio = new Audio(this);
        this.history = new AClipHistory(this);
        this.history.store(GLanguage.translate("initialState"));
    }

    public AClip(AClip aClip) {
        this();
        this.sampleRate = aClip.sampleRate;
        this.sampleWidth = aClip.sampleWidth;
        this.comments = aClip.comments;
        this.name = aClip.name;
        this.selection = aClip.selection;
        for (int i = 0; i < aClip.getNumberOfLayers(); ++i) {
            this.add(new ALayer(aClip.getLayer(i)));
        }
        this.audio = new Audio(this);
        this.history = new AClipHistory(aClip.history, this);
    }

    public AClip(File file) throws AudioException {
        this();
        LProgressViewer.getInstance().entrySubProgress(0.6);
        if (LProgressViewer.getInstance().setProgress(0.1)) {
            return;
        }
        this.audio = new Audio(this);
        this.audio.open(file);
        this.history = new AClipHistory(this);
        this.history.store(GLanguage.translate("initialState"));
        LProgressViewer.getInstance().exitSubProgress();
    }

    @Override
    public void destroy() {
        LProgressViewer.getInstance().entrySubProgress(GLanguage.translate("cleanup") + " " + this.getName());
        LProgressViewer.getInstance().setNote(this.getName());
        super.destroy();
        if (this.audio != null) {
            this.audio.destroy();
        }
        this.audio = null;
        System.gc();
        LProgressViewer.getInstance().exitSubProgress();
    }

    public void copyAllAttributes(AClip aClip) {
        this.sampleRate = aClip.sampleRate;
        this.sampleWidth = aClip.sampleWidth;
        this.comments = aClip.comments;
        this.name = aClip.name;
        this.selection = aClip.selection;
    }

    public Audio getAudio() {
        return this.audio;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markChange() {
        AClip aClip = this;
        synchronized (aClip) {
        }
        this.uniqueId = "clip" + ++uniqueIdIndex;
    }

    public String getChangeId() {
        return this.uniqueId;
    }

    public AClipHistory getHistory() {
        return this.history;
    }

    @Override
    public AClipSelection getSelection() {
        return (AClipSelection)this.selection;
    }

    @Override
    public AClipPlotter getPlotter() {
        return (AClipPlotter)this.plotter;
    }

    public void setPlotType(int n) {
        for (int i = 0; i < this.getNumberOfLayers(); ++i) {
            this.getLayer(i).setPlotType(n);
        }
    }

    @Override
    public void setDefaultName() {
        this.setDefaultName("clip", nameCounter++);
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String string) {
        this.comments = string;
    }

    public void prepareMask() {
        for (int i = 0; i < this.getNumberOfLayers(); ++i) {
            this.getLayer(i).prepareMask();
        }
    }

    public ALayer getLayer(int n) {
        return (ALayer)this.get(n);
    }

    public void mergeDownLayer(int n) {
        if (this.getNumberOfElements() > 1 && n > 0) {
            ALayer aLayer = this.getLayer(n - 1);
            ALayer aLayer2 = this.getLayer(n);
            ALayerSelection aLayerSelection = aLayer.createSelection();
            ALayerSelection aLayerSelection2 = aLayer2.createSelection();
            AClipSelection aClipSelection = new AClipSelection(this);
            aClipSelection.addLayerSelection(aLayerSelection);
            aClipSelection.addLayerSelection(aLayerSelection2);
            aClipSelection.operateLayer0WithLayer1(new AOMix());
            this.remove(n);
            for (int i = 0; i < aLayer.getNumberOfChannels(); ++i) {
                aLayer.getChannel(i).getMask().clear();
            }
        }
    }

    public void mergeAllLayers() {
        while (this.getNumberOfElements() > 1) {
            this.mergeDownLayer(1);
        }
    }

    public ALayer getSelectedLayer() {
        return (ALayer)this.getSelected();
    }

    public int getNumberOfLayers() {
        return this.getNumberOfElements();
    }

    public int getMaxNumberOfChannels() {
        return this.getMaxNumberOfSubElements();
    }

    public int getMaxSampleLength() {
        int n = 0;
        for (int i = 0; i < this.getNumberOfElements(); ++i) {
            int n2 = this.getLayer(i).getMaxSampleLength();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public float getMaxSampleValue() {
        float f = 0.0f;
        for (int i = 0; i < this.getNumberOfElements(); ++i) {
            float f2 = this.getLayer(i).getMaxSampleValue();
            if (!(f2 > f)) continue;
            f = f2;
        }
        return f;
    }

    public float getMaxSampleValue(int n, int n2) {
        float f = 0.0f;
        for (int i = 0; i < this.getNumberOfElements(); ++i) {
            float f2 = this.getLayer(i).getMaxSampleValue(n, n2);
            if (!(f2 > f)) continue;
            f = f2;
        }
        return f;
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(float f) {
        this.sampleRate = f > 48000.0f ? 48000.0f : (f < 1000.0f ? 1000.0f : f);
        this.audio.changeSampleRate(f);
    }

    public int getSampleWidth() {
        return this.sampleWidth;
    }

    public void setSampleWidth(int n) {
        this.sampleWidth = n < 1 ? 1 : (n > 32 ? 32 : n);
    }

    public boolean isBigEndian() {
        return false;
    }

    public void setBigEndian(boolean bl) {
        this.bigEndian = bl;
    }
}

