/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.audio.play;

import ch.laoe.audio.play.APlay;
import javax.sound.sampled.AudioFormat;

public class APlayPcmUnsigned8Bit
extends APlay {
    private int samplePtr;
    private int channelPtr;
    private int bytePtr;
    private int markPtr;
    private float sample;

    public APlayPcmUnsigned8Bit() {
        this.dataBufferLength = 4000;
        this.data = new byte[this.dataBufferLength];
        this.samplePtr = 0;
        this.channelPtr = 0;
        this.bytePtr = 0;
    }

    @Override
    public APlay duplicate() {
        return new APlayPcmUnsigned8Bit();
    }

    @Override
    public boolean supports(AudioFormat audioFormat) {
        return audioFormat.getEncoding() == AudioFormat.Encoding.PCM_UNSIGNED && audioFormat.getSampleSizeInBits() == 8;
    }

    @Override
    public void mark(int n) {
        this.markPtr = this.samplePtr;
    }

    @Override
    public void reset() {
        this.samplePtr = this.markPtr;
    }

    @Override
    public void goTo(int n) {
        this.samplePtr = n;
        this.bytePtr = 0;
    }

    @Override
    public int read() {
        int n = 0;
        switch (this.bytePtr) {
            case 0: {
                this.sample = this.getSample(this.channelPtr, this.samplePtr);
                n = (int)this.sample & 0xFF ^ 0x7F;
                break;
            }
            case 1: {
                n = (int)this.sample >> 8 & 0xFF ^ 0x7F;
            }
        }
        ++this.bytePtr;
        this.bytePtr %= 1;
        if (this.bytePtr == 0) {
            ++this.channelPtr;
            this.channelPtr %= this.channels;
            if (this.channelPtr == 0) {
                ++this.samplePtr;
            }
        }
        if (this.samplePtr >= this.clip.getMaxSampleLength()) {
            return -1;
        }
        return n;
    }
}

