/*
 * Decompiled with CFR 0.152.
 */
package ch.laoe.audio.capture;

import ch.laoe.audio.capture.ACapture;
import ch.laoe.ui.Debug;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;

public class ACapturePcmUnsigned8Bit
extends ACapture {
    @Override
    public ACapture duplicate() {
        Debug.println(3, "capture PCM unsigned 8bit duplicated");
        return new ACapturePcmUnsigned8Bit();
    }

    @Override
    public boolean supports(AudioFormat audioFormat) {
        return audioFormat.getEncoding() == AudioFormat.Encoding.PCM_UNSIGNED && audioFormat.getSampleSizeInBits() == 8;
    }

    @Override
    public int read(int n, int n2) throws IOException {
        int n3 = line.read(this.buffer, 0, Math.min(this.buffer.length, n2 * this.channels));
        for (int i = 0; i < this.channels; ++i) {
            for (int j = 0; j < n3 / this.channels; ++j) {
                int n4 = j * this.channels + i;
                byte by = this.buffer[n4];
                this.layer.getChannel(i).setSample(n + j, by);
            }
        }
        if (n3 >= 0) {
            return n3 / this.channels;
        }
        return n3;
    }
}

