/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.xinput.topfield_raw;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.dvb.projectx.xinput.topfield_raw.RawReadIF;

public class RawFileInputStream
extends InputStream {
    private byte[] b = new byte[1];
    private String file;
    private int handle;
    private long currentpos;
    private RawReadIF rawread;

    public RawFileInputStream(RawReadIF rawReadIF, String string) throws FileNotFoundException {
        this.rawread = rawReadIF;
        this.file = string;
        this.handle = rawReadIF.openFile(this.file);
        this.currentpos = 0L;
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        n2 = this.rawread.readFile(this.handle, byArray, n, n2);
        this.currentpos += (long)n2;
        return n2;
    }

    public final int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public final int read() throws IOException {
        if (this.read(this.b, 0, 1) == 1) {
            return this.b[0];
        }
        return -1;
    }

    public final int available() throws IOException {
        long l = this.streamSize() - this.currentpos;
        if (l > 0xD000000L) {
            return 0xD000000;
        }
        return (int)l;
    }

    public final void mark(int n) {
    }

    public final void reset() throws IOException {
    }

    public final boolean markSupported() {
        return false;
    }

    public final long skip(long l) throws IOException {
        long l2 = this.rawread.skipBytes(this.handle, l);
        this.currentpos += l2;
        return l2;
    }

    public final long streamSize() throws IOException {
        return this.rawread.getFileSize(this.file);
    }

    public final void close() throws IOException {
        if (this.handle != 0) {
            this.rawread.closeFile(this.handle);
        }
        this.handle = 0;
    }
}

