/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.xinput.file;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.xinput.DirType;
import net.sourceforge.dvb.projectx.xinput.XInputDirectoryIF;
import net.sourceforge.dvb.projectx.xinput.XInputFile;
import net.sourceforge.dvb.projectx.xinput.file.XInputDirectoryImpl;

public class XInputDirectoryImpl
implements XInputDirectoryIF {
    private DirType dirType = null;
    private File file = null;
    private String testMsg = null;

    private XInputDirectoryImpl() {
        throw new UnsupportedOperationException("Usage is not allowed!");
    }

    public XInputDirectoryImpl(File file) {
        if (!file.exists() || !file.isDirectory()) {
            throw new IllegalArgumentException("aFile is not a directory!");
        }
        this.dirType = DirType.FILE_DIR;
        this.file = file;
    }

    public XInputDirectoryImpl(String string) {
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            throw new IllegalArgumentException("'" + string + "' is not a directory!");
        }
        this.dirType = DirType.FILE_DIR;
        this.file = file;
    }

    public String toString() {
        return this.file.getAbsolutePath();
    }

    public String getDirectory() {
        return this.file.getParent();
    }

    public String getPassword() {
        return "";
    }

    public String getServer() {
        return "";
    }

    public String getPort() {
        return "";
    }

    public String getUser() {
        return "";
    }

    public String getLog() {
        return "";
    }

    public XInputFile[] getFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        class MyFileFilter
        implements FileFilter {
            private final /* synthetic */ XInputDirectoryImpl this$0;

            MyFileFilter(XInputDirectoryImpl xInputDirectoryImpl) {
                this.this$0 = xInputDirectoryImpl;
            }

            public boolean accept(File file) {
                return file.isFile();
            }
        }
        File[] fileArray = this.file.listFiles(new MyFileFilter(this));
        int n = 0;
        while (n < fileArray.length) {
            arrayList.add(fileArray[n]);
            ++n;
        }
        if (Common.getSettings().getBooleanProperty(Keys.KEY_InputDirectoriesDepth)) {
            this.getDirectories(this.file, arrayList);
        }
        XInputFile[] xInputFileArray = new XInputFile[arrayList.size()];
        int n2 = 0;
        while (n2 < xInputFileArray.length) {
            xInputFileArray[n2] = new XInputFile((File)arrayList.get(n2));
            ++n2;
        }
        return xInputFileArray;
    }

    private void getDirectories(File file, ArrayList arrayList) {
        class MyDirFilter
        implements FileFilter {
            private final /* synthetic */ XInputDirectoryImpl this$0;

            MyDirFilter(XInputDirectoryImpl xInputDirectoryImpl) {
                this.this$0 = xInputDirectoryImpl;
            }

            public boolean accept(File file) {
                return file.isDirectory();
            }
        }
        File[] fileArray = file.listFiles(new MyDirFilter(this));
        int n = 0;
        while (n < fileArray.length) {
            class MyFileFilter
            implements FileFilter {
                private final /* synthetic */ XInputDirectoryImpl this$0;

                MyFileFilter(XInputDirectoryImpl xInputDirectoryImpl) {
                    this.this$0 = xInputDirectoryImpl;
                }

                public boolean accept(File file) {
                    return file.isFile();
                }
            }
            File[] fileArray2 = fileArray[n].listFiles(new MyFileFilter(this));
            int n2 = 0;
            while (n2 < fileArray2.length) {
                arrayList.add(fileArray2[n2]);
                ++n2;
            }
            this.getDirectories(fileArray[n], arrayList);
            ++n;
        }
    }

    public boolean test() {
        boolean bl = false;
        bl = this.file.exists() && this.file.isDirectory();
        this.testMsg = bl ? "Test succeeded" : "Test failed";
        return bl;
    }

    public String getTestMsg() {
        return this.testMsg;
    }

    public DirType getDirType() {
        return this.dirType;
    }
}

