/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.xinput;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Iterator;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.xinput.FileType;
import net.sourceforge.dvb.projectx.xinput.StreamInfo;
import net.sourceforge.dvb.projectx.xinput.XInputFileIF;

public class XInputFile
implements XInputFileIF {
    private XInputFileIF impl = null;
    private boolean debug = false;
    private Object constructorParameter = null;

    private XInputFile() {
        throw new UnsupportedOperationException();
    }

    public XInputFile(Object object) {
        if (this.debug) {
            System.out.println("Enter XInputFile(Object '" + object + "')");
        }
        Class[] classArray = new Class[]{object.getClass()};
        Object[] objectArray = new Object[]{object};
        this.retrieveImplementation(classArray, objectArray);
        this.constructorParameter = object;
        if (this.impl != null) {
            this.impl.setConstructorParameter(object);
        }
        if (this.debug) {
            System.out.println("Leave XInputFile(Object '" + object + "')");
        }
    }

    public XInputFile getNewInstance() {
        XInputFile xInputFile;
        if (this.debug) {
            System.out.println("Enter XInputFile.getNewInstance()");
        }
        if (this.impl != null) {
            this.constructorParameter = this.impl.getConstructorParameter();
        }
        if ((xInputFile = new XInputFile(this.constructorParameter)).getImpl() == null) {
            return null;
        }
        if (this.impl.getStreamInfo() != null) {
            xInputFile.setStreamInfo(this.impl.getStreamInfo().getNewInstance());
        }
        if (this.debug) {
            System.out.println("Leave XInputFile.getNewInstance() returning " + xInputFile);
        }
        return xInputFile;
    }

    private void retrieveImplementation(Class[] classArray, Object[] objectArray) {
        if (this.debug) {
            System.out.println("Enter XInputFile.retrieveImplementation(Class[] parameterTypes, Object[] parameterValues)");
        }
        FileType fileType = null;
        Iterator iterator = FileType.getFileTypes().iterator();
        while (iterator.hasNext()) {
            fileType = (FileType)iterator.next();
            if (fileType.equals(FileType.DEFAULT)) continue;
            try {
                if (this.debug) {
                    System.out.println("Try FileType '" + fileType.getName() + "'");
                }
                this.impl = (XInputFileIF)fileType.getImplementation().getConstructor(classArray).newInstance(objectArray);
                if (this.debug) {
                    System.out.println("Use FileType '" + fileType.getName() + "' for file '" + this.impl.toString() + "'");
                }
                if (this.debug) {
                    System.out.println("Leave XInputFile.retrieveImplementation(Class[] parameterTypes, Object[] parameterValues");
                }
                return;
            }
            catch (Exception exception) {
                this.impl = null;
            }
        }
        try {
            fileType = FileType.DEFAULT;
            if (this.debug) {
                System.out.println("Try default FileType '" + fileType.getName() + "'");
            }
            this.impl = (XInputFileIF)fileType.getImplementation().getConstructor(classArray).newInstance(objectArray);
            if (this.debug) {
                System.out.println("Use default FileType '" + fileType.getName() + "' for file '" + this.impl.toString() + "'");
            }
            if (this.debug) {
                System.out.println("Leave XInputFile.retrieveImplementation(Class[] parameterTypes, Object[] parameterValues)");
            }
            return;
        }
        catch (Exception exception) {
            this.impl = null;
            if (this.debug) {
                System.out.println("No matching FileType found or file doesn't exist");
            }
            if (this.debug) {
                System.out.println("Leave XInputFile.retrieveImplementation(Class[] parameterTypes, Object[] parameterValues)");
            }
            Common.setErrorMessage("No matching FileType found or file doesn't exist: '" + objectArray[0] + "'");
            Common.setExceptionMessage(exception);
            return;
        }
    }

    public void setConstructorParameter(Object object) {
        if (this.debug) {
            System.out.println("Enter XInputFile.setConstructorParameter(Object obj)'" + object + "'");
        }
        this.impl.setConstructorParameter(object);
        if (this.debug) {
            System.out.println("Leave XInputFile.setConstructorParameter(Object obj)");
        }
    }

    public Object getConstructorParameter() {
        if (this.debug) {
            System.out.println("Enter XInputFile.getConstructorParameter()");
        }
        Object object = this.impl.getConstructorParameter();
        if (this.debug) {
            System.out.println("Leave XInputFile.getConstructorParameter()'" + object + "'");
        }
        return object;
    }

    public boolean exists() {
        if (this.debug) {
            System.out.println("Enter XInputFile.exists()");
        }
        boolean bl = this.impl.exists();
        if (this.debug) {
            System.out.println("Leave XInputFile.exists() returning " + new Boolean(bl));
        }
        return bl;
    }

    public InputStream getInputStream() throws FileNotFoundException, MalformedURLException, IOException {
        if (this.debug) {
            System.out.println("Enter XInputFile.getInputStream()");
        }
        InputStream inputStream = null;
        try {
            inputStream = this.impl.getInputStream();
        }
        catch (IOException iOException) {
            if (this.debug) {
                System.out.println(iOException.getLocalizedMessage());
            }
            if (this.debug) {
                iOException.printStackTrace();
            }
            throw iOException;
        }
        if (this.debug) {
            System.out.println("Leave XInputFile.getInputStream() returning " + inputStream);
        }
        return inputStream;
    }

    public InputStream getInputStream(long l) throws FileNotFoundException, MalformedURLException, IOException {
        if (this.debug) {
            System.out.println("Enter XInputFile.getInputStream(long start_position)");
        }
        InputStream inputStream = null;
        try {
            inputStream = this.impl.getInputStream(l);
        }
        catch (IOException iOException) {
            if (this.debug) {
                System.out.println(iOException.getLocalizedMessage());
            }
            if (this.debug) {
                iOException.printStackTrace();
            }
            throw iOException;
        }
        if (this.debug) {
            System.out.println("Leave XInputFile.getInputStream(long start_position) returning " + inputStream);
        }
        return inputStream;
    }

    public String getName() {
        if (this.debug) {
            System.out.println("Enter XInputFile.getName()");
        }
        String string = this.impl.getName();
        if (this.debug) {
            System.out.println("Leave XInputFile.getName() returning " + string);
        }
        return string;
    }

    public String getParent() {
        if (this.debug) {
            System.out.println("Enter XInputFile.getParent()");
        }
        String string = this.impl.getParent();
        if (this.debug) {
            System.out.println("Leave XInputFile.getParent() returning " + string);
        }
        return string;
    }

    public String getUrl() {
        if (this.debug) {
            System.out.println("Enter XInputFile.getUrl()");
        }
        String string = this.impl.getUrl();
        if (this.debug) {
            System.out.println("Leave XInputFile.getUrl() returning " + string);
        }
        return string;
    }

    public int hashCode() {
        if (this.debug) {
            System.out.println("Enter XInputFile.hashCode()");
        }
        int n = this.impl.hashCode();
        if (this.debug) {
            System.out.println("Leave XInputFile.hashCode() returning " + n);
        }
        return n;
    }

    public long lastModified() {
        if (this.debug) {
            System.out.println("Enter XInputFile.lastModified()");
        }
        long l = this.impl.lastModified();
        if (this.debug) {
            System.out.println("Leave XInputFile.lastModified() returning " + l);
        }
        return l;
    }

    public boolean setLastModified() {
        if (this.debug) {
            System.out.println("Enter XInputFile.setLastModified()");
        }
        boolean bl = this.impl.setLastModified();
        if (this.debug) {
            System.out.println("Leave XInputFile.setLastModified() returning " + bl);
        }
        return bl;
    }

    public long length() {
        if (this.debug) {
            System.out.println("Enter XInputFile.length()");
        }
        long l = this.impl.length();
        if (this.debug) {
            System.out.println("Leave XInputFile.length() returning " + l);
        }
        return l;
    }

    public boolean rename() throws IOException {
        if (this.debug) {
            System.out.println("Enter XInputFile.rename()");
        }
        boolean bl = this.impl.rename();
        if (this.debug) {
            System.out.println("Leave XInputFile.rename() returning " + bl);
        }
        return bl;
    }

    public void randomAccessClose() throws IOException {
        if (this.debug) {
            System.out.println("Enter XInputFile.randomAccessClose()");
        }
        try {
            this.impl.randomAccessClose();
        }
        catch (IOException iOException) {
            if (this.debug) {
                System.out.println(iOException.getLocalizedMessage());
            }
            if (this.debug) {
                iOException.printStackTrace();
            }
            throw iOException;
        }
        if (this.debug) {
            System.out.println("Leave XInputFile.randomAccessClose()");
        }
    }

    public void randomAccessOpen(String string) throws IOException {
        if (this.debug) {
            System.out.println("Enter XInputFile.randomAccessOpen(String '" + string + "')");
        }
        try {
            this.impl.randomAccessOpen(string);
        }
        catch (IOException iOException) {
            if (this.debug) {
                System.out.println(iOException.getLocalizedMessage());
            }
            if (this.debug) {
                iOException.printStackTrace();
            }
            throw iOException;
        }
        if (this.debug) {
            System.out.println("Leave XInputFile.randomAccessOpen(String '" + string + "')");
        }
    }

    public int randomAccessRead() throws IOException {
        if (this.debug) {
            System.out.println("Enter XInputFile.randomAccessRead()");
        }
        int n = 0;
        try {
            n = this.impl.randomAccessRead();
        }
        catch (IOException iOException) {
            if (this.debug) {
                System.out.println(iOException.getLocalizedMessage());
            }
            if (this.debug) {
                iOException.printStackTrace();
            }
            throw iOException;
        }
        if (this.debug) {
            System.out.println("Leave XInputFile.randomAccessRead() returning " + n);
        }
        return n;
    }

    public int randomAccessRead(byte[] byArray) throws IOException {
        if (this.debug) {
            System.out.println("Enter XInputFile.randomAccessRead(byte[] aBuffer)");
        }
        int n = 0;
        try {
            n = this.impl.randomAccessRead(byArray);
        }
        catch (IOException iOException) {
            if (this.debug) {
                System.out.println(iOException.getLocalizedMessage());
            }
            if (this.debug) {
                iOException.printStackTrace();
            }
            throw iOException;
        }
        if (this.debug) {
            System.out.println("Leave XInputFile.randomAccessRead(byte[] aBuffer) returning " + n);
        }
        return n;
    }

    public int randomAccessRead(byte[] byArray, int n, int n2) throws IOException {
        if (this.debug) {
            System.out.println("Enter XInputFile.randomAccessRead(byte[] aBuffer, int aOffset, int aLength)");
        }
        int n3 = 0;
        try {
            n3 = this.impl.randomAccessRead(byArray, n, n2);
        }
        catch (IOException iOException) {
            if (this.debug) {
                System.out.println(iOException.getLocalizedMessage());
            }
            if (this.debug) {
                iOException.printStackTrace();
            }
            throw iOException;
        }
        if (this.debug) {
            System.out.println("Leave XInputFile.randomAccessRead(byte[] aBuffer, int aOffset, int aLength) returning " + n3);
        }
        return n3;
    }

    public String randomAccessReadLine() throws IOException {
        if (this.debug) {
            System.out.println("Enter XInputFile.randomAccessReadLine()");
        }
        String string = null;
        try {
            string = this.impl.randomAccessReadLine();
        }
        catch (IOException iOException) {
            if (this.debug) {
                System.out.println(iOException.getLocalizedMessage());
            }
            if (this.debug) {
                iOException.printStackTrace();
            }
            throw iOException;
        }
        if (this.debug) {
            System.out.println("Leave XInputFile.randomAccessReadLine() returning " + string);
        }
        return string;
    }

    public void randomAccessSeek(long l) throws IOException {
        if (this.debug) {
            System.out.println("Enter XInputFile.randomAccessSeek(long '" + l + "')");
        }
        try {
            this.impl.randomAccessSeek(l);
        }
        catch (IOException iOException) {
            if (this.debug) {
                System.out.println(iOException.getLocalizedMessage());
            }
            if (this.debug) {
                iOException.printStackTrace();
            }
            throw iOException;
        }
        if (this.debug) {
            System.out.println("Leave XInputFile.randomAccessSeek(long '" + l + "')");
        }
    }

    public long randomAccessGetFilePointer() throws IOException {
        if (this.debug) {
            System.out.println("Enter XInputFile.randomAccessGetFilePointer()");
        }
        long l = 0L;
        try {
            l = this.impl.randomAccessGetFilePointer();
        }
        catch (IOException iOException) {
            if (this.debug) {
                System.out.println(iOException.getLocalizedMessage());
            }
            if (this.debug) {
                iOException.printStackTrace();
            }
            throw iOException;
        }
        if (this.debug) {
            System.out.println("Leave XInputFile.randomAccessGetFilePointer() returning " + l);
        }
        return l;
    }

    public void randomAccessSingleRead(byte[] byArray, long l) throws IOException {
        if (this.debug) {
            System.out.println("Enter XInputFile.randomAccessSingleRead(byte[] aBuffer, long aPosition)");
        }
        try {
            this.impl.randomAccessSingleRead(byArray, l);
        }
        catch (IOException iOException) {
            if (this.debug) {
                System.out.println(iOException.getLocalizedMessage());
            }
            if (this.debug) {
                iOException.printStackTrace();
            }
            throw iOException;
        }
        if (this.debug) {
            System.out.println("Leave XInputFile.randomAccessSingleRead(byte[] aBuffer, long aPosition)");
        }
    }

    public void randomAccessWrite(byte[] byArray) throws IOException {
        if (this.debug) {
            System.out.println("Enter XInputFile.randomAccessWrite(byte[] aBuffer)");
        }
        try {
            this.impl.randomAccessWrite(byArray);
        }
        catch (IOException iOException) {
            if (this.debug) {
                System.out.println(iOException.getLocalizedMessage());
            }
            if (this.debug) {
                iOException.printStackTrace();
            }
            throw iOException;
        }
        if (this.debug) {
            System.out.println("Leave XInputFile.randomAccessWrite(byte[] aBuffer)");
        }
    }

    public long randomAccessReadLong() throws IOException {
        if (this.debug) {
            System.out.println("Enter XInputFile.readLong()");
        }
        long l = 0L;
        try {
            l = this.impl.randomAccessReadLong();
        }
        catch (IOException iOException) {
            if (this.debug) {
                System.out.println(iOException.getLocalizedMessage());
            }
            if (this.debug) {
                iOException.printStackTrace();
            }
            throw iOException;
        }
        if (this.debug) {
            System.out.println("Leave XInputFile.readLong() returning " + l);
        }
        return l;
    }

    public boolean equals(Object object) {
        if (this.debug) {
            System.out.println("Enter XInputFile.equals(Object '" + object + "')");
        }
        if (!(object instanceof XInputFile)) {
            if (this.debug) {
                System.out.println("Leave XInputFile.equals(Object '" + object + "') returning false");
            }
            return false;
        }
        XInputFile xInputFile = (XInputFile)object;
        if (xInputFile.getFileType().equals(this.getFileType()) && xInputFile.toString().equals(this.toString())) {
            if (this.debug) {
                System.out.println("Leave XInputFile.equals(Object '" + object + "') returning true");
            }
            return true;
        }
        if (this.debug) {
            System.out.println("Leave XInputFile.equals(Object '" + object + "') returning false");
        }
        return false;
    }

    public FileType getFileType() {
        if (this.debug) {
            System.out.println("Enter XInputFile.getFileType()");
        }
        FileType fileType = this.impl.getFileType();
        if (this.debug) {
            System.out.println("Leave XInputFile.getFileType() returning " + fileType);
        }
        return fileType;
    }

    public String toString() {
        if (this.debug) {
            System.out.println("Enter XInputFile.toString()");
        }
        String string = this.impl.toString();
        if (this.debug) {
            System.out.println("Leave XInputFile.toString() returning " + string);
        }
        return string;
    }

    public XInputFileIF getImpl() {
        return this.impl;
    }

    public void setStreamInfo(StreamInfo streamInfo) {
        if (this.impl != null) {
            this.impl.setStreamInfo(streamInfo);
        }
    }

    public StreamInfo getStreamInfo() {
        return this.impl != null ? this.impl.getStreamInfo() : null;
    }
}

