/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.xinput;

import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;

public class StreamInfo {
    private Object[] videostreams;
    private Object[] audiostreams;
    private Object[] teletextstreams;
    private Object[] subpicturestreams;
    private String file_name;
    private String file_date;
    private String file_size;
    private String file_type;
    private String file_location;
    private String file_playtime;
    private String file_source;
    private String additionals;
    private int streamtype;
    private Object[] pids;
    private byte[] videoheader;
    private String line_separator = System.getProperty("line.separator");

    public StreamInfo() {
        this.setStreamInfo("", "", "", "", "", "", "");
    }

    public StreamInfo(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this.setStreamInfo(string, string2, string3, string4, string5, string6, string7);
    }

    public StreamInfo(String string, String string2, String string3, String string4, String string5, String string6, String string7, Object[] objectArray, Object[] objectArray2, Object[] objectArray3, Object[] objectArray4) {
        this.setStreamInfo(string, string2, string3, string4, string5, string6, string7, objectArray, objectArray2, objectArray3, objectArray4);
    }

    public StreamInfo(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, Object[] objectArray, Object[] objectArray2, Object[] objectArray3, Object[] objectArray4, Object[] objectArray5, byte[] byArray) {
        this.streamtype = n;
        this.pids = objectArray5;
        this.videoheader = byArray;
        this.setStreamInfo(string, string2, string3, string4, string5, string6, string7, objectArray, objectArray2, objectArray3, objectArray4);
    }

    public void setStreamInfo(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this.setStreamInfo(string, string2, string3, string4, string5, string6, string7, null, null, null, null);
    }

    public void setStreamInfo(String string, String string2, String string3, String string4, String string5, String string6, String string7, Object[] objectArray, Object[] objectArray2, Object[] objectArray3, Object[] objectArray4) {
        this.videostreams = objectArray;
        this.audiostreams = objectArray2;
        this.teletextstreams = objectArray3;
        this.subpicturestreams = objectArray4;
        this.file_name = string3;
        this.file_date = string5;
        this.file_size = string6;
        this.file_type = string2;
        this.file_location = string4;
        this.file_playtime = string7;
        this.file_source = string;
    }

    public String getFileName() {
        return this.file_name;
    }

    public String getFileSourceBase() {
        return this.file_source;
    }

    public String getFileSource() {
        return "[" + this.getFileSourceBase() + "]";
    }

    public String getFileSourceAndName() {
        return this.getFileSource() + " - " + this.getFileName();
    }

    public String getFileDate() {
        return this.file_date;
    }

    public String getFileSize() {
        return this.file_size;
    }

    public String getFileType() {
        return this.file_type;
    }

    public String getFileLocation() {
        return this.file_location;
    }

    public String getPlaytime() {
        return this.file_playtime;
    }

    public Object[] getVideoStreams() {
        return this.videostreams;
    }

    public Object[] getAudioStreams() {
        return this.audiostreams;
    }

    public Object[] getTeletextStreams() {
        return this.teletextstreams;
    }

    public Object[] getSubpictureStreams() {
        return this.subpicturestreams;
    }

    public String getVideo() {
        return this.getString(this.getVideoStreams());
    }

    public String getAudio() {
        return this.getString(this.getAudioStreams());
    }

    public String getTeletext() {
        return this.getString(this.getTeletextStreams());
    }

    public String getSubpicture() {
        return this.getString(this.getSubpictureStreams());
    }

    public String getAdditionals() {
        return this.additionals;
    }

    private String getString(Object[] objectArray) {
        String string = "";
        if (objectArray == null || objectArray.length == 0) {
            return "n/a";
        }
        string = objectArray[0].toString();
        int n = 1;
        while (n < objectArray.length) {
            string = string + this.line_separator + objectArray[n].toString();
            ++n;
        }
        return string;
    }

    public String getFullInfo() {
        String string = "";
        string = string + Resource.getString("ScanInfo.Location") + this.line_separator;
        string = string + this.getFileSource() + " @ " + this.getFileLocation() + this.line_separator;
        string = string + Resource.getString("ScanInfo.Name") + this.line_separator;
        string = string + this.getFileName() + this.line_separator;
        string = string + Resource.getString("ScanInfo.Size") + this.line_separator;
        string = string + this.getFileSize() + this.line_separator;
        string = string + Resource.getString("ScanInfo.Date") + this.line_separator;
        string = string + this.getFileDate() + this.line_separator;
        string = string + this.line_separator;
        string = string + Resource.getString("ScanInfo.Type") + this.line_separator;
        string = string + this.getFileType() + this.line_separator;
        string = string + Resource.getString("ScanInfo.Video") + this.line_separator;
        string = string + this.getVideo() + this.line_separator;
        string = string + Resource.getString("ScanInfo.Audio") + this.line_separator;
        string = string + this.getAudio() + this.line_separator;
        string = string + Resource.getString("ScanInfo.Teletext") + this.line_separator;
        string = string + this.getTeletext() + this.line_separator;
        string = string + Resource.getString("ScanInfo.Subpicture") + this.line_separator;
        string = string + this.getSubpicture() + this.line_separator;
        string = string + Resource.getString("ScanInfo.Playtime") + this.line_separator;
        string = string + this.getPlaytime();
        return string;
    }

    public void setStreamType(int n) {
        this.streamtype = n;
        this.file_type = Keys.ITEMS_FileTypes[this.streamtype].toString();
    }

    public void setStreamType(int n, String string) {
        this.streamtype = n;
        this.file_type = Keys.ITEMS_FileTypes[this.streamtype].toString() + string;
    }

    public int getStreamType() {
        return this.streamtype;
    }

    public void setPIDs(Object[] objectArray) {
        this.pids = objectArray;
    }

    public int[] getPIDs() {
        int n = this.pids == null ? 0 : this.pids.length;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = Integer.parseInt(this.pids[n2].toString());
            ++n2;
        }
        return nArray;
    }

    public int[] getMediaPIDs() {
        int n = this.pids == null || this.pids.length == 0 ? 0 : this.pids.length - 1;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = Integer.parseInt(this.pids[1 + n2].toString());
            ++n2;
        }
        return nArray;
    }

    public void setVideoHeader(byte[] byArray) {
        if (byArray == null) {
            this.videoheader = null;
        } else {
            this.videoheader = new byte[12];
            System.arraycopy(byArray, 0, this.videoheader, 0, byArray.length);
        }
    }

    public byte[] getVideoHeader() {
        return this.videoheader;
    }

    private Object[] copyContent(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Object[] objectArray2 = new Object[objectArray.length];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray2.length);
        return objectArray2;
    }

    private byte[] copyContent(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public StreamInfo getNewInstance() {
        return new StreamInfo(this.streamtype, this.file_source, this.file_type, this.file_name, this.file_location, this.file_date, this.file_size, this.file_playtime, this.copyContent(this.videostreams), this.copyContent(this.audiostreams), this.copyContent(this.teletextstreams), this.copyContent(this.subpicturestreams), this.copyContent(this.pids), this.copyContent(this.videoheader));
    }
}

