/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.video;

import java.util.Arrays;
import net.sourceforge.dvb.projectx.common.Resource;

public final class WSS {
    private static boolean isPalplus = false;
    private static int[] pixels = new int[267];
    private static int a;
    private static String str;
    private static String format;
    private static String start;

    public WSS() {
        WSS.init(new int[0], 0);
    }

    public static void init(int[] nArray, int n) {
        str = null;
        format = "";
        if (nArray.length < 200) {
            return;
        }
        WSS.scale(nArray, n);
    }

    public static String getWSS() {
        return str;
    }

    public static boolean isPalPlus() {
        return isPalplus;
    }

    public static String getFormatInfo() {
        return format;
    }

    private static void scale(int[] nArray, int n) {
        Arrays.fill(pixels, 0);
        int n2 = 267;
        float f = 0.0f;
        float f2 = (float)n / (float)n2;
        int n3 = 0;
        while (f < (float)n && n3 < n2) {
            WSS.pixels[n3] = 0xFF & nArray[(int)f] >>> 16;
            f += f2;
            ++n3;
        }
        a = 0;
        WSS.handlepixels("line 0 (23)");
        if (str == null) {
            f = 0.0f;
            int n4 = 0;
            while (f < (float)n && n4 < n2) {
                WSS.pixels[n4] = 0xFF & nArray[n + (int)f] >>> 16;
                f += f2;
                ++n4;
            }
            a = 0;
            WSS.handlepixels("line 1 (335)");
        }
    }

    private static void handlepixels(String string) {
        isPalplus = false;
        format = "";
        str = "WSS status @ " + string;
        str = str + ":<p>";
        if (WSS.getRunIn()) {
            str = str + Resource.getString("wss.run_in") + " @ " + a + "<p>";
            a += 29;
            if (WSS.getStartCode()) {
                str = str + Resource.getString("wss.startcode") + " @ " + a + "<p>";
                str = str + Resource.getString("wss.group_1") + " " + start + " @ " + (a += 24) + " :" + "<p>";
                str = str + " * " + WSS.getGroup1() + "<p>";
                str = str + Resource.getString("wss.group_2") + " " + start + " @ " + (a += 24) + " :" + "<p>";
                String[] stringArray = WSS.getGroup2();
                int n = 0;
                while (n < stringArray.length) {
                    str = str + " * " + stringArray[n] + "<p>";
                    ++n;
                }
                str = str + Resource.getString("wss.group_3") + " " + start + " @ " + (a += 24) + " :" + "<p>";
                stringArray = WSS.getGroup3();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    str = str + " * " + stringArray[n2] + "<p>";
                    ++n2;
                }
                str = str + Resource.getString("wss.group_4") + " " + start + " @ " + (a += 18) + " :" + "<p>";
                stringArray = WSS.getGroup4();
                int n3 = 0;
                while (n3 < stringArray.length) {
                    str = str + " * " + stringArray[n3] + "<p>";
                    ++n3;
                }
            } else {
                str = str + Resource.getString("wss.no_startcode");
            }
        } else {
            str = str + Resource.getString("wss.no_run_in");
            str = null;
        }
        a = 0;
    }

    private static boolean getRunIn() {
        while (a < 30) {
            if (pixels[a] > 120 && pixels[a + 2] >= 120 && pixels[a + 5] < 120 && pixels[a + 8] >= 120 && pixels[a + 11] < 120 && pixels[a + 14] >= 120 && pixels[a + 17] < 120 && pixels[a + 20] >= 120 && pixels[a + 23] < 120 && pixels[a + 26] >= 120) {
                return true;
            }
            ++a;
        }
        return false;
    }

    private static boolean getStartCode() {
        return pixels[a] < 120 && pixels[a + 3] >= 120 && pixels[a + 7] < 120 && pixels[a + 10] >= 120 && pixels[a + 14] < 120 && pixels[a + 19] >= 120;
    }

    private static String getGroup1() {
        int n = 0;
        int n2 = 0;
        while (n2 < 8) {
            n |= pixels[a + 3 * n2] < 120 ? 0 : 1 << 7 - n2;
            ++n2;
        }
        switch (n) {
            case 86: {
                format = "[4:3 full]";
                return "  " + Resource.getString("wss.group_1.0001");
            }
            case 149: {
                format = "[14:9 LB center]";
                return "  " + Resource.getString("wss.group_1.1000");
            }
            case 101: {
                format = "[14:9 LB top]";
                return "  " + Resource.getString("wss.group_1.0100");
            }
            case 166: {
                format = "[16:9 LB center]";
                return "  " + Resource.getString("wss.group_1.1101");
            }
            case 89: {
                format = "[16:9 LB top]";
                return "  " + Resource.getString("wss.group_1.0010");
            }
            case 106: {
                format = "[14:9 full]";
                return "  " + Resource.getString("wss.group_1.0111");
            }
            case 169: {
                format = "[16:9 full]";
                return "  " + Resource.getString("wss.group_1.1110");
            }
        }
        return "  " + Resource.getString("wss.group_1.error");
    }

    private static String[] getGroup2() {
        int n = 0;
        int n2 = 0;
        while (n2 < 8) {
            n |= pixels[a + 3 * n2] < 120 ? 0 : 1 << 7 - n2;
            ++n2;
        }
        String[] stringArray = new String[4];
        switch (n >>> 6) {
            case 1: {
                stringArray[0] = "  " + Resource.getString("wss.group_2.0.01");
                break;
            }
            case 2: {
                stringArray[0] = "  " + Resource.getString("wss.group_2.0.10");
                break;
            }
            default: {
                stringArray[0] = "  " + Resource.getString("wss.group_2.0.00");
            }
        }
        switch (3 & n >>> 4) {
            case 1: {
                stringArray[1] = "  " + Resource.getString("wss.group_2.1.01");
                break;
            }
            case 2: {
                stringArray[1] = "  " + Resource.getString("wss.group_2.1.10");
                break;
            }
            default: {
                stringArray[1] = "  " + Resource.getString("wss.group_2.1.00");
            }
        }
        switch (3 & n >>> 2) {
            case 1: {
                stringArray[2] = "  " + Resource.getString("wss.group_2.2.01");
                break;
            }
            case 2: {
                stringArray[2] = "  " + Resource.getString("wss.group_2.2.10");
                isPalplus = true;
                break;
            }
            default: {
                stringArray[2] = "  " + Resource.getString("wss.group_2.2.00");
            }
        }
        switch (3 & n) {
            case 1: {
                stringArray[3] = "  " + Resource.getString("wss.group_2.3.01");
                break;
            }
            case 2: {
                stringArray[3] = "  " + Resource.getString("wss.group_2.3.10");
                break;
            }
            default: {
                stringArray[3] = "  " + Resource.getString("wss.group_2.3.00");
            }
        }
        return stringArray;
    }

    private static String[] getGroup3() {
        int n = 0;
        int n2 = 0;
        while (n2 < 6) {
            n |= pixels[a + 3 * n2] < 120 ? 0 : 1 << 5 - n2;
            ++n2;
        }
        String[] stringArray = new String[2];
        switch (3 & n >>> 4) {
            case 1: {
                stringArray[0] = "  " + Resource.getString("wss.group_3.0.01");
                break;
            }
            case 2: {
                stringArray[0] = "  " + Resource.getString("wss.group_3.0.10");
                format = format + "[UT]";
                break;
            }
            default: {
                stringArray[0] = "  " + Resource.getString("wss.group_3.0.00");
            }
        }
        switch (0xF & n) {
            case 5: {
                stringArray[1] = "  " + Resource.getString("wss.group_3.1.00");
                break;
            }
            case 6: {
                stringArray[1] = "  " + Resource.getString("wss.group_3.1.01");
                break;
            }
            case 9: {
                stringArray[1] = "  " + Resource.getString("wss.group_3.1.10");
                break;
            }
            case 10: {
                stringArray[1] = "  " + Resource.getString("wss.group_3.1.11");
                break;
            }
            default: {
                stringArray[1] = "  " + Resource.getString("wss.group_3.1.err");
            }
        }
        return stringArray;
    }

    private static String[] getGroup4() {
        int n = 0;
        int n2 = 0;
        while (n2 < 6) {
            n |= pixels[a + 3 * n2] < 120 ? 0 : 1 << 5 - n2;
            ++n2;
        }
        String[] stringArray = new String[3];
        switch (3 & n >>> 4) {
            case 1: {
                stringArray[0] = "  " + Resource.getString("wss.group_4.0.01");
                break;
            }
            case 2: {
                stringArray[0] = "  " + Resource.getString("wss.group_4.0.10");
                break;
            }
            default: {
                stringArray[0] = "  " + Resource.getString("wss.group_4.0.00");
            }
        }
        switch (3 & n >>> 2) {
            case 1: {
                stringArray[1] = "  " + Resource.getString("wss.group_4.1.01");
                break;
            }
            case 2: {
                stringArray[1] = "  " + Resource.getString("wss.group_4.1.10");
                break;
            }
            default: {
                stringArray[1] = "  " + Resource.getString("wss.group_4.1.00");
            }
        }
        switch (3 & n) {
            case 1: {
                stringArray[2] = "  " + Resource.getString("wss.group_4.2.01");
                break;
            }
            case 2: {
                stringArray[2] = "  " + Resource.getString("wss.group_4.2.10");
                break;
            }
            default: {
                stringArray[2] = "  " + Resource.getString("wss.group_4.2.00");
            }
        }
        return stringArray;
    }

    static {
        start = Resource.getString("wss.start");
    }
}

