/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.subtitle;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.parser.CommonParsing;
import net.sourceforge.dvb.projectx.subtitle.Bitmap;
import net.sourceforge.dvb.projectx.subtitle.DVBSubpicture;

public class Subpicture {
    private int w = 720;
    private int h = 576;
    private int x = 20;
    private int nibble = 0;
    private int val = 0;
    private int default_alpha = 10;
    private int modified_alpha = 0;
    private BufferedImage bimg;
    private Graphics2D big;
    private Font font;
    private Font font_std;
    private FontRenderContext frc;
    private final int[] default_teletext_colors = new int[]{-10461088, -1351584, -15668464, -1316080, -11513621, -1351445, -15668245, -1315861, -10461088, -2072480, -10428320, -2039712, -10460960, -2072352, -10428192, -2039584, -9408400, -3116944, -9383824, -3092368, -9408304, -3116848, -9383728, -3092272, -8355712, -4161408, -8339328, -4145024, -8355648, -4161344, -8339264, -4144960, -7303024, -4157296, -7290736, -4145008, -7302976, -4157248, -7290688, -5197648, -6250336, -5201760, -6246240, -5197664, -6250320, -5201744, -6246224, -6250336, -5197648, -4153184, -6238048, -4140896, -6250288, -3104560, -6238000, -7303024, -3092272, -2060144, -7282544, -2039664, -7302944, -2060064, -7282464, -8355712, 0, 128};
    private final int[] default_sup_colors = new int[]{-15724528, -6250336, -1315861, -10461088, -1372144, -15668464, -1316080, -15724309, -1371925, -15668245, -1343360, -8328320, -1315968, -8355605, -1343253, -8328213, 0};
    private Object[] str = new Object[0];
    private byte[] RLEheader = new byte[]{83, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private byte[] sections = new byte[]{0, 0, 3, 50, 16, 4, -1, -6, 5, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 1, -1, 1, 80, 0, 0, 2, -1};
    private ByteArrayOutputStream out = new ByteArrayOutputStream();
    private byte[] newline = new byte[]{0, 0};
    private int[] Rect = new int[4];
    private int[] pos = new int[4];
    private int[] option = new int[11];
    private int[] standard_values = new int[]{26, 10, 32, 80, 560, 720, 576, -1, 4, 3, 1};
    private int isforced_status = 0;
    private int line_offset = 28;
    private ArrayList user_color_table = new ArrayList();
    private Bitmap bitmap;
    private boolean read_from_Image = false;
    private boolean global_error = false;
    private int X_Offset = 0;
    private int Y_Offset = 0;
    private int DisplayMode = 0;
    public DVBSubpicture dvb = new DVBSubpicture();

    public Subpicture() {
        this.bimg = new BufferedImage(this.w, this.h, 1);
        this.big = this.bimg.createGraphics();
        this.set("Tahoma", "26;10;32;80;560;720;576;-1;4;3;1");
        this.frc = this.big.getFontRenderContext();
    }

    public void repaint() {
        if (this.big == null) {
            return;
        }
        Common.getGuiInterface().repaintSubpicture();
    }

    public Image getImage() {
        return this.bimg;
    }

    public Image getScaledImage() {
        return this.bimg.getScaledInstance(384, 288, 2);
    }

    public void paintPicture(byte[] byArray, int n, int n2, int n3, int n4, int n5) {
        this.big.setColor(Color.gray);
        this.big.fillRect(0, 0, 720, 576);
        this.repaint();
    }

    public void showPicTTX(Object[] objectArray, Object object) {
        this.str = objectArray;
        this.buildImgTTX(object);
        this.repaint();
    }

    public byte[] setTime(byte[] byArray, long l) {
        long l2 = 0L;
        int n = 0;
        while (n < 4) {
            l2 |= (long)((0xFF & byArray[n + 2]) << n * 8);
            ++n;
        }
        long l3 = 1L + (l - l2) / 1024L;
        int n2 = (0xFF & byArray[12]) << 8 | 0xFF & byArray[13];
        byArray[34 + n2] = (byte)(0xFFL & l3 >>> 8);
        byArray[35 + n2] = (byte)(0xFFL & l3);
        Common.getGuiInterface().setSubpictureTitle(" / " + Resource.getString("subpicture.in_time") + ": " + Common.formatTime_1(l2 / 90L) + " " + Resource.getString("subpicture.duration") + ": " + Common.formatTime_1((l - l2) / 90L));
        return byArray;
    }

    private void buildImgTTX(Object object) {
        boolean bl;
        int n;
        int n2;
        int n3 = 6;
        this.Rect[0] = this.option[3];
        this.Rect[3] = 2 * n3 + this.line_offset * this.str.length;
        this.Rect[1] = this.option[6] - this.option[2] - this.Rect[3];
        this.Rect[2] = this.option[4];
        this.pos[0] = this.Rect[0];
        this.pos[1] = this.Rect[1];
        this.pos[2] = this.Rect[0] + this.Rect[2] - 1;
        this.pos[3] = this.Rect[1] + this.Rect[3] - 1;
        this.paintVideoSize(object);
        this.big.setColor(Color.white);
        this.big.drawRect(this.Rect[0] - 1, this.Rect[1] - 1, this.Rect[2] + 1, this.Rect[3] + 1);
        this.big.setFont(this.font_std);
        this.big.drawString("x" + this.pos[0] + ", y" + this.pos[1] + " / " + (this.pos[2] - this.pos[0] + 1) + "*" + (this.pos[3] - this.pos[1] + 1), this.Rect[0] - 1, this.Rect[1] - 5);
        int[] nArray = this.getColorTable(1);
        this.big.setFont(this.font);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n4 = 0;
        while (n4 < this.str.length) {
            int[] nArray2 = (int[])this.str[n4];
            n2 = 0;
            while (n2 < nArray2.length) {
                n = (7 & nArray2[n2] >>> 4) << 3;
                int n5 = nArray[n + (7 & nArray2[n2])];
                String string = Integer.toString(n5);
                String string2 = new Character((char)(nArray2[n2] >>> 8)).toString();
                if (arrayList.indexOf(string) < 0 && !string2.equals(" ")) {
                    arrayList.add(string);
                }
                ++n2;
            }
            ++n4;
        }
        if (arrayList.size() < 3 && Common.getSettings().getBooleanProperty(Keys.KEY_SubtitlePanel_useTextOutline)) {
            this.big.setColor(new Color(nArray[65]));
            this.modified_alpha = 0;
            bl = true;
        } else {
            this.big.setColor(new Color(nArray[64]));
            this.modified_alpha = this.default_alpha;
            bl = false;
        }
        this.big.fillRect(this.Rect[0], this.Rect[1], this.Rect[2], this.Rect[3]);
        n2 = 0;
        while (bl && n2 < this.str.length) {
            int[] nArray3 = (int[])this.str[n2];
            String string = "";
            this.big.setColor(new Color(nArray[64]));
            int n6 = 0;
            while (n6 < nArray3.length) {
                string = string + new Character((char)(nArray3[n6] >>> 8)).toString();
                ++n6;
            }
            this.x = this.option[3];
            int n7 = this.Rect[1] + this.line_offset * (1 + n2);
            int[] nArray4 = new int[this.option[9] * 2 + 1];
            int n8 = this.option[9] - 1;
            nArray4[nArray4.length - 1] = n8;
            nArray4[0] = n8;
            Arrays.fill(nArray4, 1, nArray4.length - 1, this.option[9]);
            int n9 = 0;
            while (n9 < nArray4.length) {
                int n10 = this.x;
                int n11 = n7 - nArray4.length / 2 + n9;
                int n12 = -nArray4[n9];
                while (n12 < nArray4[n9] + 1) {
                    this.big.drawString(string, n10 + n12, n11);
                    ++n12;
                }
                ++n9;
            }
            ++n2;
        }
        n = 0;
        while (n < this.str.length) {
            int[] nArray5 = (int[])this.str[n];
            this.x = this.option[3];
            int n13 = 0;
            while (n13 < nArray5.length) {
                int n14 = (7 & nArray5[n13] >>> 4) << 3;
                this.big.setColor(new Color(nArray[n14 + (7 & nArray5[n13])]));
                this.big.drawString("" + (char)(nArray5[n13] >>> 8), this.x, this.Rect[1] + this.line_offset * (1 + n));
                this.x = (int)((double)this.x + this.font.getStringBounds("" + (char)(nArray5[n13] >>> 8), this.frc).getWidth());
                ++n13;
            }
            ++n;
        }
    }

    public void resetUserColorTable() {
        this.user_color_table.clear();
    }

    public Object[] getUserColorTableArray() {
        return this.user_color_table.toArray();
    }

    public ArrayList getUserColorTable() {
        return this.user_color_table;
    }

    public void updateUserColorTable(Bitmap bitmap) {
        this.bitmap = bitmap;
        int[] nArray = this.bitmap.getPixel();
        int n = 0;
        while (n < nArray.length) {
            String string = "" + nArray[n];
            if (!this.user_color_table.contains(string)) {
                this.user_color_table.add(string);
            }
            this.bitmap.getColorIndex(this.getUserColorTableIndex(nArray[n]));
            ++n;
        }
    }

    private void updateUserColorTable(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            String string = "" + nArray[n];
            if (!this.user_color_table.contains(string)) {
                this.user_color_table.add(string);
            }
            ++n;
        }
    }

    private int getUserColorTableIndex(int n) {
        int n2 = this.user_color_table.indexOf("" + n);
        if (n2 < 0) {
            return 0;
        }
        return n2;
    }

    public byte[] writeRLE(long l, int n) throws IOException {
        this.read_from_Image = true;
        this.bitmap = new Bitmap(this.Rect[0], this.Rect[1], this.Rect[2], this.Rect[3], this.bimg.getRGB(this.Rect[0], this.Rect[1], this.Rect[2], this.Rect[3], null, 0, this.Rect[2]), 2, 0, 1, 2, l, n);
        return this.buildRLE();
    }

    public byte[] writeRLE(Bitmap bitmap) throws IOException {
        this.bitmap = bitmap;
        this.setArea();
        return this.buildRLE();
    }

    private byte[] buildRLE() {
        byte[] byArray = null;
        try {
            int[] nArray = this.bitmap.getPixel();
            this.updateUserColorTable(nArray);
            this.out.reset();
            this.out.write(this.RLEheader);
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n2 < 2) {
                n3 = 0;
                n6 = 0;
                n4 = n2 * this.bitmap.getWidth();
                while (n4 < nArray.length) {
                    n3 = 0;
                    n6 = 0;
                    n5 = 0;
                    while (n5 < this.bitmap.getWidth()) {
                        if (nArray[n4 + n5] != n6) {
                            this.updateRLE(n3, n6);
                            n6 = nArray[n4 + n5];
                            n3 = 0;
                        } else if (n3 > 254) {
                            this.updateRLE(n3, n6);
                            n3 = 0;
                        }
                        ++n5;
                        ++n3;
                    }
                    --n3;
                    while (n3 > 255) {
                        this.updateRLE(255, n6);
                        n3 -= 255;
                    }
                    this.updateRLE(n3, n6);
                    this.alignRLE();
                    this.out.write(this.newline);
                    n4 += 2 * this.bitmap.getWidth();
                }
                this.alignRLE();
                if (n == 0) {
                    n = this.out.size() - 10;
                }
                ++n2;
            }
            this.out.write(this.newline);
            int n7 = this.out.size() - 12;
            int n8 = n7 + 24;
            int n9 = this.out.size() + 22;
            this.setScreenPosition(this.bitmap.getX(), this.bitmap.getY(), this.bitmap.getMaxX() - 1, this.bitmap.getMaxY() - 1);
            this.setControlBlockPosition(n8, n);
            this.setPGCsection();
            this.out.write(this.sections);
            if ((this.out.size() & 1) == 1) {
                this.out.write(-1);
            }
            this.out.flush();
            byArray = this.out.toByteArray();
            int n10 = byArray.length - 10;
            byArray[10] = (byte)(0xFF & n10 >>> 8);
            byArray[11] = (byte)(0xFF & n10);
            byArray[12] = (byte)(0xFF & n7 >>> 8);
            byArray[13] = (byte)(0xFF & n7);
            int n11 = 0;
            while (n11 < 4) {
                byArray[n11 + 2] = (byte)(0xFFL & this.bitmap.getInTime() >>> n11 * 8);
                ++n11;
            }
            byArray[n9] = (byte)(0xFF & this.bitmap.getPlayTime() >>> 8);
            byArray[n9 + 1] = (byte)(0xFF & this.bitmap.getPlayTime());
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
        this.read_from_Image = false;
        return byArray;
    }

    private void alignRLE() {
        if (this.nibble == 0) {
            return;
        }
        this.out.write((byte)this.val);
        this.nibble = 0;
        this.val = 0;
    }

    private void updateRLE(int n, int n2) {
        if (n < 1) {
            return;
        }
        int n3 = this.getUserColorTableIndex(n2);
        n3 = this.bitmap.getColorIndex(n3);
        n = n << 2 | n3;
        if (this.nibble == 0) {
            if (n > 255) {
                this.out.write((byte)(0xFF & n >>> 8));
                this.out.write((byte)(0xFF & n));
            } else if (n > 63) {
                this.out.write((byte)(0xFF & n >>> 4));
                this.val = 0xF0 & n << 4;
                this.nibble = 4;
            } else if (n > 15) {
                this.out.write((byte)(0xFF & n));
            } else {
                this.val = 0xF0 & n << 4;
                this.nibble = 4;
            }
        } else if (n > 255) {
            this.out.write((byte)(this.val | 0xF & n >>> 12));
            this.out.write((byte)(0xFF & n >>> 4));
            this.val = 0xF0 & n << 4;
        } else if (n > 63) {
            this.out.write((byte)(this.val | 0xF & n >>> 8));
            this.out.write((byte)(0xFF & n));
            this.nibble = 0;
            this.val = 0;
        } else if (n > 15) {
            this.out.write((byte)(this.val | 0xF & n >>> 4));
            this.val = 0xF0 & n << 4;
        } else {
            this.out.write((byte)(this.val | 0xF & n));
            this.nibble = 0;
            this.val = 0;
        }
    }

    private void setScreenPosition(int n, int n2, int n3, int n4) {
        this.sections[9] = (byte)(n >>> 4);
        this.sections[10] = (byte)(n << 4 | n3 >>> 8);
        this.sections[11] = (byte)n3;
        this.sections[12] = (byte)(n2 >>> 4);
        this.sections[13] = (byte)(n2 << 4 | n4 >>> 8);
        this.sections[14] = (byte)n4;
    }

    private void setControlBlockPosition(int n, int n2) {
        this.sections[16] = 0;
        this.sections[17] = 4;
        this.sections[18] = (byte)(0xFF & n2 >>> 8);
        this.sections[19] = (byte)(0xFF & n2);
        this.sections[0] = this.sections[24] = (byte)(0xFF & n >>> 8);
        this.sections[1] = this.sections[25] = (byte)(0xFF & n);
    }

    private void setPGCsection() {
        int n = this.setPGClinks();
        this.sections[3] = (byte)(0xFF & n >>> 8);
        this.sections[4] = (byte)(0xFF & n);
        this.sections[6] = (byte)(0xFF & n >>> 24);
        this.sections[7] = (byte)(0xFF & n >>> 16);
    }

    public int setPGClinks() {
        Object[] objectArray = this.bitmap.getColorIndices();
        Object[] objectArray2 = this.getUserColorTableArray();
        int n = 65040;
        int n2 = 65529;
        int n3 = 0;
        while (n3 < 4) {
            if (n3 < objectArray.length) {
                int n4 = 0xF & Integer.parseInt(objectArray[n3].toString());
                int n5 = 0xF & Integer.parseInt(objectArray2[n4].toString()) >>> 28;
                n = n & ~(15 << n3 * 4) | n4 << n3 * 4;
                n2 = n2 & ~(15 << n3 * 4) | n5 << n3 * 4;
            }
            ++n3;
        }
        if (this.read_from_Image) {
            n2 &= 0xFFF0 | this.modified_alpha;
        }
        return n2 << 16 | n;
    }

    public void set2() {
        this.option[2] = this.option[7];
    }

    public int getMaximumLines() {
        return this.option[8];
    }

    public int[] set(String string, String string2) {
        this.resetUserColorTable();
        System.arraycopy(this.standard_values, 0, this.option, 0, this.standard_values.length);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        int n = 0;
        while (stringTokenizer.hasMoreTokens() && n < this.option.length) {
            this.option[n] = Integer.parseInt(stringTokenizer.nextToken());
            ++n;
        }
        this.line_offset = this.option[0] + 2;
        this.default_alpha = 0xF & this.option[1];
        this.font = new Font(string, this.option[10] == 0 ? 0 : 1, this.option[0]);
        this.font_std = new Font("Tahoma", 0, 14);
        int[] nArray = new int[]{this.option[2], this.option[7]};
        return nArray;
    }

    private int[] getColorTable(int n) {
        if (n == 0) {
            return this.default_sup_colors;
        }
        return this.default_teletext_colors;
    }

    private void setArea() {
        this.Rect[0] = this.bitmap.getX();
        this.Rect[1] = this.bitmap.getY();
        this.Rect[2] = this.bitmap.getWidth();
        this.Rect[3] = this.bitmap.getHeight();
        this.pos[0] = this.bitmap.getX();
        this.pos[1] = this.bitmap.getY();
        this.pos[2] = this.bitmap.getMaxX();
        this.pos[3] = this.bitmap.getMaxY();
    }

    public String getArea() {
        String string = "";
        string = string + "x " + this.Rect[0];
        string = string + " y " + this.Rect[1];
        string = string + " w " + this.Rect[2];
        string = string + " h " + this.Rect[3];
        string = string + " x1 " + this.pos[0];
        string = string + " y1 " + this.pos[1];
        string = string + " x2 " + this.pos[2];
        string = string + " y2 " + this.pos[3];
        return string;
    }

    private int paintVideoSize(Object object) {
        String[] stringArray = (String[])object;
        int n = 720;
        int n2 = 576;
        n = stringArray[0] == null ? 720 : Integer.parseInt(stringArray[0]);
        n2 = stringArray[1] == null ? 576 : Integer.parseInt(stringArray[1]);
        this.big.setColor(new Color(-11206656));
        this.big.fillRect(0, 0, this.w, this.h);
        this.big.setColor(Color.gray);
        this.big.fillRect(0, 0, n, n2);
        return n2;
    }

    private void Set_Bits(byte[] byArray, int[] nArray, int n, int n2) {
        int n3 = nArray[1] >>> 3;
        int n4 = nArray[1] & 7;
        if (n3 >= byArray.length || n4 + n >= (nArray[1] & 0xFFFFFFF8) + 32) {
            this.global_error = true;
        } else {
            int n5 = 1 + (n4 + n - 1 >>> 3);
            int n6 = n5 << 3;
            int n7 = CommonParsing.getIntValue(byArray, n3, n5, false);
            int n8 = -1 >>> 32 - n;
            int n9 = n6 - n - n4;
            n7 &= ~(n8 <<= n9);
            CommonParsing.setValue(byArray, n3, n5, false, n7 |= (n2 <<= n9) & n8);
        }
        nArray[1] = nArray[1] + n;
        nArray[0] = nArray[1] >>> 3;
    }

    private int Get_Bits(byte[] byArray, int[] nArray, int n) {
        int n2 = nArray[1] >>> 3;
        if (n2 >= byArray.length) {
            this.global_error = true;
            nArray[1] = nArray[1] + n;
            nArray[0] = nArray[1] >>> 3;
            return 0;
        }
        int n3 = (0xFF & byArray[n2++]) << 24;
        if (n2 < byArray.length) {
            n3 |= (0xFF & byArray[n2++]) << 16;
        }
        if (n2 < byArray.length) {
            n3 |= (0xFF & byArray[n2++]) << 8;
        }
        if (n2 < byArray.length) {
            n3 |= 0xFF & byArray[n2];
        }
        n3 <<= nArray[1] & 7;
        nArray[1] = nArray[1] + n;
        nArray[0] = nArray[1] >>> 3;
        return n3 >>>= 32 - n;
    }

    private int Show_Bits(byte[] byArray, int[] nArray, int n) {
        int n2 = nArray[1] >>> 3;
        if (n2 >= byArray.length) {
            this.global_error = true;
            return 0;
        }
        int n3 = (0xFF & byArray[n2++]) << 24;
        if (n2 < byArray.length) {
            n3 |= (0xFF & byArray[n2++]) << 16;
        }
        if (n2 < byArray.length) {
            n3 |= (0xFF & byArray[n2++]) << 8;
        }
        if (n2 < byArray.length) {
            n3 |= 0xFF & byArray[n2];
        }
        n3 <<= nArray[1] & 7;
        return n3 >>>= 32 - n;
    }

    private void Flush_Bits(int[] nArray, int n) {
        nArray[1] = nArray[1] + n;
        nArray[0] = nArray[1] >>> 3;
    }

    private void align_Bits(int[] nArray) {
        if ((1 & nArray[1] >>> 2) != 0) {
            this.Flush_Bits(nArray, 4);
        }
    }

    public String isForced_Msg() {
        String string = null;
        if ((this.isforced_status & 1) == 0) {
            string = (this.isforced_status & 2) > 0 ? Resource.getString("subpicture.msg.forced.no") : Resource.getString("subpicture.msg.forced.yes");
        }
        this.isforced_status |= 1;
        return string;
    }

    public void reset() {
        this.isforced_status = 0;
        this.set_XY_Offset(0, 0);
        this.setDisplayMode(0);
    }

    public void set_XY_Offset(int n, int n2) {
        this.X_Offset = n;
        this.Y_Offset = n2;
    }

    public void setDisplayMode(int n) {
        this.DisplayMode = n;
    }

    public int decode_picture(byte[] byArray, int n, boolean bl, Object object) {
        return this.decode_picture(byArray, n, bl, object, 0L, false, true);
    }

    public int decode_picture(byte[] byArray, int n, boolean bl, Object object, long l, boolean bl2, boolean bl3) {
        int n2;
        int n3;
        int n4;
        int n5;
        this.read_from_Image = false;
        this.global_error = false;
        boolean bl4 = false;
        int n6 = byArray.length;
        int[] nArray = new int[]{n, n << 3};
        int[] nArray2 = new int[4];
        int[] nArray3 = new int[3];
        int[] nArray4 = new int[4];
        if (nArray[0] > n6) {
            return -4;
        }
        int n7 = this.Get_Bits(byArray, nArray, 16);
        if (this.Show_Bits(byArray, nArray, 24) == 15) {
            this.big.setFont(this.font_std);
            byte[] byArray2 = new byte[n6 + 4];
            System.arraycopy(byArray, 0, byArray2, 0, n6);
            int n8 = this.dvb.decodeDVBSubpicture(byArray2, nArray, this.big, this.bimg, l, bl2, bl3);
            if (n8 > -2) {
                this.repaint();
            }
            return n8;
        }
        if (nArray[0] + n7 != n6 + 2) {
            return -5;
        }
        nArray3[2] = this.Get_Bits(byArray, nArray, 16) - 2;
        this.Flush_Bits(nArray, nArray3[2] << 3);
        int n9 = this.Get_Bits(byArray, nArray, 16);
        if (n9 == nArray3[2] + 2) {
            n9 = n7;
            bl4 = true;
            Common.setMessage(Resource.getString("subpicture.msg2"));
        } else {
            nArray3[2] = nArray3[2] + (n + 2);
        }
        int[] nArray5 = this.getColorTable(0);
        block10: while (nArray[0] < n + n9) {
            n5 = this.Show_Bits(byArray, nArray, 8);
            switch (n5) {
                case 0: {
                    int n10 = this.isforced_status = (this.isforced_status & 5) != 5 ? 4 : 5;
                    if (this.DisplayMode == 2) {
                        this.Set_Bits(byArray, nArray, 8, 1);
                        break;
                    }
                    this.Flush_Bits(nArray, 8);
                    break;
                }
                case 1: {
                    int n11 = this.isforced_status = (this.isforced_status & 3) != 3 ? 2 : 3;
                    if (this.DisplayMode == 1) {
                        this.Set_Bits(byArray, nArray, 8, 0);
                        break;
                    }
                    this.Flush_Bits(nArray, 8);
                    break;
                }
                case 2: 
                case 255: {
                    this.Flush_Bits(nArray, 8);
                    break;
                }
                case 3: {
                    this.Flush_Bits(nArray, 8);
                    n4 = 0;
                    while (n4 < 4) {
                        int n12 = 3 - n4;
                        nArray4[n12] = nArray4[n12] | nArray5[this.Get_Bits(byArray, nArray, 4)] & 0xFFFFFF;
                        ++n4;
                    }
                    continue block10;
                }
                case 4: {
                    this.Flush_Bits(nArray, 8);
                    n3 = 0;
                    while (n3 < 4) {
                        int n13 = 3 - n3;
                        nArray4[n13] = nArray4[n13] | 17 * (0xF ^ this.Get_Bits(byArray, nArray, 4)) << 24;
                        ++n3;
                    }
                    continue block10;
                }
                case 5: {
                    this.Flush_Bits(nArray, 8);
                    if (this.X_Offset != 0) {
                        nArray2[0] = this.Show_Bits(byArray, nArray, 12) + this.X_Offset;
                        this.Set_Bits(byArray, nArray, 12, nArray2[0]);
                        nArray2[1] = this.Show_Bits(byArray, nArray, 12) + this.X_Offset;
                        this.Set_Bits(byArray, nArray, 12, nArray2[1]);
                    } else {
                        nArray2[0] = this.Get_Bits(byArray, nArray, 12);
                        nArray2[1] = this.Get_Bits(byArray, nArray, 12);
                    }
                    if (this.Y_Offset != 0) {
                        nArray2[2] = this.Show_Bits(byArray, nArray, 12) + this.Y_Offset;
                        this.Set_Bits(byArray, nArray, 12, nArray2[2]);
                        nArray2[3] = this.Show_Bits(byArray, nArray, 12) + this.Y_Offset;
                        this.Set_Bits(byArray, nArray, 12, nArray2[3]);
                        break;
                    }
                    nArray2[2] = this.Get_Bits(byArray, nArray, 12);
                    nArray2[3] = this.Get_Bits(byArray, nArray, 12);
                    break;
                }
                case 6: {
                    this.Flush_Bits(nArray, 8);
                    n2 = 0;
                    while (n2 < 2) {
                        nArray3[n2] = this.Get_Bits(byArray, nArray, 16);
                        ++n2;
                    }
                    continue block10;
                }
                case 7: {
                    this.Flush_Bits(nArray, 8);
                    this.Flush_Bits(nArray, 16);
                    break;
                }
                default: {
                    Common.setMessage(Resource.getString("subpicture.msg3") + ": " + n5);
                }
            }
        }
        if (n + n9 != nArray[0]) {
            return -6;
        }
        n5 = 0;
        if (!bl4) {
            n5 = this.Get_Bits(byArray, nArray, 16);
            if (n9 != this.Get_Bits(byArray, nArray, 16)) {
                return -7;
            }
            if (this.Get_Bits(byArray, nArray, 8) != 2) {
                return -8;
            }
            this.Flush_Bits(nArray, (nArray[0] & 1) != 1 ? 16 : 8);
        }
        if (nArray[0] != n6) {
            return -9;
        }
        if (this.global_error) {
            return -3;
        }
        if (!bl) {
            return n5 * 1024;
        }
        n4 = 0;
        while (n4 < 2) {
            int n14 = n4++;
            nArray3[n14] = nArray3[n14] + n;
        }
        this.paintVideoSize(object);
        n3 = nArray2[2];
        n2 = nArray2[1] - nArray2[0] + 1;
        int n15 = nArray2[3] - nArray2[2] + 1;
        this.big.setColor(Color.white);
        this.big.drawRect(nArray2[0] - 1, n3 - 1, n2 + 1, n15 + 1);
        this.big.setFont(this.font_std);
        this.big.drawString("x" + nArray2[0] + ", y" + nArray2[2] + " / " + n2 + "*" + n15, nArray2[0] - 1, n3 - 5);
        int n16 = 0;
        while (n16 < 2) {
            int n17 = 0;
            int n18 = nArray2[0];
            int n19 = n3 + n16;
            nArray[0] = nArray3[n16];
            nArray[1] = nArray[0] << 3;
            while (nArray[0] < nArray3[n16 + 1]) {
                n17 = this.Get_Bits(byArray, nArray, 4);
                if (n17 > 3) {
                    this.big.setColor(new Color(nArray4[n17 & 3]));
                    this.big.drawLine(n18, n19, n18 += n17 >>> 2, n19);
                    continue;
                }
                if ((n17 = n17 << 4 | this.Get_Bits(byArray, nArray, 4)) > 15) {
                    this.big.setColor(new Color(nArray4[n17 & 3]));
                    this.big.drawLine(n18, n19, n18 += n17 >>> 2, n19);
                    continue;
                }
                if ((n17 = n17 << 4 | this.Get_Bits(byArray, nArray, 4)) > 63) {
                    this.big.setColor(new Color(nArray4[n17 & 3]));
                    this.big.drawLine(n18, n19, n18 += n17 >>> 2, n19);
                    continue;
                }
                if ((n17 = n17 << 4 | this.Get_Bits(byArray, nArray, 4)) > 0) {
                    this.big.setColor(new Color(nArray4[n17 & 3]));
                    this.big.drawLine(n18, n19, n18 += n17 >>> 2, n19);
                    continue;
                }
                n18 = nArray2[0];
                n19 += 2;
                this.align_Bits(nArray);
            }
            ++n16;
        }
        this.repaint();
        if (this.global_error) {
            return -3;
        }
        return n5 * 1024;
    }
}

