/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.subtitle;

import java.util.ArrayList;

public class Bitmap {
    private int width = 0;
    private int height = 0;
    private int depth = 0;
    private int[] pixel = null;
    private int page_id = -1;
    private int region_id = -1;
    private int object_id = -1;
    private int x = 0;
    private int y = 0;
    private long in_time = -1L;
    private int play_time = -1;
    private ArrayList color_indices = new ArrayList();
    private ArrayList color_table = new ArrayList();

    public Bitmap() {
    }

    public Bitmap(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6, int n7, int n8, long l, int n9) {
        this.x = n;
        this.y = n2 & 0xFFFFFFFE;
        this.width = n3;
        this.height = n4;
        this.pixel = nArray;
        this.depth = n5;
        this.page_id = 0xFF & n6;
        this.region_id = 0xFF & n7;
        this.object_id = 0xFFFF & n8;
        this.in_time = l;
        this.play_time = n9;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getMaxX() {
        return this.x + this.width;
    }

    public int getMaxY() {
        return this.y + this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public void setPixel(int[] nArray) {
        this.pixel = nArray;
    }

    public int[] getPixel() {
        return this.pixel;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getPageId() {
        return this.page_id;
    }

    public int getRegionId() {
        return this.region_id;
    }

    public int getObjectId() {
        return this.object_id;
    }

    public int getId() {
        return this.page_id;
    }

    public void setTime(long l, int n) {
        this.in_time = l;
        this.play_time = n;
    }

    public long getInTime() {
        return this.in_time;
    }

    public int getPlayTime() {
        return this.play_time;
    }

    public void createColorTable() {
        int n = 0;
        while (n < this.pixel.length) {
            String string = "" + this.pixel[n];
            if (!this.color_table.contains(string)) {
                this.color_table.add(string);
            }
            ++n;
        }
    }

    public void clearColorTable() {
        this.color_table.clear();
    }

    public Object[] getColorTable() {
        return this.color_table.toArray();
    }

    public ArrayList getColorTableArray() {
        return this.color_table;
    }

    public int getColorIndex(int n) {
        String string = "" + n;
        int n2 = this.color_indices.indexOf(string);
        if (n2 != -1) {
            return n2;
        }
        if (this.color_indices.size() < 4) {
            this.color_indices.add(string);
        }
        return this.color_indices.size() - 1;
    }

    public void clearColorIndices() {
        this.color_indices.clear();
    }

    public Object[] getColorIndices() {
        return this.color_indices.toArray();
    }
}

