/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.parser;

import java.io.File;
import java.io.InputStream;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.parser.CommonParsing;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class StreamProcessBase {
    public int ERRORCODE = 0;
    public int MainBufferSize = 0x7D0000;

    public StreamProcessBase() {
        this.init();
    }

    public void init() {
        this.MainBufferSize = Integer.parseInt(Common.getSettings().getProperty(Keys.KEY_MainBuffer));
        if (this.MainBufferSize <= 0) {
            this.MainBufferSize = 4096000;
        }
    }

    public boolean pause() {
        return Common.waitingMainProcess();
    }

    public String FramesToTime(int n, double d) {
        return String.valueOf(Math.round((double)n * d / 90.0));
    }

    public long[][] loadTempVideoPts(String string, boolean bl) {
        if (string.equals("-1")) {
            return null;
        }
        if (bl) {
            System.out.println("-> loading video PTS logfile...");
        }
        XInputFile xInputFile = new XInputFile(new File(string));
        int n = (int)xInputFile.length() / 16;
        long[][] lArray = new long[2][n];
        byte[] byArray = new byte[(int)xInputFile.length()];
        int n2 = 0;
        try {
            InputStream inputStream = xInputFile.getInputStream();
            inputStream.read(byArray, 0, byArray.length);
            int n3 = 0;
            while (n3 < n) {
                lArray[0][n3] = CommonParsing.getValue(byArray, n2, 8, false);
                lArray[0][n3 + 1] = CommonParsing.getValue(byArray, n2 += 8, 8, false);
                lArray[1][n3] = CommonParsing.getValue(byArray, n2 += 8, 8, false);
                lArray[1][n3 + 1] = CommonParsing.getValue(byArray, n2 += 8, 8, false);
                n2 += 8;
                if (bl) {
                    System.out.println("#s " + n3 + " _" + lArray[0][n3] + " #e " + (n3 + 1) + " _" + lArray[0][n3 + 1] + " /#s " + n3 + " _" + lArray[1][n3] + " #e " + (n3 + 1) + " _" + lArray[1][n3 + 1]);
                }
                n3 += 2;
            }
            inputStream.close();
        }
        catch (Exception exception) {
            Common.setExceptionMessage(exception);
            return null;
        }
        Common.setMessage(Resource.getString("video.msg.pts.start_end", Common.formatTime_1(lArray[0][0] / 90L)) + " " + Common.formatTime_1(lArray[0][lArray[0].length - 1] / 90L));
        return lArray;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public long[][] loadTempOtherPts(String var1_1, String var2_2, String var3_3, String var4_4, String var5_5, int var6_6, boolean var7_7, boolean var8_8) {
        if (var1_1.equals("-1")) {
            return null;
        }
        if (var8_8) {
            System.out.println("-> loading PTS logfile...");
        }
        var9_9 = new XInputFile(new File(var1_1));
        var10_10 = (int)var9_9.length() / 16;
        var11_11 = new long[2][var10_10 + 1];
        var11_11[0][var10_10] = -1L;
        var11_11[1][var10_10] = -1L;
        var12_12 = new byte[(int)var9_9.length()];
        var13_13 = 0;
        try {
            var14_14 = var9_9.getInputStream();
            var14_14.read(var12_12, 0, var12_12.length);
            var15_16 = 0;
            var20_17 = 0;
            while (var20_17 < var10_10) {
                var16_18 = CommonParsing.getValue(var12_12, var13_13, 8, false);
                var18_19 = CommonParsing.getValue(var12_12, var13_13 += 8, 8, false);
                var13_13 += 8;
                if (var8_8) {
                    System.out.println(" #" + var15_16 + "/" + var20_17 + " _" + var16_18 + " / " + var18_19);
                }
                if (var15_16 <= 0 || var16_18 > var11_11[0][var15_16 - 1]) ** GOTO lbl32
                if (var15_16 <= 1 || Math.abs(var16_18 - var11_11[0][var15_16 - 2]) >= 150000L || Math.abs(var16_18 - var11_11[0][var15_16 - 1]) <= 500000L) {
                    if (var8_8) {
                        System.out.print(" <!v> ");
                    }
                } else {
                    --var15_16;
                    if (var8_8) {
                        System.out.print(" <!^> ");
                    }
lbl32:
                    // 4 sources

                    var11_11[0][var15_16] = var16_18;
                    var11_11[1][var15_16] = var18_19;
                    ++var15_16;
                }
                ++var20_17;
            }
            if (var15_16 < var10_10) {
                Common.setMessage(Resource.getString(var2_2, " " + (var10_10 - var15_16)));
                var21_20 /* !! */  = new long[2][var15_16];
                System.arraycopy(var11_11[0], 0, var21_20 /* !! */ [0], 0, var15_16);
                System.arraycopy(var11_11[1], 0, var21_20 /* !! */ [1], 0, var15_16);
                var11_11[0] = new long[var15_16 + 1];
                System.arraycopy(var21_20 /* !! */ [0], 0, var11_11[0], 0, var15_16);
                var11_11[0][var15_16] = -1L;
                var11_11[1] = new long[var15_16 + 1];
                System.arraycopy(var21_20 /* !! */ [1], 0, var11_11[1], 0, var15_16);
                var11_11[1][var15_16] = -1L;
            }
            var14_14.close();
            if (var6_6 == 1 && (var11_11[0][0] == 0xFFFFFFFFL || var11_11[0][0] == 0L)) {
                Common.setMessage(Resource.getString(var5_5));
                var7_7 = true;
            }
            if (var7_7) {
                var21_20 /* !! */  = (long[][])new long[]{var11_11[0][0], var11_11[1][0]};
                var11_11[0] = new long[2];
                var11_11[0][0] = (long)var21_20 /* !! */ [0];
                var11_11[0][1] = -1L;
                var11_11[1] = new long[2];
                var11_11[1][0] = (long)var21_20 /* !! */ [1];
                var11_11[1][1] = -1L;
                Common.setMessage(Resource.getString(var3_3));
            }
        }
        catch (Exception var14_15) {
            Common.setExceptionMessage(var14_15);
            return null;
        }
        Common.setMessage(Resource.getString(var4_4, Common.formatTime_1(var11_11[0][0] / 90L)) + " " + Common.formatTime_1(var11_11[0][var11_11[0].length - 2] / 90L));
        return var11_11;
    }

    public int checkPTSMatch(long[] lArray, long[] lArray2) {
        if (lArray2[0] < lArray[0]) {
            if (lArray2[lArray2.length - 2] < lArray[0]) {
                Common.setMessage(Resource.getString("checkpts.1st.latter"));
                return lArray2.length - 2;
            }
            int n = lArray2.length - 1;
            int n2 = 0;
            while (n2 < n) {
                if (lArray2[n2 + 1] > lArray[0]) {
                    return n2;
                }
                ++n2;
            }
            return 0;
        }
        if (lArray2[0] >= lArray[lArray.length - 1]) {
            Common.setMessage(Resource.getString("checkpts.last.ends"));
            return -1;
        }
        return 0;
    }

    public String infoPTSMatch(String string, String string2, boolean bl, boolean bl2) {
        if (!string2.equals("-1") && !string.equals("-1") && !bl && bl2) {
            return "? ";
        }
        return "";
    }

    public boolean SyncCheck(int[] nArray, double d, double d2, long l, int n, long[] lArray, long[] lArray2, boolean bl, boolean bl2) {
        int n2 = nArray[0];
        int n3 = nArray[1];
        if (n3 < lArray.length) {
            double d3 = l - lArray[n3 + 1];
            double d4 = d - (double)lArray2[n3 + 1];
            if (bl2) {
                System.out.println("A " + bl + "/" + n2 + "/" + n3 + "/ =1 " + n + "/" + lArray2[n3 + 1] + "/" + d + " ~2 " + lArray[n3 + 1] + "/" + l + " ~3 " + d3 + "/" + d4 + "/" + (d4 - d3));
            }
            if (Math.abs(d4) <= d2 / 2.0) {
                bl = false;
                n3 += 2;
            } else if (Math.abs(d3) <= d2 / 2.0) {
                bl = false;
                n3 += 2;
            }
            if (bl2) {
                System.out.println("B " + bl + "/" + n2 + "/" + n3);
            }
        }
        if (n2 < lArray.length) {
            boolean bl3 = false;
            double d5 = l - lArray[n2];
            double d6 = d - (double)lArray2[n2];
            if (bl2) {
                System.out.println("C " + bl + "/" + n2 + "/" + n3 + "/ =4 " + n + "/" + lArray2[n2] + "/" + d + " ~5 " + lArray[n2] + "/" + l + " ~6 " + d5 + "/" + d6 + "/" + (d6 - d5));
            }
            if (!bl && Math.abs(d5) <= d2 / 2.0) {
                bl = true;
                bl3 = true;
                n2 += 2;
            } else if (!bl && Math.abs(Math.abs(d6) - Math.abs(d5)) <= d2 / 2.0) {
                bl = true;
                bl3 = true;
                n2 += 2;
            }
            if (bl2) {
                System.out.println("D " + bl + "/" + n2 + "/" + n3);
            }
            if (n2 < lArray.length && bl && d + d2 / 2.0 > (double)lArray2[n2]) {
                bl = false;
            }
            if (bl2) {
                System.out.println("E " + bl + "/" + n2 + "/" + n3);
            }
            if (bl3 && bl) {
                Common.getGuiInterface().showAVOffset("" + (int)(d5 / 90.0) + "/" + (int)(d6 / 90.0) + "/" + (int)((d6 - d5) / 90.0));
            }
        }
        nArray[0] = n2;
        nArray[1] = n3;
        return bl;
    }
}

