/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.parser;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import net.sourceforge.dvb.projectx.audio.AudioFormat;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.parser.CommonParsing;
import net.sourceforge.dvb.projectx.video.Video;
import net.sourceforge.dvb.projectx.xinput.StreamInfo;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class Scan {
    private final String msg_1 = Resource.getString("scan.msg1");
    private final String msg_2 = Resource.getString("scan.msg2");
    private final String msg_3 = Resource.getString("scan.msg3");
    private final String msg_4 = Resource.getString("scan.msg4");
    private final String msg_5 = Resource.getString("scan.msg5");
    private final String msg_6 = Resource.getString("scan.msg6");
    private final String msg_7 = Resource.getString("scan.msg7");
    private final String msg_8 = Resource.getString("scan.msg8");
    private final String msg_9 = Resource.getString("scan.msg9");
    private String addInfo = "";
    private String playtime = "";
    private boolean hasVideo = false;
    private byte[] vbasic = new byte[12];
    private int filetype = 0;
    private ArrayList pidlist;
    private ArrayList video_streams;
    private ArrayList audio_streams;
    private ArrayList ttx_streams;
    private ArrayList pic_streams;
    private AudioFormat Audio = new AudioFormat();

    public Scan() {
        this.video_streams = new ArrayList();
        this.audio_streams = new ArrayList();
        this.ttx_streams = new ArrayList();
        this.pic_streams = new ArrayList();
        this.pidlist = new ArrayList();
    }

    public void getStreamInfo(XInputFile xInputFile) {
        this.getStreamInfo(xInputFile, -1);
    }

    public void getStreamInfo(XInputFile xInputFile, int n) {
        long l = xInputFile.length();
        String string = this.getName(xInputFile);
        String string2 = this.getLocation(xInputFile);
        String string3 = this.getDate(xInputFile);
        String string4 = this.getSize(xInputFile);
        StreamInfo streamInfo = xInputFile.getStreamInfo();
        if (xInputFile.exists()) {
            if (streamInfo == null) {
                streamInfo = new StreamInfo();
            }
            streamInfo.setStreamInfo(xInputFile.getFileType().getName(), this.getType(xInputFile, n), string, string2, string3, string4, this.getPlaytime(), this.getVideo(), this.getAudio(), this.getText(), this.getPics());
            streamInfo.setStreamType(this.filetype, this.addInfo);
            streamInfo.setPIDs(this.getPIDs());
            streamInfo.setVideoHeader(this.getVBasic());
        } else {
            streamInfo = new StreamInfo("", Resource.getString("ScanInfo.NotFound"), string, string2, "", "", "");
        }
        xInputFile.setStreamInfo(streamInfo);
    }

    private String getType(XInputFile xInputFile, int n) {
        this.filetype = this.testFile(xInputFile, true, n);
        return Keys.ITEMS_FileTypes[this.filetype].toString() + this.addInfo;
    }

    private String getName(XInputFile xInputFile) {
        return xInputFile.getName();
    }

    private String getLocation(XInputFile xInputFile) {
        return xInputFile.getParent();
    }

    private String getDate(XInputFile xInputFile) {
        return DateFormat.getDateInstance(1).format(new Date(xInputFile.lastModified())) + "  " + DateFormat.getTimeInstance(1).format(new Date(xInputFile.lastModified()));
    }

    private String getSize(XInputFile xInputFile) {
        long l = xInputFile.length();
        return String.valueOf(l / 0x100000L) + " MB (" + Common.formatNumber(l) + " " + Resource.getString("ScanInfo.Bytes") + ")";
    }

    private String getPlaytime() {
        return this.playtime;
    }

    private Object[] getVideo() {
        return this.video_streams.toArray();
    }

    private Object[] getAudio() {
        return this.audio_streams.toArray();
    }

    private Object[] getText() {
        return this.ttx_streams.toArray();
    }

    private Object[] getPics() {
        return this.pic_streams.toArray();
    }

    private Object[] getPIDs() {
        return this.pidlist.toArray();
    }

    private String getAudioTime(long l) {
        return Common.formatTime_1(l * 8000L / (long)this.Audio.getBitrate());
    }

    public byte[] getVBasic() {
        if (this.hasVideo) {
            return this.vbasic;
        }
        return null;
    }

    private int AC3Audio(byte[] byArray) {
        this.Audio.setNewType(0);
        int n = 0;
        while (n < 10000) {
            if (this.Audio.parseHeader(byArray, n) >= 0) {
                int n2 = 0;
                while (n2 < 17) {
                    if (this.Audio.parseNextHeader(byArray, n + this.Audio.getSize() + n2) == 1) {
                        if ((0xFF & byArray[n + this.Audio.getSize()]) > 63 || (0xFF & byArray[n + this.Audio.getSize()]) == 0) break;
                        this.audio_streams.add(this.Audio.saveAndDisplayHeader());
                        return 1;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return 0;
    }

    private void DTSAudio(byte[] byArray) {
        this.Audio.setNewType(6);
        int n = 0;
        while (n < 10000) {
            if (this.Audio.parseHeader(byArray, n) >= 0) {
                int n2 = 0;
                while (n2 < 15) {
                    if (this.Audio.parseNextHeader(byArray, n + this.Audio.getSize() + n2) == 1) {
                        if ((0xFF & byArray[n + this.Audio.getSize()]) > 127 || (0xFF & byArray[n + this.Audio.getSize()]) == 0) break;
                        this.audio_streams.add(this.Audio.saveAndDisplayHeader());
                        return;
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    private void MPEGAudio(byte[] byArray) {
        this.Audio.setNewType(2);
        int n = 0;
        while (n < 10000) {
            if (this.Audio.parseHeader(byArray, n) >= 0 && this.Audio.parseNextHeader(byArray, n + this.Audio.getSize()) >= 0) {
                this.audio_streams.add(this.Audio.saveAndDisplayHeader());
                return;
            }
            ++n;
        }
    }

    private byte[] loadPES(byte[] byArray, int n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (n < byArray.length) {
            int n2;
            int n3;
            boolean bl = (0x80 & byArray[n + 6]) == 0;
            int n4 = n + 6 + (!bl ? 3 + (0xFF & byArray[n + 8]) : 0);
            if (n4 + (n3 = (n2 = (0xFF & byArray[n + 4]) << 8 | 0xFF & byArray[n + 5]) - (!bl ? 3 + (0xFF & byArray[n + 8]) : 0)) > byArray.length) break;
            byteArrayOutputStream.write(byArray, n4, n3);
            n += 6 + n2;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void loadMPG2(byte[] byArray, int n, boolean bl, boolean bl2, boolean bl3, int n2) throws IOException {
        ScanObject scanObject;
        String string;
        int n3;
        Hashtable<String, ScanObject> hashtable = new Hashtable<String, ScanObject>();
        int n4 = 1;
        int n5 = byArray.length > 580000 ? 512000 : byArray.length - 65000;
        int n6 = n;
        while (n6 < n5) {
            int n7 = CommonParsing.validateStartcode(byArray, n6);
            if (n7 < 0) {
                n4 = -n7;
            } else {
                n3 = CommonParsing.getPES_IdField(byArray, n6);
                string = String.valueOf(n3);
                if (n3 == 186) {
                    n4 = (0xC0 & byArray[4 + n6]) == 0 ? 12 : ((0xC0 & byArray[4 + n6]) == 64 ? 14 + (7 & byArray[13 + n6]) : 4);
                } else if ((0xF0 & n3) == 224) {
                    int n8 = n4 = bl3 ? 2048 : 6 + CommonParsing.getPES_LengthField(byArray, n6);
                    if (!hashtable.containsKey(string)) {
                        hashtable.put(string, new ScanObject(n3));
                    }
                    scanObject = (ScanObject)hashtable.get(string);
                    scanObject.write(byArray, n6 + 6 + (!bl2 ? 3 + CommonParsing.getPES_ExtensionLengthField(byArray, n6) : 0), n4 - (!bl2 ? 3 - CommonParsing.getPES_ExtensionLengthField(byArray, n6) : 0));
                } else if ((0xE0 & n3) == 192) {
                    n4 = 6 + CommonParsing.getPES_LengthField(byArray, n6);
                    if (!hashtable.containsKey(string)) {
                        hashtable.put(string, new ScanObject(n3));
                    }
                    scanObject = (ScanObject)hashtable.get(string);
                    scanObject.write(byArray, n6, n4);
                } else if (n3 == 189) {
                    boolean bl4;
                    n4 = 6 + CommonParsing.getPES_LengthField(byArray, n6);
                    int n9 = CommonParsing.getPES_ExtensionLengthField(byArray, n6);
                    boolean bl5 = bl4 = (4 & byArray[n6 + 6]) != 0;
                    if (n9 == 36 && (0xF0 & byArray[n6 + 9 + n9]) >>> 4 == 1) {
                        string = "SubID 0x" + Integer.toHexString(0xFF & byArray[n6 + 9 + n9]).toUpperCase();
                        if (this.ttx_streams.indexOf(string) < 0) {
                            this.ttx_streams.add(string);
                        }
                    } else if ((!bl2 && !bl || bl && bl4) && ((0xF0 & byArray[n6 + 9 + n9]) >>> 4 == 2 || (0xF0 & byArray[n6 + 9 + n9]) >>> 4 == 3)) {
                        string = "SubID 0x" + Integer.toHexString(0xFF & byArray[n6 + 9 + n9]).toUpperCase();
                        if (this.pic_streams.indexOf(string) < 0) {
                            this.pic_streams.add(string);
                        }
                    } else {
                        if (!bl) {
                            n3 = 0xFF & byArray[n6 + 9 + n9];
                            string = String.valueOf(n3);
                            byArray[n6 + 8] = (byte)(4 + n9);
                        }
                        if (!hashtable.containsKey(string)) {
                            hashtable.put(string, new ScanObject(n3));
                        }
                        scanObject = (ScanObject)hashtable.get(string);
                        scanObject.write(byArray, n6, n4);
                    }
                } else {
                    switch (n3) {
                        case 187: 
                        case 188: 
                        case 190: 
                        case 191: 
                        case 240: 
                        case 241: 
                        case 242: 
                        case 243: 
                        case 244: 
                        case 245: 
                        case 246: 
                        case 247: 
                        case 248: 
                        case 249: 
                        case 250: 
                        case 251: 
                        case 252: 
                        case 253: 
                        case 254: 
                        case 255: {
                            n4 = 6 + CommonParsing.getPES_LengthField(byArray, n6);
                            break;
                        }
                        default: {
                            n4 = 1;
                        }
                    }
                }
            }
            n6 += n4;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string = enumeration.nextElement().toString();
            n3 = Integer.parseInt(string);
            scanObject = (ScanObject)hashtable.get(string);
            if ((0xF0 & n3) == 224) {
                try {
                    this.checkVid(scanObject.getData());
                }
                catch (Exception exception) {
                    this.video_streams.add(this.msg_8);
                }
                continue;
            }
            try {
                this.checkPES(scanObject.getData());
            }
            catch (Exception exception) {
                this.audio_streams.add(this.msg_8);
            }
        }
        hashtable.clear();
    }

    private void loadPVA(byte[] byArray, int n) throws IOException {
        ScanObject scanObject;
        String string;
        Hashtable<String, ScanObject> hashtable = new Hashtable<String, ScanObject>();
        int n2 = byArray.length > 580000 ? 512000 : byArray.length - 65000;
        while (n < n2) {
            int n3 = (0xFF & byArray[n + 6]) << 8 | 0xFF & byArray[n + 7];
            if (n + 8 + (1 & byArray[n + 5] >>> 4) * 4 + n3 > byArray.length) break;
            int n4 = 0xFF & byArray[n + 2];
            string = String.valueOf(n4);
            if (!hashtable.containsKey(string)) {
                hashtable.put(string, new ScanObject(n4));
            }
            scanObject = (ScanObject)hashtable.get(string);
            switch (n4) {
                case 1: {
                    scanObject.write(byArray, n + 8 + (1 & byArray[n + 5] >>> 4) * 4, n3);
                    break;
                }
                default: {
                    scanObject.write(byArray, n + 8, n3);
                }
            }
            n += 8 + n3;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string = enumeration.nextElement().toString();
            scanObject = (ScanObject)hashtable.get(string);
            if (string.equals("1")) {
                try {
                    this.checkVid(scanObject.getData());
                }
                catch (Exception exception) {
                    this.video_streams.add(this.msg_8);
                }
                continue;
            }
            try {
                this.checkPES(scanObject.getData());
            }
            catch (Exception exception) {
                this.audio_streams.add(this.msg_8);
            }
        }
        hashtable.clear();
    }

    private void checkPES(byte[] byArray) {
        this.checkPES(byArray, 0);
    }

    private void checkPES(byte[] byArray, int n) {
        int n2 = n + 8000;
        while (n < n2) {
            int n3;
            int n4 = CommonParsing.validateStartcode(byArray, n);
            if (n4 < 0) {
                n += -n4 - 1;
            } else if (((0xE0 & byArray[n + 3]) == 192 || CommonParsing.getPES_IdField(byArray, n) == 189) && CommonParsing.validateStartcode(byArray, n3 = n + 6 + CommonParsing.getPES_LengthField(byArray, n)) >= 0) {
                if ((0xE0 & byArray[n + 3]) == 192 && (0xE0 & byArray[n + 3]) == (0xE0 & byArray[n3 + 3])) {
                    this.MPEGAudio(this.loadPES(byArray, n));
                    return;
                }
                if (CommonParsing.getPES_IdField(byArray, n) == 189 && CommonParsing.getPES_IdField(byArray, n) == CommonParsing.getPES_IdField(byArray, n3)) {
                    byte[] byArray2 = this.loadPES(byArray, n);
                    if (this.AC3Audio(byArray2) < 1) {
                        this.DTSAudio(byArray2);
                    }
                    return;
                }
            }
            ++n;
        }
    }

    private void checkVid(byte[] byArray) {
        this.checkVid(byArray, byArray.length - 630);
    }

    private boolean checkVid(byte[] byArray, int n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        while (n2 < n) {
            int n3 = CommonParsing.validateStartcode(byArray, n2);
            if (n3 < 0 || CommonParsing.getPES_IdField(byArray, n2) != 179) {
                n2 += (n3 < 0 ? -n3 : 4) - 1;
            } else {
                int n4 = 7;
                int n5 = 1;
                while (n4 < 600) {
                    n3 = CommonParsing.validateStartcode(byArray, n2 + n4);
                    if (n3 < 0) {
                        n4 += -n3 - 1;
                    } else {
                        int n6 = CommonParsing.getPES_IdField(byArray, n2 + n4);
                        if (n6 == 181 && (0xF0 & byArray[4 + n2 + n4]) == 16) {
                            n5 = 2;
                        } else if (n6 == 184 || n6 == 0) {
                            this.hasVideo = true;
                            System.arraycopy(byArray, n2, this.vbasic, 0, 12);
                            byteArrayOutputStream.write(byArray, n2, 20);
                            this.video_streams.add("MPEG-" + n5 + ", " + Video.getVideoformatfromBytes(byteArrayOutputStream.toByteArray()));
                            return true;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return this.checkH264(byArray, n);
    }

    private boolean checkH264(byte[] byArray, int n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int[] nArray = new int[]{0};
        int n2 = 0;
        int n3 = n - 50;
        while (n2 < n3) {
            if (byArray[n2] == 0 && byArray[1 + n2] == 0 && byArray[2 + n2] == 0 && byArray[3 + n2] == 1) {
                nArray[0] = 4 + n2 << 3;
                int n4 = this.getBits(byArray, nArray, 1);
                int n5 = this.getBits(byArray, nArray, 2);
                int n6 = this.getBits(byArray, nArray, 5);
                if (n4 == 0 && n6 == 7) {
                    int n7 = this.getBits(byArray, nArray, 8);
                    this.getBits(byArray, nArray, 3);
                    this.getBits(byArray, nArray, 5);
                    int n8 = this.getBits(byArray, nArray, 8);
                    int n9 = this.getCodeNum(byArray, nArray);
                    n9 = this.getCodeNum(byArray, nArray);
                    n9 = this.getCodeNum(byArray, nArray);
                    if (n9 == 0) {
                        this.getCodeNum(byArray, nArray);
                    } else if (n9 == 1) {
                        this.getBits(byArray, nArray, 1);
                        this.getSignedCodeNum(byArray, nArray);
                        this.getSignedCodeNum(byArray, nArray);
                        n9 = this.getCodeNum(byArray, nArray);
                        int n10 = 0;
                        while (n10 < n9) {
                            this.getSignedCodeNum(byArray, nArray);
                            ++n10;
                        }
                    }
                    this.getCodeNum(byArray, nArray);
                    this.getBits(byArray, nArray, 1);
                    int n11 = 16 * (1 + this.getCodeNum(byArray, nArray));
                    int n12 = 16 * (1 + this.getCodeNum(byArray, nArray));
                    n9 = this.getBits(byArray, nArray, 1);
                    this.video_streams.add("MPEG-4/H.264, " + n11 + "*" + (n9 == 0 ? n12 << 1 : n12));
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    private int getSignedCodeNum(byte[] byArray, int[] nArray) {
        int n = this.getCodeNum(byArray, nArray);
        n = (n & 1) == 0 ? n >>> 1 : -(n >>> 1);
        return n;
    }

    private int getCodeNum(byte[] byArray, int[] nArray) {
        int n = -1;
        int n2 = 0;
        while (n2 == 0) {
            n2 = this.getBits(byArray, nArray, 1);
            ++n;
        }
        int n3 = (1 << n) - 1 + this.getBits(byArray, nArray, n);
        return n3;
    }

    private int getBits(byte[] byArray, int[] nArray, int n) {
        int n2 = nArray[0] >>> 3;
        if (n == 0) {
            return 0;
        }
        if (n2 >= byArray.length - 4) {
            nArray[0] = nArray[0] + n;
            return -1;
        }
        int n3 = (0xFF & byArray[n2]) << 24 | (0xFF & byArray[n2 + 1]) << 16 | (0xFF & byArray[n2 + 2]) << 8 | 0xFF & byArray[n2 + 3];
        n3 <<= nArray[0] & 7;
        nArray[0] = nArray[0] + n;
        return n3 >>>= 32 - n;
    }

    private void readPMT(byte[] byArray, int n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        while (n < byArray.length - 1000) {
            int n2;
            if (byArray[n] == 71 && byArray[n + 188] == 71 && byArray[n + 376] == 71 && (0x40 & byArray[n + 1]) != 0 && (0xC0 & byArray[n + 3]) == 0 && ((n2 = (0x30 & byArray[n + 3]) >>> 4) & 1) != 0) {
                int n3;
                int n4 = n3 = n2 == 3 ? 1 + (0xFF & byArray[n + 4]) : 0;
                if (byArray[n + n3 + 4] != 0 || byArray[n + n3 + 5] != 2 || (0xF0 & byArray[n + n3 + 6]) != 176) {
                    n += 187;
                } else {
                    int n5;
                    byte[] byArray2;
                    byteArrayOutputStream.write(byArray, n + 4 + n3, 184 - n3);
                    int n6 = (0x1F & byArray[n + 1]) << 8 | 0xFF & byArray[n + 2];
                    if (byteArrayOutputStream.size() < 188) {
                        n += 188;
                        while (n < byArray.length - 500) {
                            if (byArray[n] == 71 && byArray[n + 188] == 71 && byArray[n + 376] == 71 && (0x40 & byArray[n + 1]) == 0 && (0xC0 & byArray[n + 3]) == 0 && ((n2 = (0x30 & byArray[n + 3]) >>> 4) & 1) != 0) {
                                int n7 = n3 = n2 == 3 ? 1 + (0xFF & byArray[n + 4]) : 0;
                                if (((0x1F & byArray[n + 1]) << 8 | 0xFF & byArray[n + 2]) != n6) {
                                    n += 187;
                                } else {
                                    byteArrayOutputStream.write(byArray, n + 4 + n3, 184 - n3);
                                    if (byteArrayOutputStream.size() > 188) break;
                                }
                            }
                            ++n;
                        }
                    }
                    if ((byArray2 = byteArrayOutputStream.toByteArray()).length > 5) {
                        n5 = (0xFF & byArray2[4]) << 8 | 0xFF & byArray2[5];
                        this.pidlist.add("" + n5);
                        this.pidlist.add("" + n6);
                        this.addInfo = " (SID 0x" + Integer.toHexString(n5).toUpperCase() + " ,PMT 0x" + Integer.toHexString(n6).toUpperCase() + ")";
                    }
                    n5 = (0xF & byArray2[2]) << 8 | 0xFF & byArray2[3];
                    int n8 = 8;
                    int n9 = 8;
                    while (n8 < n5 - 4 && n8 < byArray2.length - 6) {
                        n9 = n8;
                        if ((0xE0 & byArray2[n8 + 1]) == 224) {
                            int n10 = (0x1F & byArray2[n8 + 1]) << 8 | 0xFF & byArray2[n8 + 2];
                            switch (0xFF & byArray2[n8]) {
                                case 1: 
                                case 2: {
                                    int n11 = n8 + 5;
                                    n8 += 4 + (0xFF & byArray2[n8 + 4]);
                                    this.getDescriptor(byArray2, n11, n8, n10, 2);
                                    this.pidlist.add("" + n10);
                                    break;
                                }
                                case 3: 
                                case 4: {
                                    int n12 = n8 + 5;
                                    n8 += 4 + (0xFF & byArray2[n8 + 4]);
                                    this.getDescriptor(byArray2, n12, n8, n10, 4);
                                    this.pidlist.add("" + n10);
                                    break;
                                }
                                case 27: {
                                    int n13 = n8 + 5;
                                    n8 += 4 + (0xFF & byArray2[n8 + 4]);
                                    this.getDescriptor(byArray2, n13, n8, n10, 27);
                                    this.pidlist.add("" + n10);
                                    break;
                                }
                                case 6: 
                                case 128: 
                                case 129: 
                                case 130: 
                                case 131: {
                                    int n14 = n8 + 5;
                                    n8 += 4 + (0xFF & byArray2[n8 + 4]);
                                    this.getDescriptor(byArray2, n14, n8, n10, 6);
                                    this.pidlist.add("" + n10);
                                    break;
                                }
                                default: {
                                    n8 += 4 + (0xFF & byArray2[n8 + 4]);
                                }
                            }
                            if (n8 < 0) {
                                n8 = n9;
                            }
                        }
                        ++n8;
                    }
                    return;
                }
            }
            ++n;
        }
    }

    private void getDescriptor(byte[] byArray, int n, int n2, int n3, int n4) {
        String string = "";
        int n5 = 0;
        try {
            block33: while (n < n2 && n < byArray.length) {
                switch (0xFF & byArray[n]) {
                    case 89: {
                        int n6;
                        int n7;
                        int n8;
                        int n9;
                        n4 = 89;
                        n5 = n + 2 + (0xFF & byArray[n + 1]);
                        string = string + "(";
                        int n10 = n + 2;
                        while (n10 < n5) {
                            n9 = n10;
                            while (n9 < n10 + 3) {
                                string = string + (char)(0xFF & byArray[n9]);
                                ++n9;
                            }
                            n8 = 0xFF & byArray[n10 + 3];
                            n7 = (0xFF & byArray[n10 + 4]) << 16 | 0xFF & byArray[n10 + 5];
                            n6 = (0xFF & byArray[n10 + 6]) << 16 | 0xFF & byArray[n10 + 7];
                            string = string + "_0x" + Integer.toHexString(n8).toUpperCase();
                            string = string + "_p" + n7;
                            string = string + "_a" + n6 + " ";
                            n10 += 8;
                        }
                        string = string + ")";
                        break block33;
                    }
                    case 86: {
                        int n6;
                        int n7;
                        int n8;
                        n4 = 86;
                        n5 = n + 2 + (0xFF & byArray[n + 1]);
                        string = string + "(";
                        int n9 = n + 2;
                        while (n9 < n5) {
                            n8 = n9;
                            while (n8 < n9 + 3) {
                                string = string + (char)(0xFF & byArray[n8]);
                                ++n8;
                            }
                            n7 = (0xF8 & byArray[n9 + 3]) >>> 3;
                            n6 = 0xFF & byArray[n9 + 4];
                            string = string + "_";
                            switch (n7) {
                                case 1: {
                                    string = string + "i";
                                    break;
                                }
                                case 2: {
                                    string = string + "s";
                                    break;
                                }
                                case 3: {
                                    string = string + "ai";
                                    break;
                                }
                                case 4: {
                                    string = string + "ps";
                                    break;
                                }
                                case 5: {
                                    string = string + "s.hip";
                                    break;
                                }
                                default: {
                                    string = string + "res";
                                }
                            }
                            string = string + Integer.toHexString((7 & byArray[n9 + 3]) == 0 ? 8 : 7 & byArray[n9 + 3]).toUpperCase();
                            string = string + (n6 < 16 ? "0" : "") + Integer.toHexString(n6).toUpperCase() + " ";
                            n9 += 5;
                        }
                        string = string + ")";
                        ++n;
                        n += 0xFF & byArray[n];
                        break;
                    }
                    case 10: {
                        string = string + "(";
                        int n8 = n + 2;
                        while (n8 < n + 5) {
                            string = string + (char)(0xFF & byArray[n8]);
                            ++n8;
                        }
                        string = string + ")";
                        ++n;
                        n += 0xFF & byArray[n];
                        break;
                    }
                    case 106: {
                        string = string + "(AC-3)";
                        ++n;
                        n += 0xFF & byArray[n];
                        break;
                    }
                    case 195: {
                        switch (0xFF & byArray[++n + 1]) {
                            case 4: {
                                string = string + "(VPS)";
                                n4 = 195;
                                break;
                            }
                            case 5: {
                                string = string + "(WSS)";
                                break;
                            }
                            case 6: {
                                string = string + "(CC)";
                                break;
                            }
                            case 1: {
                                string = string + "(EBU-TTX)";
                                break;
                            }
                            case 7: {
                                string = string + "(VBI)";
                            }
                        }
                        n += 0xFF & byArray[n];
                        break;
                    }
                    case 82: {
                        n5 = n + 2 + (0xFF & byArray[n + 1]);
                        string = string + "(#" + (0xFF & byArray[n + 2]) + ")";
                        ++n;
                        n += 0xFF & byArray[n];
                        break;
                    }
                    case 107: {
                        n5 = n + 2 + (0xFF & byArray[n + 1]);
                        string = string + "(RDS)";
                        ++n;
                        n += 0xFF & byArray[n];
                        break;
                    }
                    case 5: {
                        n5 = n + 2 + (0xFF & byArray[n + 1]);
                        string = string + "(";
                        int n7 = n + 2;
                        while (n7 < n5) {
                            string = string + (char)(0xFF & byArray[n7]);
                            ++n7;
                        }
                        string = string + ")";
                    }
                    default: {
                        ++n;
                        n += 0xFF & byArray[n];
                    }
                }
                ++n;
            }
            String string2 = "PID: 0x" + Integer.toHexString(n3).toUpperCase();
            switch (n4) {
                case 89: {
                    this.pic_streams.add(string2 + string);
                    break;
                }
                case 86: {
                    this.ttx_streams.add(string2 + string);
                    break;
                }
                case 27: {
                    this.video_streams.add(string2 + string + "(H.264)");
                    break;
                }
                case 2: 
                case 195: {
                    this.video_streams.add(string2 + string);
                    break;
                }
                case 4: {
                    this.audio_streams.add(string2 + string);
                    break;
                }
                default: {
                    this.audio_streams.add(string2 + string + "[PD]");
                    break;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.playtime = this.playtime + this.msg_6;
        }
    }

    private int testFile(XInputFile xInputFile, boolean bl, int n) {
        long l = xInputFile.length();
        int n2 = this.testFile(xInputFile, bl, 0L, n);
        if (n2 != 0) {
            return n2;
        }
        return this.testFile(xInputFile, bl, l / 10L, n);
    }

    private int testFile(XInputFile xInputFile, boolean bl, long l, int n) {
        this.video_streams.clear();
        this.audio_streams.clear();
        this.ttx_streams.clear();
        this.pic_streams.clear();
        this.pidlist.clear();
        this.addInfo = "";
        this.playtime = "";
        this.hasVideo = false;
        long l2 = 0L;
        int n2 = Integer.parseInt(Common.getSettings().getProperty(Keys.KEY_ScanBuffer));
        if (n2 <= 0) {
            n2 = 1024000;
        }
        int n3 = n2 / 100;
        int n4 = n2 / 50;
        int n5 = n2 / 10;
        int n6 = n2 / 4;
        int n7 = n2 - 65536;
        byte[] byArray = new byte[n2];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n8;
            l2 = xInputFile.length();
            XInputFile xInputFile2 = xInputFile.getNewInstance();
            if (xInputFile2 == null) {
                byArray = null;
                return 0;
            }
            xInputFile2.randomAccessSingleRead(byArray, l);
            int n9 = -1;
            int[] nArray = new int[]{-1, -1, 5, 4, 4, 3, 2, 6, 6, 10, 9, 8, 8, 7, 7, 0, 0, 1};
            int n10 = n8 = nArray[n + 1];
            block16: while (n9 < 0) {
                switch (n10) {
                    case -1: {
                        break;
                    }
                    case 0: {
                        n9 = this.scanRiffAudio(byArray, n3, bl, l2);
                        break;
                    }
                    case 1: {
                        n9 = this.scanSubpicture(byArray, n3, bl);
                        break;
                    }
                    case 2: {
                        n9 = this.scanTS(byArray, n7, bl);
                        break;
                    }
                    case 3: {
                        n9 = this.scanPVA(byArray, n4, bl);
                        break;
                    }
                    case 4: {
                        n9 = this.scanMpg12(byArray, n5, n4, bl);
                        break;
                    }
                    case 5: {
                        n9 = this.scanPrimaryPES(byArray, n7, n6, bl);
                        break;
                    }
                    case 6: {
                        n9 = this.scanSecondaryPES(byArray, n5, n6, bl);
                        break;
                    }
                    case 7: {
                        n9 = this.scanDtsAudio(byArray, n4, bl, l2);
                        break;
                    }
                    case 8: {
                        n9 = this.scanAc3Audio(byArray, n4, bl, l2);
                        break;
                    }
                    case 9: {
                        n9 = this.scanMpgAudio(byArray, n4, bl, l2);
                        break;
                    }
                    case 10: {
                        n9 = this.scanMpgVideo(byArray, n6, bl);
                        break;
                    }
                    default: {
                        break block16;
                    }
                }
                if (n != -1) {
                    n9 = n;
                }
                ++n10;
            }
            byArray = null;
            if (n9 > 0) {
                return n9;
            }
        }
        catch (Exception exception) {
            this.playtime = this.msg_8;
            Common.setExceptionMessage(exception);
        }
        byArray = null;
        return 0;
    }

    private int scanRiffAudio(byte[] byArray, int n, boolean bl, long l) throws Exception {
        this.Audio.setNewType(7);
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.Audio.parseHeader(byArray, n2);
            if (n3 > -1) {
                this.Audio.saveHeader();
                if (bl) {
                    this.audio_streams.add(this.Audio.displayHeader());
                    this.playtime = this.getAudioTime(l);
                }
                if (n3 > 0) {
                    return 14;
                }
                if (this.Audio.getLastModeExtension() > 1) break;
                return 15;
            }
            ++n2;
        }
        return -1;
    }

    private int scanSubpicture(byte[] byArray, int n, boolean bl) throws Exception {
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] == 83 && byArray[n2 + 1] == 80) {
                int n3 = (0xFF & byArray[n2 + 10]) << 8 | 0xFF & byArray[n2 + 11];
                int n4 = (0xFF & byArray[n2 + 12]) << 8 | 0xFF & byArray[n2 + 13];
                int n5 = (0xFF & byArray[n2 + 12 + n4]) << 8 | 0xFF & byArray[n2 + 13 + n4];
                int n6 = (0xFF & byArray[n2 + 36 + n4]) << 8 | 0xFF & byArray[n2 + 37 + n4];
                if (n4 == n5 - 24 && n5 == n6) {
                    if (bl) {
                        int n7 = n2 + 14 + n4;
                        int n8 = n7 + 24;
                        int n9 = n7;
                        block8: while (n9 < n8) {
                            switch (0xFF & byArray[n9]) {
                                case 1: {
                                    ++n9;
                                    break;
                                }
                                case 2: {
                                    n9 += 24;
                                    break;
                                }
                                case 3: 
                                case 4: {
                                    n9 += 2;
                                    break;
                                }
                                case 6: {
                                    n9 += 4;
                                    break;
                                }
                                case 5: {
                                    int n10 = (0xFF & byArray[++n9]) << 4 | (0xF0 & byArray[++n9]) >>> 4;
                                    int n11 = (0xF & byArray[n9]) << 8 | 0xFF & byArray[++n9];
                                    int n12 = (0xFF & byArray[++n9]) << 4 | (0xF0 & byArray[++n9]) >>> 4;
                                    int n13 = (0xF & byArray[n9]) << 8 | 0xFF & byArray[++n9];
                                    this.pic_streams.add("up.left x" + n10 + ",y" + n12 + " @ size " + (n11 - n10 + 1) + "*" + (n13 - n12 + 1));
                                }
                                default: {
                                    break block8;
                                }
                            }
                            ++n9;
                        }
                        byte[] byArray2 = new byte[10 + n3];
                        System.arraycopy(byArray, n2, byArray2, 0, 10 + n3);
                        Common.getSubpictureClass().decode_picture(byArray2, 10, true, new String[2]);
                    }
                    return 16;
                }
            }
            ++n2;
        }
        return -1;
    }

    private int scanTS(byte[] byArray, int n, boolean bl) throws Exception {
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] == 71 && byArray[n2 + 188] == 71 && byArray[n2 + 376] == 71 && byArray[n2 + 564] == 71 && byArray[n2 + 752] == 71) {
                this.readPMT(byArray, n2);
                return 5;
            }
            ++n2;
        }
        return -1;
    }

    private int scanPVA(byte[] byArray, int n, boolean bl) throws Exception {
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if (byArray[n2] == 65 && byArray[n2 + 1] == 86 && byArray[n2 + 4] == 85 && byArray[n3 = n2 + 8 + ((0xFF & byArray[n2 + 6]) << 8 | 0xFF & byArray[n2 + 7])] == 65 && byArray[n3 + 1] == 86 && byArray[n3 + 4] == 85) {
                if (bl) {
                    this.loadPVA(byArray, n2);
                }
                return 4;
            }
            ++n2;
        }
        return -1;
    }

    private int scanMpg12(byte[] byArray, int n, int n2, boolean bl) throws Exception {
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < n) {
            int n4 = CommonParsing.validateStartcode(byArray, n3);
            if (n4 < 0 || CommonParsing.getPES_IdField(byArray, n3) != 186) {
                n3 += (n4 < 0 ? -n4 : 4) - 1;
            } else {
                int n5;
                int n6 = 0xC0 & byArray[n3 + 4];
                if (n6 == 0) {
                    n5 = n3 + 12;
                    if (CommonParsing.validateStartcode(byArray, n5) >= 0 && CommonParsing.getPES_IdField(byArray, n5) >= 179) {
                        if (bl) {
                            this.loadMPG2(byArray, n3, false, true, bl2, n2);
                        }
                        return 2;
                    }
                } else if (n6 == 64 && CommonParsing.validateStartcode(byArray, n5 = n3 + 14 + (7 & byArray[n3 + 13])) >= 0 && CommonParsing.getPES_IdField(byArray, n5) >= 179) {
                    if (bl) {
                        this.loadMPG2(byArray, n3, Common.getSettings().getBooleanProperty(Keys.KEY_simpleMPG), false, bl2, n2);
                    }
                    return 3;
                }
            }
            ++n3;
        }
        return -1;
    }

    private int scanPrimaryPES(byte[] byArray, int n, int n2, boolean bl) throws Exception {
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < n) {
            int n4 = CommonParsing.validateStartcode(byArray, n3);
            if (n4 < 0 || (0xF0 & CommonParsing.getPES_IdField(byArray, n3)) != 224) {
                n3 += (n4 < 0 ? -n4 : 4) - 1;
            } else {
                int n5 = n3 + 6 + CommonParsing.getPES_LengthField(byArray, n3);
                if (n5 == n3 + 6 && (0xC0 & byArray[n3 + 6]) == 128 && (0xC0 & byArray[n3 + 8]) == 0) {
                    this.addInfo = " !!(VPacketLengthField is 0)";
                    n5 = n3;
                    bl2 = true;
                }
                if (CommonParsing.validateStartcode(byArray, n5) >= 0) {
                    if (bl) {
                        this.loadMPG2(byArray, n3, !Common.getSettings().getBooleanProperty(Keys.KEY_enhancedPES), false, bl2, n2);
                    }
                    return 1;
                }
            }
            ++n3;
        }
        return -1;
    }

    private int scanSecondaryPES(byte[] byArray, int n, int n2, boolean bl) throws Exception {
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            int n5 = CommonParsing.validateStartcode(byArray, n3);
            if (n5 < 0) {
                n3 += -n5 - 1;
            } else if (((0xE0 & byArray[n3 + 3]) == 192 || (0xFF & byArray[n3 + 3]) == 189) && CommonParsing.validateStartcode(byArray, n4 = n3 + 6 + CommonParsing.getPES_LengthField(byArray, n3)) >= 0) {
                if ((0xE0 & byArray[n3 + 3]) == 192 && (0xE0 & byArray[n3 + 3]) == (0xE0 & byArray[n4 + 3])) {
                    if (bl) {
                        this.loadMPG2(byArray, n3, true, false, bl2, n2);
                    }
                    return 6;
                }
                if ((0xFF & byArray[n3 + 3]) == 189 && byArray[n3 + 3] == byArray[n4 + 3]) {
                    if (bl) {
                        if (byArray[n3 + 8] == 36 && (0xF0 & byArray[n3 + 9 + 36]) >>> 4 == 1) {
                            this.addInfo = " (TTX)";
                            this.ttx_streams.add("SubID 0x" + Integer.toHexString(0xFF & byArray[n3 + 9 + 36]).toUpperCase());
                        } else {
                            this.loadMPG2(byArray, n3, true, false, bl2, n2);
                        }
                    }
                    return 7;
                }
            }
            ++n3;
        }
        return -1;
    }

    private int scanDtsAudio(byte[] byArray, int n, boolean bl, long l) throws Exception {
        this.Audio.setNewType(6);
        int n2 = 0;
        while (n2 < n) {
            block9: {
                if (this.Audio.parseHeader(byArray, n2) >= 1) {
                    int n3 = 0;
                    while (n3 < 15) {
                        if (this.Audio.parseNextHeader(byArray, n2 + this.Audio.getSize() + n3) == 1) {
                            if ((0xFF & byArray[n2 + this.Audio.getSize()]) <= 127 && (0xFF & byArray[n2 + this.Audio.getSize()]) != 0) {
                                if (bl) {
                                    this.audio_streams.add(this.Audio.saveAndDisplayHeader());
                                    this.playtime = this.getAudioTime(l);
                                }
                                if (n3 == 0) {
                                    return 12;
                                }
                                return 13;
                            }
                            break block9;
                        }
                        ++n3;
                    }
                    if (Common.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_allowSpaces)) {
                        if (bl) {
                            this.audio_streams.add(this.Audio.saveAndDisplayHeader());
                        }
                        this.playtime = this.getAudioTime(l);
                        return 12;
                    }
                }
            }
            ++n2;
        }
        return -1;
    }

    private int scanAc3Audio(byte[] byArray, int n, boolean bl, long l) throws Exception {
        this.Audio.setNewType(0);
        int n2 = 0;
        while (n2 < n) {
            block9: {
                if (this.Audio.parseHeader(byArray, n2) >= 1) {
                    int n3 = 0;
                    while (n3 < 17) {
                        if (this.Audio.parseNextHeader(byArray, n2 + this.Audio.getSize() + n3) == 1) {
                            if ((0xFF & byArray[n2 + this.Audio.getSize()]) <= 63 && (0xFF & byArray[n2 + this.Audio.getSize()]) != 0) {
                                if (bl) {
                                    this.audio_streams.add(this.Audio.saveAndDisplayHeader());
                                    this.playtime = this.getAudioTime(l);
                                }
                                if (n3 == 0) {
                                    return 10;
                                }
                                return 11;
                            }
                            break block9;
                        }
                        ++n3;
                    }
                    if (Common.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_allowSpaces)) {
                        if (bl) {
                            this.audio_streams.add(this.Audio.saveAndDisplayHeader());
                        }
                        this.playtime = this.getAudioTime(l);
                        return 10;
                    }
                }
            }
            ++n2;
        }
        return -1;
    }

    private int scanMpgAudio(byte[] byArray, int n, boolean bl, long l) throws Exception {
        this.Audio.setNewType(2);
        int n2 = 0;
        while (n2 < n) {
            if (this.Audio.parseHeader(byArray, n2) >= 1 && (Common.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_allowSpaces) || this.Audio.parseNextHeader(byArray, n2 + this.Audio.getSize()) >= 0)) {
                if (bl) {
                    this.audio_streams.add(this.Audio.saveAndDisplayHeader());
                    this.playtime = this.getAudioTime(l);
                }
                return 9;
            }
            ++n2;
        }
        return -1;
    }

    private int scanMpgVideo(byte[] byArray, int n, boolean bl) throws Exception {
        if (this.checkVid(byArray, n)) {
            return 8;
        }
        return -1;
    }

    private class ScanObject {
        private ByteArrayOutputStream buf = new ByteArrayOutputStream();
        private int id;
        private int type;

        private ScanObject() {
            this.id = 0;
        }

        private ScanObject(int n) {
            this.id = n;
        }

        private int getType() {
            return this.type;
        }

        private void write(byte[] byArray) throws IOException {
            this.buf.write(byArray);
        }

        private void write(byte[] byArray, int n, int n2) throws IOException {
            this.buf.write(byArray, n, n2);
        }

        private byte[] getData() throws IOException {
            this.buf.flush();
            return this.buf.toByteArray();
        }

        private void reset() {
            this.buf.reset();
        }
    }
}

